﻿// -----------------------------------------------------------------------
// <copyright file="FeedbackDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using EnterpriseWeb.Model;



namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 留言管理 Dal
    /// </summary>
    public static class FeedbackDal
    {
        #region Public Methods

        /// <summary>获得 Feedback 所有数据</summary>
        /// <param name="startRowIndex">起始记录</param>
        /// <param name="maximumRows">最大记录数</param>
        /// <returns>FeedbackCollection 包含所有记录.</returns>
        public static FeedbackCollection GetList( int startRowIndex, int maximumRows )
        {
            FeedbackCollection tempList = new FeedbackCollection( );
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocFeedbackSelectList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@startRowIndex", startRowIndex);
                    myCommand.Parameters.AddWithValue("@maximumRows", maximumRows);
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new FeedbackCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }

        /// <summary>获得 Feedback 通过审查的数据</summary>
        /// <param name="startRowIndex">起始记录</param>
        /// <param name="maximumRows">最大记录数</param>
        /// <param name="isview">是否可查看</param>
        /// <returns>FeedbackCollection 通过审查的数据.</returns>
        public static FeedbackCollection GetList(int startRowIndex, int maximumRows, bool isView)
        {
            FeedbackCollection tempList = new FeedbackCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocFeedbackSelectListByView", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@startRowIndex", startRowIndex);
                    myCommand.Parameters.AddWithValue("@maximumRows", maximumRows);
                    myCommand.Parameters.AddWithValue("@isview", isView);
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new FeedbackCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }



        /// <summary>删除一条留言记录</summary>
        /// <param name="id">留言ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        public static bool Delete(int id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocFeedbackDeleteSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@fb_id", id);
                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改一条留言记录允许字段</summary>
        /// <param name="id">留言ID</param>
        /// <param name="isview">true=允许，false=拒绝</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(int id, bool isview)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocFeedbackUpdateSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@fb_id", id);
                    myCommand.Parameters.AddWithValue("@isview", isview);
                    myConnection.Open();

                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }
        

        /// <summary>插入一条留言记录</summary>
        /// <param name="fb">feedback模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        public static bool Insert(Feedback myFeedback)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocFeedbackInsert", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    if (!string.IsNullOrEmpty(myFeedback.fb_title))
                    {
                        myCommand.Parameters.AddWithValue("@fb_title", myFeedback.fb_title);
                    }
                    myCommand.Parameters.AddWithValue("@fb_name", myFeedback.fb_name);
                    myCommand.Parameters.AddWithValue("@fb_tel", myFeedback.fb_tel);
                    myCommand.Parameters.AddWithValue("@fb_phone", myFeedback.fb_phone);
                    myCommand.Parameters.AddWithValue("@fb_email", myFeedback.fb_email);
                    if (!string.IsNullOrEmpty(myFeedback.fb_content))
                    {
                        myCommand.Parameters.AddWithValue("@fb_content", myFeedback.fb_content);
                    }
                    myCommand.Parameters.AddWithValue("@fb_ip", myFeedback.fb_ip);
                    myCommand.Parameters.AddWithValue("@fb_date", myFeedback.fb_date);
                    myCommand.Parameters.AddWithValue("@isview", myFeedback.isview);


                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        #endregion


        #region Private Methods

        /// <summary>
        /// 初始化一个Feedback类实例，并填充数据。
        /// </summary>
        private static Feedback FillDataRecord(IDataRecord myDataRecord)
        {
            Feedback myFeedback = new Feedback();
            myFeedback.fb_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("fb_id"));
            myFeedback.fb_title = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_title"));
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_name")))
            {
            myFeedback.fb_name = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_name"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_tel")))
            {
                myFeedback.fb_tel = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_tel"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_phone")))
            {
                myFeedback.fb_phone = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_phone"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_email")))
            {
                myFeedback.fb_email = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_email"));
            }
            
            myFeedback.fb_content = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_content"));

            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_ip")))
            {
                myFeedback.fb_ip = myDataRecord.GetString(myDataRecord.GetOrdinal("fb_ip"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("fb_date")))
            {
                myFeedback.fb_date = myDataRecord.GetDateTime(myDataRecord.GetOrdinal("fb_date"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("isview")))
            {
                myFeedback.isview = myDataRecord.GetBoolean(myDataRecord.GetOrdinal("isview"));
            }
            
            
            return myFeedback;
        }

        #endregion

    }
}
