﻿// -----------------------------------------------------------------------
// <copyright file="ProductClassDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 产品分类管理 Dal
    /// </summary>
    public static class ProductClassDal
    {
        #region Public Methods

        /// <summary>查询产品分类 所有数据</summary>
        /// <returns>ProductClassCollection 包含所有记录.</returns>
        public static ProductClassCollection GetList()
        {
            ProductClassCollection tempList = new ProductClassCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassSelectList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ProductClassCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }


        /// <summary>条件查询产品分类 </summary>
        /// <param name="parent_id">父亲ID</param>
        /// <returns>ProductClassCollection 包含条件查询的记录.</returns>
        public static ProductClassCollection GetListByParentID(int parent_id)
        {
            ProductClassCollection tempList = new ProductClassCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassSelectListByParentID", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    if (parent_id > 0)
                    {
                        myCommand.Parameters.AddWithValue("@parent_id", parent_id);
                    }
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ProductClassCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }


        /// <summary>条件查询产品分类 </summary>
        /// <param name="pc_id">产品分类ID</param>
        /// <returns>ProductClass模型 包含一条产品分类记录.</returns>
        public static ProductClass GetItem(int pc_id)
        {
            ProductClass myProductClass = new ProductClass();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassSelectItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@pc_id", pc_id);
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            if (myReader.Read())
                            {
                                myProductClass = FillDataRecord(myReader);
                            }
                        }
                    }
                }
            }
            return myProductClass;
        }


        /// <summary>查询产品分类树 </summary>
        /// <returns>DataSet 包含产品分类树记录.</returns>
        public static DataSet GetTree()
        {
            DataSet ds = new DataSet();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlDataAdapter myAdapter = new SqlDataAdapter())
                {
                    SqlCommand myCommand = new SqlCommand("sprocProductClassGetTree", myConnection);
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myAdapter.SelectCommand = myCommand;

                    myAdapter.Fill(ds, "ProductClass");
                }
            }
            return ds;
        }



        /// <summary>删除一条产品分类记录</summary>
        /// <param name="pc_id">产品分类ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        public static bool Delete(int pc_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassDeleteSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@pc_id", pc_id);
                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改产品分类记录</summary>
        /// <param name="myProductClass">myProductClass 模型</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(ProductClass myProductClass)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassUpdateSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@pc_id", myProductClass.pc_id);
                    myCommand.Parameters.AddWithValue("@pc_name", myProductClass.pc_name);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>插入产品分类记录</summary>
        /// <param name="myProductClass">myProductClass 模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        public static bool Insert(ProductClass myProductClass)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductClassInsert", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@pc_name", myProductClass.pc_name);
                    if (myProductClass.parent_id > 0)
                    {
                        myCommand.Parameters.AddWithValue("@parent_id", myProductClass.parent_id);
                    }

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }

        #endregion



        #region Private Methods

        /// <summary>
        /// 初始化一个ProductClass类实体，并填充数据。
        /// </summary>
        private static ProductClass FillDataRecord(IDataRecord myDataRecord)
        {

            ProductClass myProductClass = new ProductClass();

            myProductClass.pc_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("pc_id"));
            myProductClass.pc_name = myDataRecord.GetString(myDataRecord.GetOrdinal("pc_name"));
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("parent_id")))
            {
                myProductClass.parent_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("parent_id"));
            }

            myProductClass.pc_order = myDataRecord.GetInt32(myDataRecord.GetOrdinal("pc_order"));


            return myProductClass;
        }

        #endregion
    }
}
