﻿// -----------------------------------------------------------------------
// <copyright file="ProductDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 产品管理 Dal
    /// </summary>
    public static class ProductDal
    {
        #region Public Methods

        /// <summary>查询产品 所有数据</summary>
        /// <returns>ProductCollection 包含所有记录.</returns>
        public static ProductCollection GetList(int pc_id, int startRowIndex, int maximumRows)
        {
            ProductCollection tempList = new ProductCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductSelectList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@pc_id", pc_id);
                    if (startRowIndex > 0 && maximumRows > 0)
                    {
                        myCommand.Parameters.AddWithValue("@startRowIndex", startRowIndex);
                        myCommand.Parameters.AddWithValue("@maximumRows", maximumRows);
                    }
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ProductCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }



        /// <summary>条件查询产品 </summary>
        /// <param name="istop">置顶</param>
        /// <param name="iscommend">推荐</param>
        /// <returns>ProductCollection 包含条件查询的记录.</returns>
        public static ProductCollection GetList(bool istop, bool iscommend)
        {
            ProductCollection tempList = new ProductCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductSelectListByParentID", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    if (istop)
                    {
                        myCommand.Parameters.AddWithValue("@istop", istop);
                    }
                    if (iscommend)
                    {
                        myCommand.Parameters.AddWithValue("@iscommend", iscommend);
                    }

                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ProductCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }


        /// <summary>条件查询产品 </summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>Product模型 包含一条产品记录.</returns>
        public static Product GetItem(int prod_id)
        {
            Product myProduct = new Product();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductSelectItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@prod_id", prod_id);
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            if (myReader.Read())
                            {
                                myProduct = FillDataRecord(myReader);
                            }
                        }
                    }
                }
            }
            return myProduct;
        }


        /// <summary>删除一条产品记录</summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        public static bool Delete(int prod_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductDeleteSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@prod_id", prod_id);
                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改产品点击数</summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(int prod_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductUpdateSingleClick", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@prod_id", prod_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改产品</summary>
        /// <param name="myProduct">产品模型</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(Product myProduct)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductUpdateSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@prod_id", myProduct.prod_id);
                    myCommand.Parameters.AddWithValue("@prod_name", myProduct.prod_name);
                    myCommand.Parameters.AddWithValue("@prod_number", myProduct.prod_number);
                    myCommand.Parameters.AddWithValue("@prod_price", myProduct.prod_price);
                    myCommand.Parameters.AddWithValue("@prod_image", myProduct.prod_image);
                    myCommand.Parameters.AddWithValue("@prod_content", myProduct.prod_content);
                    myCommand.Parameters.AddWithValue("@prod_date", myProduct.prod_date);
                    myCommand.Parameters.AddWithValue("@prod_click", myProduct.prod_click);
                    myCommand.Parameters.AddWithValue("@istop", myProduct.istop);
                    myCommand.Parameters.AddWithValue("@iscommend", myProduct.iscommend);
                    myCommand.Parameters.AddWithValue("@pc_id", myProduct.pc_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>插入产品记录</summary>
        /// <param name="myProduct">myProduct 模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        public static bool Insert(Product myProduct)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocProductInsert", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@prod_name", myProduct.prod_name);
                    myCommand.Parameters.AddWithValue("@prod_number", myProduct.prod_number);
                    myCommand.Parameters.AddWithValue("@prod_price", myProduct.prod_price);
                    myCommand.Parameters.AddWithValue("@prod_image", myProduct.prod_image);
                    myCommand.Parameters.AddWithValue("@prod_content", myProduct.prod_content);
                    myCommand.Parameters.AddWithValue("@prod_date", myProduct.prod_date);
                    myCommand.Parameters.AddWithValue("@prod_click", myProduct.prod_click);
                    myCommand.Parameters.AddWithValue("@istop", myProduct.istop);
                    myCommand.Parameters.AddWithValue("@iscommend", myProduct.iscommend);
                    myCommand.Parameters.AddWithValue("@pc_id", myProduct.pc_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        #endregion


        #region Private Methods

        /// <summary>
        /// 初始化一个Product类实体，并填充数据。
        /// </summary>
        private static Product FillDataRecord(IDataRecord myDataRecord)
        {
            Product myProduct = new Product();

            myProduct.prod_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("prod_id"));
            myProduct.prod_name = myDataRecord.GetString(myDataRecord.GetOrdinal("prod_name"));
            myProduct.prod_content = myDataRecord.GetString(myDataRecord.GetOrdinal("prod_content"));
            myProduct.prod_date = myDataRecord.GetDateTime(myDataRecord.GetOrdinal("prod_date"));
            myProduct.pc_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("pc_id"));

            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("prod_number")))
            {
                myProduct.prod_number = myDataRecord.GetString(myDataRecord.GetOrdinal("prod_number"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("prod_price")))
            {
                myProduct.prod_price = myDataRecord.GetDecimal(myDataRecord.GetOrdinal("prod_price"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("prod_image")))
            {
                myProduct.prod_image = myDataRecord.GetString(myDataRecord.GetOrdinal("prod_image"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("prod_click")))
            {
                myProduct.prod_click = myDataRecord.GetInt32(myDataRecord.GetOrdinal("prod_click"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("istop")))
            {
                myProduct.istop = myDataRecord.GetBoolean(myDataRecord.GetOrdinal("istop"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("iscommend")))
            {
                myProduct.iscommend = myDataRecord.GetBoolean(myDataRecord.GetOrdinal("iscommend"));
            }
            return myProduct;
        }

        #endregion
    }
}
