﻿// -----------------------------------------------------------------------
// <copyright file="SitePropertyDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 站点属性设置 Dal
    /// </summary>
    public static class SitePropertyDal
    {
        #region Public Methods

        /// <summary>获得 SiteProperty表数据</summary>
        /// <returns>SiteProperty模型  包含所有记录.</returns>
        public static SiteProperty GetSiteProperty()
        {
            SiteProperty sp = new SiteProperty();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocSitePropertySelectItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            myReader.Read();
                            sp.site_id = myReader.GetInt32(myReader.GetOrdinal("site_id"));
                            if (!myReader.IsDBNull(myReader.GetOrdinal("site_name")))
                            {
                                sp.site_name = myReader.GetString(myReader.GetOrdinal("site_name"));
                            }
                            if (!myReader.IsDBNull(myReader.GetOrdinal("site_url")))
                            {
                                sp.site_url = myReader.GetString(myReader.GetOrdinal("site_url"));
                            }
                            if (!myReader.IsDBNull(myReader.GetOrdinal("site_logo")))
                            {
                                sp.site_logo = myReader.GetString(myReader.GetOrdinal("site_logo"));
                            }
                            if (!myReader.IsDBNull(myReader.GetOrdinal("site_keyword")))
                            {
                                sp.site_keyword = myReader.GetString(myReader.GetOrdinal("site_keyword"));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return sp;
        }

        /// <summary>修改SiteProperty表</summary>
        /// <param name="sp">sp--SiteProperty模版</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(SiteProperty sp)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocSitePropertyUpdateItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@site_id", sp.site_id);
                    myCommand.Parameters.AddWithValue("@site_name", sp.site_name);
                    myCommand.Parameters.AddWithValue("@site_url", sp.site_url);
                    myCommand.Parameters.AddWithValue("@site_logo", sp.site_logo);
                    myCommand.Parameters.AddWithValue("@site_keyword", sp.site_keyword);
                    myConnection.Open();

                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        #endregion
    }
}
