﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;

public partial class Admin_FeedbackMng : System.Web.UI.Page
{
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            AspNetPager1.RecordCount = FeedbackBll.GetList(1,1000).Count;
        }
    }


    protected void DataSourceFeedback_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        if (!e.ExecutingSelectCount)
        {
            e.Arguments.StartRowIndex = this.AspNetPager1.StartRecordIndex;
            e.Arguments.MaximumRows = this.AspNetPager1.PageSize;
        }
    }


    /// <summary>修改允许查看</summary>
    protected void DatalistFeedback_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = (Int32)DatalistFeedback.DataKeys[e.Item.ItemIndex];

        FeedbackBll.Update(id, true);
        this.DatalistFeedback.DataBind();
    }

    /// <summary>修改拒绝查看</summary>
    protected void DatalistFeedback_CancelCommand(object source, DataListCommandEventArgs e)
    {
        int id = (Int32)DatalistFeedback.DataKeys[e.Item.ItemIndex];

        FeedbackBll.Update(id, false);
        this.DatalistFeedback.DataBind();
    }

    /// <summary>删除记录</summary>
    protected void DatalistFeedback_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = (Int32)DatalistFeedback.DataKeys[e.Item.ItemIndex];

        FeedbackBll.Delete(id);
        this.DatalistFeedback.DataBind();
    }




    protected void DatalistFeedback_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            ImageButton db = (ImageButton)e.Item.FindControl("ibtDelete");
            ImageButton ub = (ImageButton)e.Item.FindControl("ibtAllow");
            ImageButton cb = (ImageButton)e.Item.FindControl("ibtDeny");

            Feedback f = ((Feedback)e.Item.DataItem);

            db.OnClientClick =
                string.Format("return confirm('你确认要删除 \"{0}\" 这条留言吗？');", f.fb_title.Replace("'", @"\'"));

            if (f.isview)
            {
                ub.Visible = false;
                cb.Visible = true;
            }
            else 
            {
                ub.Visible = true;
                cb.Visible = false;
            }
        }
    }
}
