﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;


public partial class Admin_ProductAdd : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ProductClassDDL1.LoadTree();
        }
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (!ProductClassBll.IsLeafNode(Convert.ToInt32(ProductClassDDL1.CurrentValue)))
        {
            RegisterClientScriptBlock("err", "<script >alert('产品只能添加到子分类，请选择一个正确的分类!');</script>");
        }
        else
        {
            Product myProduct = new Product();

            myProduct.prod_name = this.tbxName.Text;
            myProduct.prod_number = this.tbxNumber.Text;
            if (!string.IsNullOrEmpty(this.tbxPrice.Text))
            {
                myProduct.prod_price = Convert.ToDecimal(this.tbxPrice.Text);
            }
            myProduct.prod_content = FCKeditor1.Value.ToString();
            myProduct.prod_click = 0;
            myProduct.prod_date = DateTime.Now;
            myProduct.istop = this.cbxTop.Checked;
            myProduct.iscommend = this.cbxCommend.Checked;
            myProduct.pc_id = Convert.ToInt32(ProductClassDDL1.CurrentValue);

            if (string.IsNullOrEmpty(this.tbxImage.Text) || this.tbxImage.Text == " ")
            {
                string fckStr = FCKeditor1.Value;
                MatchCollection matchs = Regex.Matches(fckStr, @"<img[^src]*src=""[^http\://]*(?<src>[^""]*?)""", RegexOptions.IgnoreCase);
                foreach (Match m in matchs)
                {
                    myProduct.prod_image = m.Groups["src"].Value.ToString();
                    break;
                }
                if (string.IsNullOrEmpty(myProduct.prod_image))
                {
                    myProduct.prod_image = " ";
                }
            }
            else
            {
                myProduct.prod_image = this.tbxImage.Text.Trim();
            }


            if (ProductBll.Insert(myProduct))
            {
                Response.Write("<script>alert('产品添加成功!!!');window.location.href=document.URL;</script>");

            }
            else
            {
                this.lblError.Visible = true;
            }
        }
    }
}
