﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using EnterpriseWeb.Bll;
using EnterpriseWeb.Model;

public partial class Admin_ProductEdit : System.Web.UI.Page
{
    static Product myProduct = new Product();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                myProduct = ProductBll.GetItem(Convert.ToInt32(Request.QueryString["id"]));

                if (string.IsNullOrEmpty(myProduct.prod_name))
                {
                    Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ProductMng.aspx'</script>");
                }
                else
                {
                    this.ProductClassDDL1.LoadTree();
                    this.ProductClassDDL1.InnerDropDownListTree.Items.FindByValue(myProduct.pc_id.ToString()).Selected = true;

                    this.tbxName.Text = myProduct.prod_name;
                    this.tbxNumber.Text = myProduct.prod_number;
                    this.tbxPrice.Text = string.Format("{0:N2}", myProduct.prod_price);
                    this.tbxImage.Text = myProduct.prod_image;
                    FCKeditor1.Value = myProduct.prod_content;
                    this.cbxTop.Checked = myProduct.istop;
                    this.cbxCommend.Checked = myProduct.iscommend;
                    Page.Title = myProduct.prod_name;
                }

            }
            else
            {
                Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ProductMng.aspx'</script>");
            }

        }

    }
    protected void btnConfirm_Click(object sender, EventArgs e)
    {
        if (!ProductClassBll.IsLeafNode(Convert.ToInt32(ProductClassDDL1.CurrentValue)))
        {
            RegisterClientScriptBlock("err", "<script >alert('产品只能添加到子分类，请选择一个正确的分类!');</script>");
        }
        else
        {
            string SelectedValue = ProductClassDDL1.CurrentValue;
            myProduct.prod_name = this.tbxName.Text;
            myProduct.prod_number = this.tbxNumber.Text;
            if (!string.IsNullOrEmpty(this.tbxPrice.Text))
            {
                myProduct.prod_price = Convert.ToDecimal(this.tbxPrice.Text);
            }
            myProduct.prod_content = FCKeditor1.Value.ToString();
            myProduct.prod_click = 0;
            myProduct.prod_date = DateTime.Now;
            myProduct.istop = this.cbxTop.Checked;
            myProduct.iscommend = this.cbxCommend.Checked;
            myProduct.pc_id = Convert.ToInt32(ProductClassDDL1.CurrentValue);

            if (string.IsNullOrEmpty(this.tbxImage.Text) || this.tbxImage.Text == " ")
            {
                string fckStr = FCKeditor1.Value;
                MatchCollection matchs = Regex.Matches(fckStr, @"<img[^src]*src=""[^http\://]*(?<src>[^""]*?)""", RegexOptions.IgnoreCase);
                foreach (Match m in matchs)
                {
                    myProduct.prod_image = m.Groups["src"].Value.ToString();
                    break;
                }
                if (string.IsNullOrEmpty(myProduct.prod_image))
                {
                    myProduct.prod_image = " ";
                }
            }
            else
            {
                myProduct.prod_image = this.tbxImage.Text.Trim();
            }

            if (ProductBll.Update(myProduct))
            {
                Response.Write("<script language=JavaScript>alert('文章修改成功!!!');window.location.href='ProductMng.aspx';</script>");

            }
            else
            {
                this.lblError.Text = myProduct.prod_id.ToString();
                this.lblError.Visible = true;
            }
        }
    }
}
