﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;

public partial class Admin_ProductMng : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            LoadTree();
            AspNetPager1.RecordCount = ProductBll.GetList(Convert.ToInt32(this.DropDownListTree.SelectedValue)).Count;

        }

    }
    protected void ObjectDataSourceProduct_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        if (!e.ExecutingSelectCount)
        {
            e.Arguments.StartRowIndex = this.AspNetPager1.StartRecordIndex;
            e.Arguments.MaximumRows = this.AspNetPager1.PageSize;
        }

    }


    protected void LoadTree()
    {
        this.DropDownListTree.Items.Clear();

        DataSet ds = ProductClassBll.GetTree();
        string strName = null;

        for (int i = 0; i < ds.Tables["ProductClass"].Rows.Count; i++)
        {
            strName = null;
            for (int j = 0; j < Convert.ToInt32(ds.Tables["ProductClass"].Rows[i]["depth"]); j++)
            {
                strName = strName + (char)0xa0 + (char)0xa0 + (char)0xa0;
            }
            strName = strName + ">" + ds.Tables["ProductClass"].Rows[i]["pc_name"].ToString();

            ListItem li = new ListItem(strName, ds.Tables["ProductClass"].Rows[i]["pc_id"].ToString());


            this.DropDownListTree.Items.Insert(i, li);
        }

    }

    protected void DropDownListTree_SelectedIndexChanged(object sender, EventArgs e)
    {
        AspNetPager1.RecordCount = ProductBll.GetList(Convert.ToInt32(this.DropDownListTree.SelectedValue)).Count;
    }
    protected void GridViewProduct_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
        AspNetPager1.RecordCount = ProductBll.GetList(Convert.ToInt32(this.DropDownListTree.SelectedValue)).Count;
    }

    protected void GridViewProduct_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            Image imgt = (Image)e.Row.FindControl("imgTop");
            Image imgc = (Image)e.Row.FindControl("imgCommend");
            Label lblPcName = (Label)e.Row.FindControl("lblPcName");

            Product myProduct = ((Product)e.Row.DataItem);
            if (myProduct.istop)
            {
                imgt.Visible = true;
            }
            if (myProduct.iscommend)
            {
                imgc.Visible = true;
            }

            int prodID = (Int32)GridViewProduct.DataKeys[e.Row.RowIndex].Value;
            int pcID = ProductBll.GetItem(prodID).pc_id;

            lblPcName.Text = ProductClassBll.GetItem(pcID).pc_name;
        }
    }
}
