﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;
using System.Text;

public partial class Setting : System.Web.UI.Page
{
    private static int spid { get; set;}

    private static SiteProperty mySiteProperty = SitePropertyBll.GetSiteProperty();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {

            spid = mySiteProperty.site_id;
            this.tbxSiteName.Text = mySiteProperty.site_name;
            this.tbxSiteUrl.Text = mySiteProperty.site_url;
            this.tbxKeyword.Text = mySiteProperty.site_keyword;
            this.imgLogo.ImageUrl = "~/images/" + mySiteProperty.site_logo;

        }

        
    }
    protected void btnUpdate_Click(object sender, EventArgs e)
    {

        mySiteProperty.site_id = spid;
        mySiteProperty.site_name = this.tbxSiteName.Text.Trim();
        mySiteProperty.site_url = this.tbxSiteUrl.Text.Trim();
        mySiteProperty.site_logo = System.IO.Path.GetFileName(imgLogo.ImageUrl);
        mySiteProperty.site_keyword = this.tbxKeyword.Text.Trim();
        
        if ( SitePropertyBll.Update(mySiteProperty) )
        {
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, this.GetType(), "click", "alert('更新成功!!!')", true);

        }

    }


    protected void btnUpload_Click(object sender, EventArgs e)
    {
        if (this.FileUploadLogo.HasFile && (FileUploadLogo.FileBytes.Length < 100000))
        {
            if (FileUploadLogo.PostedFile.ContentType.CompareTo("image/pjpeg") == 0
                || FileUploadLogo.PostedFile.ContentType.CompareTo("image/gif") == 0
                || FileUploadLogo.PostedFile.ContentType.CompareTo("image/x-png") == 0
                )
            {
                
                string savePath = "~/images/";
                string fileName = FileUploadLogo.FileName;
                string pathToCheck = savePath + fileName;
                string tempfileName = "";

                
                //文件存在更改文件名
                if (System.IO.File.Exists(Server.MapPath(pathToCheck)))
                {
                    int counter = 2;
                    while (System.IO.File.Exists(Server.MapPath(pathToCheck)))
                    {
                        tempfileName = counter.ToString() + fileName;
                        pathToCheck = savePath + tempfileName;
                        counter++;
                    }
                    fileName = tempfileName;

                }
                
                mySiteProperty.site_logo = fileName;
                savePath += fileName;
                savePath = Server.MapPath(savePath);
                FileUploadLogo.SaveAs(savePath);

                this.imgLogo.ImageUrl = "~/images/" + mySiteProperty.site_logo;

            }
            else
            {
                this.lblPrompt.Text = "请选择一个的系统支持图片的文件。";
            }

        }
        else
        {
            this.lblPrompt.Text = "请选择一个要上传文件,上传文件必须小于100KB。";
        }
    }
}
