﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage/Web.master" AutoEventWireup="true" CodeFile="ArticleList.aspx.cs" Inherits="ArticleList" Title="文章列表" %>
<%@ Register assembly="AspNetPager" namespace="Wuqi.Webdiyer" tagprefix="webdiyer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<div class="innerContent">
        <span class="titleContent">
             <a href="ArticleList.aspx">所有分类</a> <%=acnav%>        
        </span>
       <div class="info">
           <asp:Repeater ID="RepeaterArticleClass" runat="server" 
               DataSourceID="ObjectDataSourceArticleClass" 
               onitemdatabound="RepeaterArticleClass_ItemDataBound">
               <HeaderTemplate>
                    <table ><thead><th>文章分类</th></thead><tr><td > 
               </HeaderTemplate>
               <ItemTemplate>
                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# "ArticleList.aspx?id=" + Eval("ac_id") %>' Text='<%# Eval("ac_name")%>' CssClass="NodeName"></asp:HyperLink>
               </ItemTemplate>
               <FooterTemplate>
               </td></tr></table>
               </FooterTemplate>
           </asp:Repeater>
           <asp:ObjectDataSource ID="ObjectDataSourceArticleClass" runat="server" 
               OldValuesParameterFormatString="original_{0}" SelectMethod="GetListByParentID" 
               TypeName="EnterpriseWeb.Bll.ArticleClassBll">
               <SelectParameters>
                   <asp:Parameter DefaultValue="2" Name="parent_id" Type="Int32" />
               </SelectParameters>
           </asp:ObjectDataSource>  
           
                
        <br />   
                
           <asp:GridView ID="GridViewArticle" runat="server" AutoGenerateColumns="False" 
               DataKeyNames="art_id" DataSourceID="ObjectDataSourceArticle" 
               CssClass="noborder" GridLines="None">
               <Columns>
                   <asp:TemplateField HeaderText="标题" >
                   <ItemTemplate>
                       <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl='<%# "ArticleShow.aspx?id=" + Eval("art_id") %>' Text='<%# Eval("art_title")%>' CssClass="LabelStyle boldLink"></asp:HyperLink>
                       <br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                       <asp:Label ID="lblDescription" runat="server" Text='<%# Eval("art_description")%>' ></asp:Label>...
                   </ItemTemplate>
                   <HeaderStyle HorizontalAlign="Center" CssClass="noborder"/>
                   <ItemStyle Width="60%" CssClass="noborder" />
                   </asp:TemplateField>
                   <asp:BoundField DataField="art_from" HeaderText="来源" 
                       SortExpression="art_from">
                       <HeaderStyle HorizontalAlign="Center" CssClass="noborder" />
                       <ItemStyle HorizontalAlign="Center" CssClass="noborder" />
                   </asp:BoundField>
                   <asp:BoundField DataField="art_date" HeaderText="日期" 
                       SortExpression="art_date" DataFormatString="{0:d}">
                       <HeaderStyle HorizontalAlign="Center" CssClass="noborder"/>
                       <ItemStyle HorizontalAlign="Center" CssClass="noborder" />
                   </asp:BoundField>
               </Columns>
           </asp:GridView>
           
           <asp:ObjectDataSource ID="ObjectDataSourceArticle" runat="server" 
               OldValuesParameterFormatString="original_{0}" SelectMethod="GetList" 
               TypeName="EnterpriseWeb.Bll.ArticleBll" 
               onselecting="ObjectDataSourceArticle_Selecting">
               <SelectParameters>
                   <asp:Parameter DefaultValue="2" Name="ac_id" Type="Int32" />
                   <asp:ControlParameter ControlID="AspNetPager1" DefaultValue="1" 
                       Name="startRowIndex" PropertyName="StartRecordIndex" Type="Int32" />
                   <asp:ControlParameter ControlID="AspNetPager1" DefaultValue="10" 
                       Name="maximumRows" PropertyName="PageSize" Type="Int32" />
               </SelectParameters>
           </asp:ObjectDataSource>
           
         <webdiyer:AspNetPager ID="AspNetPager1" runat="server" FirstPageText="首页"  
                            LastPageText="尾页" NextPageText="下一页" PrevPageText="上一页" ShowFirstLast="False" 
                            ShowMoreButtons="False" ShowPageIndexBox="Never" PageSize="6" CssClass="anpager" 
            CurrentPageButtonClass="cpb" CustomInfoHTML="文章共（%RecordCount%）篇" 
            ShowCustomInfoSection="Left"  >
          </webdiyer:AspNetPager>
           </div>
 </div>

</asp:Content>

