﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;
using EnterpriseWeb.Common;


public partial class ArticleList : System.Web.UI.Page
{
    public string acnav { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        string parentID = null;
        try
        {
            parentID = Request.QueryString["id"].ToString();
        }
        catch (Exception ex)
        {
        }

        if (BaseCommon.ValidQueryString(parentID))
        {
            acnav = ArticleClassBll.ArticleClassNav(Convert.ToInt32(parentID), acnav);
            if (!IsPostBack)
            {
                this.ObjectDataSourceArticleClass.SelectParameters["parent_id"].DefaultValue = parentID;
                this.RepeaterArticleClass.DataBind();

                this.ObjectDataSourceArticle.SelectParameters["ac_id"].DefaultValue = parentID;
                AspNetPager1.RecordCount = ArticleBll.GetList(Convert.ToInt32(parentID)).Count;
            }
        }
        else
        {
            acnav = ArticleClassBll.ArticleClassNav(2, acnav);
            AspNetPager1.RecordCount = ArticleBll.GetList(2).Count;
            //Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ArticleList.aspx'</script>");
            //Response.Write("错误的链接!");

        }
    }
    protected void RepeaterArticleClass_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (RepeaterArticleClass.Items.Count == 0)
        {
            this.RepeaterArticleClass.Visible = false;
        }
        else
        {
            this.RepeaterArticleClass.Visible = true;
        }
    }
    protected void ObjectDataSourceArticle_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        if (!e.ExecutingSelectCount)
        {
            e.Arguments.StartRowIndex = this.AspNetPager1.StartRecordIndex;
            e.Arguments.MaximumRows = this.AspNetPager1.PageSize;
        }
    }
}
