﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;
using EnterpriseWeb.Common;

public partial class ArticleShow : System.Web.UI.Page
{
    public string acnav { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Master.SetSiteProperty();
            string artID = null;
            try
            {
                artID = Request.QueryString["id"].ToString();
            }
            catch(Exception ex)
            {
            }


            Article myArticle = new Article();
            if (BaseCommon.ValidQueryString(artID))
            {
                ArticleBll.Update(Convert.ToInt32(artID));
                myArticle = ArticleBll.GetItem(Convert.ToInt32(artID));

                acnav = ArticleClassBll.ArticleClassNav(myArticle.ac_id, acnav);

                Page.Title = myArticle.art_title;
                HtmlMeta keywords = (HtmlMeta)Master.FindControl("keywords");
                HtmlMeta Description = (HtmlMeta)Master.FindControl("Description");


                keywords.Attributes["content"] = keywords.Attributes["content"] + "," + myArticle.art_title;
                Description.Attributes["content"] = Description.Attributes["content"] + "," + myArticle.art_description;

                this.lblTitle.Text = myArticle.art_title;
                this.lblDate.Text = myArticle.art_date.ToString();
                this.lblAuthor.Text = myArticle.art_author;
                this.lblFrom.Text = myArticle.art_from;
                this.lblClick.Text = myArticle.art_click.ToString();
                this.lblContent.Text = myArticle.art_content;
            }
            else
            {
                //Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ArticleList.aspx'</script>");
                Response.Write("错误的链接!");

            }

        }
    }


}
