﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage/Web.master" AutoEventWireup="true" CodeFile="ProductList.aspx.cs" Inherits="ProductList" Title="产品列表" %>

<%@ Register assembly="AspNetPager" namespace="Wuqi.Webdiyer" tagprefix="webdiyer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<div class="innerContent">
        <span class="titleContent">
                <a href="ProductList.aspx">产品列表</a> <%=pcnav%>
        </span>
       <div class="info">
        
           <asp:Repeater ID="RepeaterProductClass" runat="server" 
               DataSourceID="ObjectDataSourceProductClass" 
               onitemdatabound="RepeaterProductClass_ItemDataBound">
               <HeaderTemplate>
                    <table ><thead><th>产品分类</th></thead><tr><td > 
               </HeaderTemplate>
               <ItemTemplate>
                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# "ProductList.aspx?id=" + Eval("pc_id") %>' Text='<%# Eval("pc_name")%>' CssClass="NodeName"></asp:HyperLink>
               </ItemTemplate>
               <FooterTemplate>
               </td></tr></table>
               </FooterTemplate>
           </asp:Repeater>
           <asp:ObjectDataSource ID="ObjectDataSourceProductClass" runat="server" 
               OldValuesParameterFormatString="original_{0}" SelectMethod="GetListByParentID" 
               TypeName="EnterpriseWeb.Bll.ProductClassBll">
               <SelectParameters>
                   <asp:Parameter DefaultValue="0" Name="parent_id" Type="Int32" />
               </SelectParameters>
           </asp:ObjectDataSource>
        
       
           <asp:DataList ID="DataList1" runat="server" DataKeyField="prod_id" 
               DataSourceID="ObjectDataSourceProduct" RepeatColumns="2">
               <ItemTemplate>
                <table style="width:97%;">
                <tr><td class="noborder" width="50%">
                   <a href='<%# "ProductShow.aspx?id=" + Eval("prod_id") %>'>
                   <asp:Image ID="imgProd"  runat="server" ImageUrl='<%# Eval("prod_image") %>'  AlternateText='<%# Eval("prod_name") %>' CssClass="imgProduct" /></a>
                </td>
                <td class="noborder">
                   名称:
                   <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl='<%# "ProductShow.aspx?id=" + Eval("prod_id") %>' Text='<%# Eval("prod_name")%>' CssClass="LabelStyle"></asp:HyperLink>
                   <br />
                   型号:
                   <asp:Label ID="prod_numberLabel" runat="server" 
                       Text='<%# Eval("prod_number") %>' />
                   <br />
                   日期:
                   <asp:Label ID="prod_dateLabel" runat="server" Text=' <%# string.Format("{0:d}", Eval("prod_date")) %>' />
                   <br />
                   </td></tr>
                </table>   
               </ItemTemplate>
               <ItemStyle Width="50%" />
           </asp:DataList>
           <asp:ObjectDataSource ID="ObjectDataSourceProduct" runat="server" 
               OldValuesParameterFormatString="original_{0}" SelectMethod="GetList" 
               TypeName="EnterpriseWeb.Bll.ProductBll" 
               onselecting="ObjectDataSourceProduct_Selecting">
               <SelectParameters>
                   <asp:Parameter DefaultValue="0"  Name="pc_id" Type="Int32" />
                   <asp:ControlParameter ControlID="AspNetPager1" PropertyName="StartRecordIndex" 
                       Name="startRowIndex" Type="Int32"  />
                   <asp:ControlParameter ControlID="AspNetPager1"  PropertyName="PageSize"   
                       Name="maximumRows" Type="Int32" />
               </SelectParameters>
           </asp:ObjectDataSource>
         <webdiyer:AspNetPager ID="AspNetPager1" runat="server" FirstPageText="首页"  
                            LastPageText="尾页" NextPageText="下一页" PrevPageText="上一页" ShowFirstLast="False" 
                            ShowMoreButtons="False" ShowPageIndexBox="Never" PageSize="6" CssClass="anpager" 
            CurrentPageButtonClass="cpb" CustomInfoHTML="产品共（%RecordCount%）条" 
            ShowCustomInfoSection="Left"  >
          </webdiyer:AspNetPager>
        
       </div>
</div>
</asp:Content>

