﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;
using EnterpriseWeb.Common;

//５１aｓｐｘ
public partial class ProductList : System.Web.UI.Page
{
    public string pcnav { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        string parentID = null;
        try
        {
            parentID = Request.QueryString["id"].ToString();
        }
        catch (Exception ex)
        {
        }

        if (BaseCommon.ValidQueryString(parentID))
        {
            pcnav = ProductClassBll.ProductClassNav(Convert.ToInt32(parentID),pcnav);
            if (!IsPostBack)
            {
                this.ObjectDataSourceProductClass.SelectParameters["parent_id"].DefaultValue = parentID;
                this.RepeaterProductClass.DataBind();

                this.ObjectDataSourceProduct.SelectParameters["pc_id"].DefaultValue = parentID;
                AspNetPager1.RecordCount = ProductBll.GetList(Convert.ToInt32(parentID)).Count;
            }
        }
        else
        {
            AspNetPager1.RecordCount = ProductBll.GetList(0).Count;
            //Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ProductList.aspx'</script>");
            //Response.Write("错误的链接!");

        }
    }
    protected void RepeaterProductClass_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (RepeaterProductClass.Items.Count == 0)
        {
            this.RepeaterProductClass.Visible = false;
        }
        else
        {
            this.RepeaterProductClass.Visible = true;
        }

    }
    protected void ObjectDataSourceProduct_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        if (!e.ExecutingSelectCount)
        {
            e.Arguments.StartRowIndex = this.AspNetPager1.StartRecordIndex;
            e.Arguments.MaximumRows = this.AspNetPager1.PageSize;
        }

    }


}
//5１aｓｐｘ