﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using EnterpriseWeb.Model;
using EnterpriseWeb.Bll;
using EnterpriseWeb.Common;


public partial class ProductShow : System.Web.UI.Page
{
    public string pcnav { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Master.SetSiteProperty();
            string prodID = null;
            try
            {
                prodID = Request.QueryString["id"].ToString();
            }
            catch (Exception ex)
            {
            }


            Product myProduct = new Product();
            if (BaseCommon.ValidQueryString(prodID))
            {
                ProductBll.Update(Convert.ToInt32(prodID));
                myProduct = ProductBll.GetItem(Convert.ToInt32(prodID));

                pcnav = ProductClassBll.ProductClassNav(Convert.ToInt32(myProduct.pc_id), pcnav);

                Page.Title = myProduct.prod_name;
                HtmlMeta keywords = (HtmlMeta)Master.FindControl("keywords");
                HtmlMeta Description = (HtmlMeta)Master.FindControl("Description");

                //Response.Write(keywords.Attributes["content"].ToString());

                keywords.Attributes["content"] = keywords.Attributes["content"] + "," + myProduct.prod_name;
                Description.Attributes["content"] = Description.Attributes["content"] + "," + myProduct.prod_name;

                this.lblTitle.Text = myProduct.prod_name;
                this.lblDate.Text = myProduct.prod_date.ToString();
                this.lblPrice.Text = myProduct.prod_price.ToString("C");
                this.lblNumber.Text = myProduct.prod_number;
                this.lblClick.Text = myProduct.prod_click.ToString();
                this.lblContent.Text = myProduct.prod_content;
            }
            else
            {
                //Response.Write("<script language=JavaScript>alert('错误的链接!');document.location.href='ProductList.aspx'</script>");
                Response.Write("错误的链接!");

            }

        }
    }
}
