﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page 
{
    static DataSet ds = new DataSet();
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Title = ConfigurationManager.AppSettings["WebTitle"].ToString() + "--产品展示";
        if (!Page.IsPostBack)
        {
            ds = Getproduct();
            lblCurrent.Text = "1";
            Bindproduct();
           
        }
        
    }
    //绑定产品控件和分页
    private void Bindproduct()
    {             
        PagedDataSource pds = new PagedDataSource();
        pds.DataSource = ds.Tables[0].DefaultView;
        pds.AllowPaging = true;
        pds.PageSize = 20;
        int CurrentPage = Convert.ToInt32(lblCurrent.Text);
        pds.CurrentPageIndex = CurrentPage-1;
        lblTotal.Text = pds.PageCount.ToString();
        if (CurrentPage == 1)
        {
            FirstPage.Enabled = false;
            PrePage.Enabled = false;
            NextPage.Enabled = true;
            LastPage.Enabled = true;
        }
        if (CurrentPage == pds.PageCount)
        {
            NextPage.Enabled = false;
            LastPage.Enabled = false;
            FirstPage.Enabled = true;
            PrePage.Enabled = true;
        }
        if (CurrentPage > 1 && CurrentPage < pds.PageCount)
        {
            FirstPage.Enabled = true;
            PrePage.Enabled = true;
            NextPage.Enabled = true;
            LastPage.Enabled = true;
        }
        if (lblTotal.Text.ToString() == "1")
        {
            FirstPage.Enabled = false;
            PrePage.Enabled = false;
            NextPage.Enabled =false;
            LastPage.Enabled = false;
        }
        BindDrpage(pds.PageCount);
        ProductDataList.DataSource = pds;
        ProductDataList.DataBind();
        
    }
    //绑定下拉页
    private void BindDrpage(int nCount)
    {
        drpPage.Items.Clear();
        for (int i = 1; i < nCount+1; i++)
        {
            drpPage.Items.Add(new ListItem(i.ToString(), i.ToString()));
        }
        drpPage.SelectedIndex = Convert.ToInt32(lblCurrent.Text.ToString())-1;
    }
    //判断图像
    protected string Myimg(string sImg)
    {
        string str1 = "pics/wutu.gif";
        string str2 = "Uploadpics/" + sImg;
        if (sImg.Length < 1)
        {
            return str1;
        }
        else
        {
            return str2;
        }
    }
    //打开产品数据库
    public DataSet Getproduct()
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.DsGetinfo("SELECT ProductID,Title,Imgurl FROM Product WHERE Folder=0 ORDER BY Showorder DESC");
       
        return ds;
    }
    //产品标题字数限制
    protected string Mytitle(string sTitle)
    {

        if (sTitle.Length > 8)
        {
            sTitle = sTitle.Substring(0, 8);
        }
        return sTitle;

    }
    protected void FirstPage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = "1";
        Bindproduct();
    }
    protected void PrePage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = Convert.ToString(Convert.ToUInt32(lblCurrent.Text)-1);
        Bindproduct();
    }
    protected void NextPage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = Convert.ToString(Convert.ToInt32(lblCurrent.Text)+1);
        Bindproduct();
    }
    protected void LastPage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = lblTotal.Text;
        Bindproduct();
    }
    protected void drpPage_SelectedIndexChanged(object sender, EventArgs e)
    {
        lblCurrent.Text = drpPage.SelectedValue.ToString();
        Bindproduct();
    }
}
