﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Data.SqlClient;

public partial class manage_ManageXML : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Loginjudge();      
        if (!Page.IsPostBack)
        {
            Bindtodrp();
            BindGridView();          
        }
    }
   
    //写入xml文件
    private void ToWriteXml()
    {
        System.IO.FileStream myFileStream = new System.IO.FileStream(MapPath(@"~\showad\end.xml"), System.IO.FileMode.Create);
        System.Xml.XmlTextWriter myXmlWriter = new System.Xml.XmlTextWriter(myFileStream, System.Text.Encoding.Unicode);
        myXmlWriter.Formatting = System.Xml.Formatting.Indented;
        //filename = "./img/img04.jpg";
        WriteXMLbyXmlWriter(myXmlWriter);
        myXmlWriter.Close();
    }
    //写入xml文件方法
    private void WriteXMLbyXmlWriter(System.Xml.XmlWriter writer)
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.DsGetinfo("SELECT * FROM Shareimg");
        if (ds.Tables["aa"].DefaultView.Count == 0) { return; }
        string sCount = ds.Tables["aa"].DefaultView.Count.ToString();
        writer.WriteElementString("test", "2");
        writer.WriteElementString("test", sCount);
        writer.WriteElementString("test", "2");
        writer.WriteElementString("test", "1");
        writer.WriteStartElement("test2");
        foreach (DataRow row1 in ds.Tables["aa"].Rows)
        {
            writer.WriteElementString("test6", "ShareImage/" + row1["Imgname"].ToString());
        }
        writer.WriteEndElement();

        writer.WriteStartElement("test3");
        foreach (DataRow row2 in ds.Tables["aa"].Rows)
        {
            writer.WriteElementString("test7", "../Showproduct.aspx?ShowID="+row2["Imgurl"].ToString());
        }
        writer.WriteEndElement();

        writer.WriteStartElement("test4");
        foreach (DataRow row3 in ds.Tables["aa"].Rows)
        {
            writer.WriteElementString("test8", "_blank");
        }
        writer.WriteEndElement();
            
    }
    //绑定控件
    private void BindGridView()
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.DsGetinfo("SELECT * FROM Shareimg");
        XmlGridView.DataSource = ds;
        XmlGridView.DataBind();
    }
    //绑定下拉菜单
    private void Bindtodrp()
    {
        INews shownews = new Mynews();
        SqlDataReader dr = shownews.SqlGetinfo("SELECT ProductID,Title FROM Product WHERE Folder=0 ORDER BY Showorder DESC");
        drpProductlist.Items.Clear();
        while (dr.Read())
        {
            drpProductlist.Items.Add(new ListItem(dr["Title"].ToString(), dr["ProductID"].ToString()));
        }
        dr.Close();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.DsGetinfo("SELECT * FROM Shareimg");
        if (ds.Tables["aa"].DefaultView.Count % 4 != 0)
        {
            Response.Write("<Script>alert('对不起，您的产品数目不是4的倍数，不能生成代码，你目前的产品数目是" + ds.Tables["aa"].DefaultView.Count.ToString() + "')</Script>");
            return;
        }
        ToWriteXml();
        lblError.Text = "成功生成代码，请返回首页查看！";
    }
    //上传图片
    protected void Button1_Click(object sender, EventArgs e)
    {
        //上传图片
        try
        {
            if (imageUpload.PostedFile.FileName == "")
            {
                Response.Write("<Script>alert('请先选择上传的图片')</Script>");
                return;
            }
            else
            {

                string hour = System.DateTime.Now.Hour.ToString();
                string minute = System.DateTime.Now.Minute.ToString();
                string second = System.DateTime.Now.Second.ToString();
                string xfilename = hour + minute + second;
                string dfilename = hour + minute + second;

                string filePath = imageUpload.PostedFile.FileName;

                string fileEx = filePath.Substring(filePath.LastIndexOf(".") + 1);
                string serverpath1 = Server.MapPath(@"~\showad\") + dfilename + "." + fileEx;
                string serverpath2 = Server.MapPath(@"~\showad\ShareImage\") + xfilename + "." + fileEx;
                //判断图片格式
                if (fileEx == "jpg" || fileEx == "jpeg"||fileEx=="gif"||fileEx=="bmp")
                {
                    System.Drawing.Image image, newimage;
                    imageUpload.SaveAs(serverpath1);
                    //生成略图
                    image = System.Drawing.Image.FromFile(serverpath1);
                   
                    System.Drawing.Image.GetThumbnailImageAbort callb = null;
                   
                    newimage = image.GetThumbnailImage(130, 180, callb, new IntPtr());
                    //把略图保存到指定的虚拟路径
                    newimage.Save(serverpath2,System.Drawing.Imaging.ImageFormat.Jpeg);
                    //释放image对象占用资源
                    image.Dispose();
                    newimage.Dispose();
                    lblImage.Text = "<img src='../showad/ShareImage/" + xfilename + "." + fileEx + "' width='80' height='100'/>";
                    lblImgurl.Text = xfilename + "." + fileEx;

                }
                else
                {
                    Response.Write("<Script>alert('图片格式不正确')</Script>");
                    return;
                }
            }
        }
        catch
        {
            Response.Write("<Script>alert('上传失败')</Script>");
            return;
        }
        //保存数据到库
        INews shownews = new Mynews();
        shownews.Executeinfo("INSERT INTO Shareimg(Imgname,Imgurl) VALUES('" +
            lblImgurl.Text.ToString() + "','" +
            drpProductlist.SelectedValue.ToString() + "')");
        BindGridView();

    }
   //翻页
    protected void XmlGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        XmlGridView.PageIndex = e.NewPageIndex;
        BindGridView();
    }
    //根据ID在GridView中显示产品名称
    protected string Myimgurl(string sID)
    {
        string mylist = "";
        foreach (ListItem list in drpProductlist.Items)
        {
            if (list.Value == sID)
            {
                mylist = list.Text.ToString();
                break;
            }
        }
        return mylist;
    }
    //删除
    protected void XmlGridView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int nShareimgID = Int32.Parse(XmlGridView.DataKeys[e.RowIndex].Value.ToString());
        INews shownews = new Mynews();
        shownews.Executeinfo("DELETE FROM Shareimg WHERE ShareimgID=" + nShareimgID);
        BindGridView();
    }
    private void Loginjudge()
    {
        if (Session["Login"] == null)
        {
            Response.Redirect("Error.aspx");
        }
        else
        {
            if (Session["Login"] != "pass")
            {
                Response.Redirect("Error.aspx");
            }

        }
    }
}
