topBackground = "black";
bottomBackground = "white";
tableBGColor = "black";
cellColor = "lightgrey";
headingCellColor = "white";
headingTextColor = "black";
dateColor = "blue";
focusColor = "#ff0000";
hoverColor = "darkred";
fontStyle = "12pt arial, helvetica";
headingFontStyle = "bold 12pt arial, helvetica";
bottomBorder = false;
tableBorder = 0;
var DateTimeFormat = true;
var isNav = false;
var isIE = false;
if (navigator.appName == "Netscape") {
    isNav = true;
}
else {
    isIE = true;
}
var calDocTop;
var calDocBottom;
buildCalParts();

function setDateField(formName, dateField, hiddenField) {
    thisform = document.forms[formName];
    calDateField = thisform[dateField];
    calHiddenField = thisform[hiddenField];
    inDate = thisform[hiddenField].value;
    setInitialDate();
    calDocTop = buildTopCalFrame();
    calDocBottom = buildBottomCalFrame();
}

function setInitialDate() {
    calDate = ParseDate(inDate, DateTimeFormat);
    if (isNaN(calDate)) {
        calDate = new Date();
    }
    calDay = calDate.getDate();
    calDate.setDate(1);
}

function buildTopCalFrame() {
    var calDoc =
        "<html>" +
        "<head>" +
        "</head>" +
        "<body bgcolor='" + topBackground + "'>" +
        "<form name='calControl' onSubmit='return false;'>" +
        "<center>" +
        "<table cellpadding=0 cellspacing=1 border=0 width=100%>" +
        "<tr><td colspan=7>" +
        "<center>" +
        getMonthSelect() +
        "<input name='year' value='" + calDate.getFullYear() + "'type=text size=4 maxlength=4 onKeyDown='parent.opener.keydownfn(event, \"setYear\", \"\");' onChange='parent.opener.setYear()'>" +
        "</center>" +
        "</td>" +
        "</tr>" +
        "<tr>" +
        "<td colspan=7>" +
        "<center>" +
        "<input " +
        "type=button name='previousYear' value='<<' onClick='parent.opener.setPreviousYear()'><input " +
        "type=button name='previousMonth' value=' < ' onClick='parent.opener.setPreviousMonth()'><input " +
        "type=button name='today' value='" + L_Today + "' onClick='parent.opener.setToday()'><input " +
        "type=button name='nextMonth' value=' > ' onClick='parent.opener.setNextMonth()'><input " +
        "type=button name='nextYear' value='>>' onClick='parent.opener.setNextYear()'>" +
        "</center>" +
        "</td>" +
        "</tr>" +
        "</table>" +
        "</center>" +
        "</form>" +
        "</body>" +
        "</html>";
    return calDoc;
}

function buildBottomCalFrame() {
    var calDoc = calendarBegin;
    month = calDate.getMonth();
    year = calDate.getFullYear();
    day = calDay;
    var i = 0;
    var days = getDaysInMonth();
    if (day > days) {
        day = days;
    }
    var firstOfMonth = new Date(year, month, 1);
    var startingPos = firstOfMonth.getDay();
    days += startingPos;
    var columnCount = 0;
    for (i = 0; i < startingPos; i++) {

        calDoc += blankCell;
        columnCount++;
    }
    var currentDay = 0;
    var dayType = "weekday";
    for (i = startingPos; i < days; i++) {
        var paddingChar = "&nbsp;";
        if (i - startingPos + 1 < 10) {
            padding = "&nbsp;&nbsp;";
        }
        else {
            padding = "&nbsp;";
        }
        currentDay = i - startingPos + 1;
        if (currentDay == day) {
            dayType = "focusDay";
        }
        else {
            dayType = "weekDay";
        }
        calDoc += "<td align=center bgcolor='" + cellColor + "'>" +
                  "<a class='" + dayType + "' href='javascript:parent.opener.returnDate(" +
                  currentDay + ")'>" + padding + currentDay + paddingChar + "</a></td>";

        columnCount++;
        if (columnCount % 7 == 0) {
            calDoc += "</tr><tr>";
        }
    }
    for (i = days; i < 42; i++) {

        calDoc += blankCell;
        columnCount++;
        if (columnCount % 7 == 0) {
            calDoc += "</tr>";
            if (i < 41) {
                calDoc += "<tr>";
            }
        }
    }
    calDoc += calendarEnd;
    return calDoc;
}

function writeCalendar() {
    calDocBottom = buildBottomCalFrame();
    if (document.getElementById) {
        top.newWin.frames['bottomCalFrame'].document.getElementById('bottomDiv').innerHTML = calDocBottom;
    } else {

        top.newWin.frames['bottomCalFrame'].document.open();
        top.newWin.frames['bottomCalFrame'].document.write(calDocBottom);
        top.newWin.frames['bottomCalFrame'].document.close();
    }
}

function setToday() {
    calDate = new Date();
    var month = calDate.getMonth();
    var year = calDate.getFullYear();
    top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex = month;
    top.newWin.frames['topCalFrame'].document.calControl.year.value = year;
    calDay = calDate.getDate();
    writeCalendar();
}

function setYear() {
    var year = top.newWin.frames['topCalFrame'].document.calControl.year.value;
    if (isFourDigitYear(year)) {
        calDate.setFullYear(year);
        writeCalendar();
        top.newWin.frames['topCalFrame'].document.calControl.year.blur();
    }
    else {
        top.newWin.frames['topCalFrame'].document.calControl.year.focus();
        top.newWin.frames['topCalFrame'].document.calControl.year.select();
    }
}

function setCurrentMonth() {
    var month = top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex;
    calDate.setMonth(month);
    writeCalendar();
}

function setPreviousYear() {
    var year = top.newWin.frames['topCalFrame'].document.calControl.year.value;
    if (isFourDigitYear(year) && year > 1000) {
        year--;
        calDate.setFullYear(year);
        top.newWin.frames['topCalFrame'].document.calControl.year.value = year;
        writeCalendar();
    }
}

function setPreviousMonth() {
    var year = top.newWin.frames['topCalFrame'].document.calControl.year.value;
    if (isFourDigitYear(year)) {
        var month = top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex;

        if (month == 0) {
            month = 11;
            if (year > 1000) {
                year--;
                calDate.setFullYear(year);
                top.newWin.frames['topCalFrame'].document.calControl.year.value = year;
            }
        }
        else {
            month--;
        }
        calDate.setMonth(month);
        top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex = month;
        writeCalendar();
    }
}

function setNextMonth() {
    var year = top.newWin.frames['topCalFrame'].document.calControl.year.value;
    if (isFourDigitYear(year)) {
        var month = top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex;
        if (month == 11) {
            month = 0;
            year++;
            calDate.setFullYear(year);
            top.newWin.frames['topCalFrame'].document.calControl.year.value = year;
        }
        else {
            month++;
        }
        calDate.setMonth(month);
        top.newWin.frames['topCalFrame'].document.calControl.month.selectedIndex = month;
        writeCalendar();
    }
}

function setNextYear() {
    var year = top.newWin.frames['topCalFrame'].document.calControl.year.value;
    if (isFourDigitYear(year)) {
        year++;
        calDate.setFullYear(year);
        top.newWin.frames['topCalFrame'].document.calControl.year.value = year;
        writeCalendar();
    }
}

function getDaysInMonth() {
    var days;
    var month = calDate.getMonth() + 1;
    var year = calDate.getFullYear();
    if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 ||
        month == 10 || month == 12) {
        days = 31;
    }
    else if (month == 4 || month == 6 || month == 9 || month == 11) {
        days = 30;
    }
    else if (month == 2) {
        if (isLeapYear(year)) {
            days = 29;
        }
        else {
            days = 28;
        }
    }
    return (days);
}

function isLeapYear(Year) {
    if (((Year % 4) == 0) && ((Year % 100) != 0) || ((Year % 400) == 0)) {
        return (true);
    }
    else {
        return (false);
    }
}

function isFourDigitYear(year) {
    if (year == null || year.match(/^[0-9]{4}$/) == null) {
        top.newWin.frames['topCalFrame'].document.calControl.year.value = calDate.getFullYear();
        top.newWin.frames['topCalFrame'].document.calControl.year.select();
        top.newWin.frames['topCalFrame'].document.calControl.year.focus();
    }
    else {
        return true;
    }
}

function getMonthSelect() {
    monthArray = new Array(L_January, L_February, L_March, L_April, L_May, L_June,
                           L_July, L_August, L_September, L_October, L_November, L_December);
    var activeMonth = calDate.getMonth();
    monthSelect = "<select name='month' onChange='parent.opener.setCurrentMonth()'>";
    for (i in monthArray) {

        if (i == activeMonth) {
            monthSelect += "<option selected>" + monthArray[i] + "\n";
        }
        else {
            monthSelect += "<option>" + monthArray[i] + "\n";
        }
    }
    monthSelect += "</select>";
    return monthSelect;
}

function createWeekdayList() {
    weekdayArray = new Array(L_Su, L_Mo, L_Tu, L_We, L_Th, L_Fr, L_Sa);
    var weekdays = "<tr bgcolor='" + headingCellColor + "'>";
    for (i in weekdayArray) {

        weekdays += "<td class='heading' align=center>" + weekdayArray[i] + "</td>";
    }
    weekdays += "</tr>";
    return weekdays;
}


function buildCalParts() {
    weekdays = createWeekdayList();
    blankCell = "<td align=center bgcolor='" + cellColor + "'>&nbsp;&nbsp;&nbsp;</td>";
    calendarBegin =
        "<html>" +
        "<head>" +
        "<style type='text/css'>" +
        "<!--" +
        "td.heading { text-decoration: none; color:" + headingTextColor + "; font: " + headingFontStyle + "; }" +
        "A.focusDay:link { color: " + focusColor + "; text-decoration: none; font: " + fontStyle + "; }" +
        "A.focusDay:hover { color: " + focusColor + "; text-decoration: none; font: " + fontStyle + "; }" +
        "A.focusDay:visited { color: " + focusColor + "; text-decoration: none; font: " + fontStyle + "; }" +
        "A.weekday:link { color: " + dateColor + "; text-decoration: none; font: " + fontStyle + "; }" +
        "A.weekday:hover { color: " + hoverColor + "; font: " + fontStyle + "; }" +
        "A.weekday:visited { color: " + dateColor + "; text-decoration: none; font: " + fontStyle + "; }" +
        "-->" +
        "</style>" +
        "</head>" +
        "<body bgcolor='" + bottomBackground + "' onload='javascript:self.focus()'>";
    if (document.getElementById) {
        calendarBegin +=
            "<div id='bottomDiv'>";
    }
    calendarBegin +=
        "<center>";
    if (isNav) {
        calendarBegin +=
                "<table cellpadding=0 cellspacing=1 border=" + tableBorder + " align=center bgcolor='" + tableBGColor + "'><tr><td>";
    }
    calendarBegin +=
            "<table cellpadding=0 cellspacing=1 border=" + tableBorder + " align=center bgcolor='" + tableBGColor + "'>" +
            weekdays +
            "<tr>";
    calendarEnd = "";
    if (bottomBorder) {
        calendarEnd += "<tr></tr>";
    }
    if (isNav) {
        calendarEnd += "</td></tr></table>";
    }
    calendarEnd +=
            "</table>" +
            "</center>";
    if (document.getElementById) {
        calendarEnd +=
            "</div>";
    }
    calendarEnd +=
            "</body>" +
            "</html>";
}

function jsReplace(inString, find, replace) {
    var outString = "";
    if (!inString) {
        return "";
    }
    if (inString.indexOf(find) != -1) {
        t = inString.split(find);

        return (t.join(replace));
    }
    else {
        return inString;
    }
}

function doNothing() {
}


function makeTwoDigit(inValue) {
    var numVal = parseInt(inValue, 10);
    if (numVal < 10) {

        return ("0" + numVal);
    }
    else {
        return numVal;
    }
}

function returnDate(inDay) {
    calDate.setDate(inDay);
    var day = calDate.getDate();
    var month = calDate.getMonth() + 1;
    var year = calDate.getFullYear();
    var dt = new Date(year, month - 1, day, 0, 0, 0);
    calDateField.value = GLDT(dt, true, false);
    calHiddenField.value = "Date(";
    calHiddenField.value += year;
    calHiddenField.value += ",";
    calHiddenField.value += month;
    calHiddenField.value += ",";
    calHiddenField.value += day;
    calHiddenField.value += ")";
    calDateField.focus();
    top.newWin.close()
}

var gHour = "0";
var gMin = "0";
var gSec = "0";
var regDateTimePrompt = /^(D|d)(A|a)(T|t)(E|e)(T|t)(I|i)(M|m)(E|e) *\( *\d{4} *, *(0?[1-9]|1[0-2]) *, *((0?[1-9]|[1-2]\d)|3(0|1)) *, *([0-1]?\d|2[0-3]) *, *[0-5]?\d *, *[0-5]?\d *\)$/
function ParseDateTimePrompt(inDate) {
    if (regDateTimePrompt.test(inDate)) {
        var sDate = inDate.substr(inDate.indexOf("(") + 1);
        sDate = sDate.substr(0, sDate.lastIndexOf(")"));
        var dateArray = sDate.split(',');
        var _date = new Date(dateArray[0], Number(dateArray[1]) - 1, dateArray[2]);
        gHour = dateArray[3]; gMin = dateArray[4]; gSec = dateArray[5];
        return _date;
    }
    return new Date();
}

var regDatePrompt = /^(D|d)(A|a)(T|t)(E|e) *\( *\d{4} *, *(0?[1-9]|1[0-2]) *, *((0?[1-9]|[1-2]\d)|3(0|1)) *\)$/
function ParseDatePrompt(inDate) {
    if (regDatePrompt.test(inDate)) {
        var sDate = inDate.substr(inDate.indexOf("(") + 1);
        sDate = sDate.substr(0, sDate.lastIndexOf(")"));
        var dateArray = sDate.split(',');
        return new Date(dateArray[0], Number(dateArray[1]) - 1, dateArray[2]);
    }
    return new Date();
}

function ParseDate(inDate, bDateTimeFormat) {
    var result;

    if (bDateTimeFormat == true) {
        result = ParseDateTimePrompt(inDate);
    } else {
        result = ParseDatePrompt(inDate);
    }
    return result;
}