function TDC() {
    var d = new Date(1970, 0, 0, 0, 0, 0, 0), d2 = new Date(d), s1, s2, api = -1;
    d.setHours(10); d2.setHours(11);
    s1 = d.toLocaleString(); s2 = d2.toLocaleString();
    this.displayHour = (s1 != s2);
    d.setHours(0); d2.setHours(0);
    d.setMinutes(10); d2.setMinutes(11);
    this.displayMinute = (d.toLocaleString() != d2.toLocaleString());
    d.setMinutes(0); d2.setMinutes(0);
    d.setSeconds(10); d2.setSeconds(11);
    this.displaySecond = (d.toLocaleString() != d2.toLocaleString());
    d.setSeconds(0); d2.setSeconds(0);
    if (this.displayHour) {
        for (i = 0; i < ((s1.length < s2.length) ? s1.length : s2.length); i++) {
            if (s1.charAt(i) != s2.charAt(i)) {
                api = i - 1; break;
            }
        }
        d.setHours(11); d2.setHours(23);
        s1 = d.toLocaleString(); s2 = d2.toLocaleString();
        this.twelveHourClock = (s1.substring(api, api + 2) == s2.substring(api, api + 2));
        this.displayAMPM = (s1 != s2);
        d.setHours(0); d2.setHours(0);
        d.setHours(9); d2.setHours(11);
        this.hourLeadZero = (d.toLocaleString().length == d2.toLocaleString().length);
        d.setHours(0); d2.setHours(0);
    } else {
        this.twelveHourClock = false;
        this.displayAMPM = false;
        this.hourLeadZero = false;
    }
    if (this.displayMinute) {
        d.setMinutes(9); d2.setMinutes(11);
        this.minuteLeadZero = (d.toLocaleString().length == d2.toLocaleString().length);
        d.setMinutes(0); d2.setMinutes(0);
    } else
        this.minuteLeadZero = false;
    if (this.displaySecond) {
        d.setSeconds(9); d2.setSeconds(11);
        this.secondLeadZero = (d.toLocaleString().length == d2.toLocaleString().length);
        d.setSeconds(0); d2.setSeconds(0);
    } else
        this.secondLeadZero = false;
}

var TD = new TDC();

function CreateTimeEditables(paramName, postFix, enabled, cssClass, style, hour, minute, second) {
    var properties = "";
    if (!enabled) {
        properties += " disabled='disabled' ";
    }

    if (cssClass.length != 0) {
        properties += " class='";
        properties += cssClass;
        properties += "' ";
    }

    if (style.length != 0) {
        properties += " style='";
        properties += style;
        properties += "' ";
    }

    var time_sep_span = "";
    time_sep_span += "<span ";
    time_sep_span += properties;
    time_sep_span += ">";
    time_sep_span += L_TIME_SEPARATOR;
    time_sep_span += "</span>";

    var editablesHtml = "";
    if (TD.displayHour) {
        editablesHtml += "<select ";
        editablesHtml += properties;
        editablesHtml += " name='";
        editablesHtml += paramName;
        editablesHtml += postFix;
        editablesHtml += "Hour'>";

        var minHour;
        var maxHour;
        if (TD.twelveHourClock) {
            minHour = 1;
            maxHour = 12;
        }
        else {
            minHour = 0;
            maxHour = 23;
        }

        for (i = minHour; i <= maxHour; i++) {
            editablesHtml += " <option value='";
            editablesHtml += i;
            editablesHtml += "'";

            if (!TD.twelveHourClock) {
                if (i == hour)
                    editablesHtml += " selected ";
            }
            else {
                if ((hour == 0) && (i == 12))
                    editablesHtml += " selected ";
                else if ((hour == 12) && (i == 12))
                    editablesHtml += " selected ";
                else if ((hour > 12) && (i == hour - 12))
                    editablesHtml += " selected ";
                else if (i == hour)
                    editablesHtml += " selected ";
            }

            if ((i < 10) && (TD.hourLeadZero)) {
                editablesHtml += "> 0";
            }
            else {
                editablesHtml += "> ";

            }
            editablesHtml += i;
            editablesHtml += "</option>\n";
        }

        editablesHtml += "        </select>";
    }

    if (TD.displayMinute) {
        if (editablesHtml.length != 0) {
            editablesHtml += time_sep_span;
        }

        editablesHtml += "<select  ";
        editablesHtml += properties;
        editablesHtml += " name='";
        editablesHtml += paramName;
        editablesHtml += postFix;
        editablesHtml += "Minute'>";


        for (i = 0; i <= 59; i++) {
            editablesHtml += " <option value='";
            editablesHtml += i;
            editablesHtml += "'";

            if (i == minute)
                editablesHtml += " selected ";
            if ((i < 10) && (TD.minuteLeadZero)) {

                editablesHtml += "> 0";

            }
            else {
                editablesHtml += "> ";
            }
            editablesHtml += i;
            editablesHtml += "</option>\n";
        }

        editablesHtml += "        </select>";
    }

    if (TD.displaySecond) {
        if (editablesHtml.length != 0)
            editablesHtml += time_sep_span;

        editablesHtml += "<select ";
        editablesHtml += properties;
        editablesHtml += " name='";
        editablesHtml += paramName;
        editablesHtml += postFix;
        editablesHtml += "Second'>";


        for (i = 0; i <= 59; i++) {
            editablesHtml += " <option value='";
            editablesHtml += i;
            editablesHtml += "'";

            if (i == second)
                editablesHtml += " selected ";

            if ((i < 10) && (TD.secondLeadZero))
                editablesHtml += "> 0";
            else
                editablesHtml += "> "; ;
            editablesHtml += i;
            editablesHtml += "</option>\n";
        }

        editablesHtml += "        </select>";
    }

    if (TD.twelveHourClock) {
        editablesHtml += "<select ";
        editablesHtml += properties;
        editablesHtml += " name='";
        editablesHtml += paramName;
        editablesHtml += postFix;
        editablesHtml += "AMPM' >";
        editablesHtml += " <option value='0'";
        if (hour < 12)
            editablesHtml += " selected ";
        editablesHtml += "> ";
        editablesHtml += L_AM_DESIGNATOR;
        editablesHtml += "</option>\n";
        editablesHtml += " <option value='1'";
        if (hour >= 12)
            editablesHtml += " selected ";
        editablesHtml += "> ";
        editablesHtml += L_PM_DESIGNATOR;
        editablesHtml += "</option>\n";
        editablesHtml += "        </select>";
    }

    return editablesHtml;
}

function GLDT(d, includeDate, includeTime) {
    if (includeDate && includeTime) return d.toLocaleString();

    var d2 = new Date(d);
    var ds;
    var ds2;
    var ml;
    d2.setMilliseconds(d.getMilliseconds() <= 887 ? d.getMilliseconds() + 111 : d.getMilliseconds() - 111);
    d2.setSeconds(d.getSeconds() <= 49 ? d.getSeconds() + 11 : d.getSeconds() - 11);
    d2.setMinutes(d.getMinutes() <= 49 ? d.getMinutes() + 11 : d.getMinutes() - 11);
    if (TD.twelveHourClock) {
        var hour = d.getHours();
        if (hour == 0 || hour == 1 || hour == 10 || hour == 11) {
            d2.setHours(14);
        }
        else if (hour == 12 || hour == 13 || hour == 22 || hour == 23) {
            d2.setHours(2);
        }
        else if (hour < 12) {
            d2.setHours(13);
        }
        else {
            d2.setHours(1);
        }
    }
    else {
        d2.setHours(d.getHours() < 12 ? (d.getHours() == 1 ? 2 : d.getHours() + 12) : (d.getHours() < 20 ? 20 : 11));
    }

    ds = d.toLocaleString();

    ds2 = d2.toLocaleString();

    ml = ds.length < ds2.length ? ds.length : ds2.length;
    for (i = 0; i < ml; i++) {
        if (ds.charAt(i) != ds2.charAt(i)) {
            while (ds.charAt(i) != ' ') i--;
            i++;
            break;
        }
    }
    if (includeDate)
        return ds.substring(0, i - 1);
    else if (includeTime)
        return ds.substring(i);
    else
        return "";
}

function NeutralDT2D(s) {
    var d = "";
    var td = new Date();
    var a;
    if (s.indexOf("DateTime") != -1) {
        a = s.replace("DateTime", "").replace("(", "").replace(")", "").split(",");
        d = GLDT(new Date(a[0], a[1] - 1, a[2], a[3], a[4], a[5], 0), true, true);
    } else if (s.indexOf("Date") != -1) {
        a = s.replace("Date", "").replace("(", "").replace(")", "").split(",");
        d = GLDT(new Date(a[0], a[1] - 1, a[2], 0, 0, 0, 0), true, false);
    } else if (s.indexOf("Time") != -1) {
        a = s.replace("Time", "").replace("(", "").replace(")", "").split(",");
        d = GLDT(new Date(td.getYear(), td.getMonth(), td.getDate(), a[0], a[1], a[2]), false, true);
    }
    return d;
}

function NeutralDT2Date(s) {
    var d = "";
    var td = new Date();
    var a;
    if (s.indexOf("DateTime") != -1) {
        a = s.replace("DateTime", "").replace("(", "").replace(")", "").split(",");
        return new Date(a[0], a[1] - 1, a[2], a[3], a[4], a[5], 0);
    } else if (s.indexOf("Date") != -1) {
        a = s.replace("Date", "").replace("(", "").replace(")", "").split(",");
        return new Date(a[0], a[1] - 1, a[2], 0, 0, 0, 0);
    } else if (s.indexOf("Time") != -1) {
        a = s.replace("Time", "").replace("(", "").replace(")", "").split(",");
        return new Date(td.getYear(), td.getMonth(), td.getDate(), a[0], a[1], a[2]);
    }
    return d;
}