﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_ManagerRole, App_Web_fef3q6en" title="管理员组管理" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ManagerRoleListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="ManagerRoleList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ManagerRoleList_PageIndexChanging" DataKeyNames="RoleId"
                    OnRowEditing="ManagerRoleList_RowEditing" OnRowUpdating="ManagerRoleList_RowUpdating"
                    PageSize="11" OnRowDeleting="ManagerRoleList_RowDeleting" CellPadding="0" CssClass="gv"
                    Width="100%" OnRowDataBound="ManagerRoleList_RowDataBound" OnRowCommand="ManagerRoleList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="RoleId" HeaderText="Id" ReadOnly="True" SortExpression="RoleId" />
                        <asp:TemplateField HeaderText="组名称">
                            <EditItemTemplate>
                                <asp:TextBox ID="ClassName" runat="server" Text='<%# Bind("ClassName") %>'></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="Label5" runat="server" Text='<%# Bind("Title") %>'></asp:Label>&nbsp;
                            </ItemTemplate>
                            <ItemStyle CssClass="gvLeftField" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加时间">
                            <ItemTemplate>
                                <asp:Label ID="Label4" runat="server" Text='<%# Bind("AddTime") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                <asp:Button ID="UpdateBt" runat="server" CausesValidation="True" CommandName="Update"
                                    Text="更新" />
                                <asp:Button ID="CancelBt" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="取消" />
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="设置权限">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editManagerRole"
                                    CommandArgument='<%# Eval("RoleId").ToString().Trim() %>' CssClass="addBt" Text="设置权限" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ManagerRoleAddUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    class="mainMarginTop8">
                    <tr>
                        <td colspan="3" bgcolor="#FFFFFF" class="mainTitle">
                            添加管理员组
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            管理组名称:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="AddRoleTitle" runat="server" CssClass="inputText"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="AddRoleTitle"
                                Display="Dynamic" ErrorMessage="必须填写" ValidationGroup="ClassAdd"></asp:RequiredFieldValidator>
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ControlToValidate="AddRoleTitle"
                                ErrorMessage="已经存在此会员组" OnServerValidate="CustomValidator1_ServerValidate1" ValidationGroup="ClassAdd"></asp:CustomValidator>
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:Button ID="AddClass" runat="server" CssClass="inputBt" Text="添加组" OnClick="AddClass_Click"
                                ValidationGroup="ClassAdd" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ManagerRoleEditUpdatePanel" UpdateMode="Conditional" runat="server"
            OnInit="ManagerRoleEditUpdatePanel_Init">
            <ContentTemplate>
                <asp:Panel ID="ManagerRoleEditPanel" runat="server" CssClass="hide">
                    <asp:HiddenField ID="EditId" runat="server" />
                    <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                        id="mainBottTable">
                        <tr>
                            <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                                定义管理员组权限
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                                管理员组ID:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Label ID="RoleId" runat="server" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                权限组名
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:TextBox ID="RoleTitle" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                超级管理员:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:CheckBox ID="IsAdmin" runat="server" CssClass="checkBox" /><span class="explain">&nbsp;超级管理员拥有所有权限</span>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" bgcolor="#ffffff" colspan="2">
                                &nbsp; 栏目内容管理权限:
                            </td>
                        </tr>
                        <tr>
                            <td align="left" id="TreeViewTd" bgcolor="#ffffff" class="mainNoLeftTd" colspan="2">
                                <asp:TreeView ID="ManagerTreeView" runat="server" ShowCheckBoxes="All" ShowLines="True"
                                    CssClass="memberTreeView" CollapseImageToolTip="折叠" ExpandImageToolTip="展开" AutoGenerateDataBindings="False">
                                </asp:TreeView>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#ffffff" colspan="2">
                                &nbsp; 后台管理权限:
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#ffffff" id="TreeViewTd1" class="mainNoLeftTd" colspan="2">
                                <asp:TreeView ID="HouTaiTreeView" runat="server" ShowCheckBoxes="All" ShowLines="True"
                                    CssClass="memberTreeView" CollapseImageToolTip="折叠" ExpandImageToolTip="展开" AutoGenerateDataBindings="False">
                                </asp:TreeView>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                添加时间:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:Label ID="AddTime" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Button ID="Save" runat="server" Text="定义权限" CssClass="inputBt" OnClick="Save_Click" />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
