﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_Member, App_Web_ch4l_m16" title="会员列表" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="3" bgcolor="#FFFFFF" class="mainTitle">
                    会员检索&nbsp;
                </td>
            </tr>
            <tr>
                <td bgcolor="#FFFFFF" align="right">
                    用户名/姓名/Email/电话:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="MemberNameKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="会员检索" OnClick="Search_Click"
                        ValidationGroup="MemberSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="MemberListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="MemberList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="MemberList_PageIndexChanging" DataKeyNames="MemberId" OnRowCancelingEdit="MemberList_RowCancelingEdit"
                    OnRowEditing="MemberList_RowEditing" OnRowUpdating="MemberList_RowUpdating" PageSize="11"
                    OnRowDeleting="MemberList_RowDeleting" CellPadding="0" CssClass="gv" Width="100%"
                    EmptyDataText="暂无任何会员" OnRowDataBound="MemberList_RowDataBound" OnRowCommand="MemberList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="MemberName" HeaderText="用户名">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="FullName" HeaderText="姓名" ReadOnly="True" SortExpression="Title" />
                        <asp:BoundField DataField="Email" HeaderText="Email" ReadOnly="True" SortExpression="AddTime" />
                        <asp:BoundField DataField="Tel" HeaderText="电话" ReadOnly="True" />
                        <asp:BoundField DataField="RegTime" HeaderText="注册时间" ReadOnly="True" />
                        <asp:BoundField DataField="RegIp" HeaderText="注册Ip" ReadOnly="True" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editMember"
                                    CommandArgument='<%# Eval("MemberId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="MemberSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Panel ID="MemberEditPanel" runat="server" CssClass="hide">
                    <asp:HiddenField ID="EditId" runat="server" />
                    <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                        id="mainBottTable">
                        <tr>
                            <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                                编辑会员资料
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                会员ID:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Label ID="ShowMemberId" runat="server" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF" class="mainLeftTd">
                                用户名:
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;
                                <asp:Label ID="MemberName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                密码:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="PassWord" runat="server"></asp:TextBox><span class="explain">&nbsp;不修改清留空<asp:HiddenField
                                    ID="TempPassword" runat="server" />
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                姓名:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="FullName" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                性别:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:DropDownList ID="Sex" runat="server">
                                    <asp:ListItem Value="true">男</asp:ListItem>
                                    <asp:ListItem Value="false">女</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                Email:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="Email" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                电话:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="Tel" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                传真:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="Fax" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                地址:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="Address" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                QQ:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="QQ" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                MSN:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:TextBox ID="Msn" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                会员组：
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:RadioButtonList ID="RoleList" runat="server" CssClass="checkBox" RepeatLayout="Flow">
                                </asp:RadioButtonList>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                注册时间:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:Label ID="RegTime" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                注册IP:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Label ID="RegIp" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Button ID="Save" runat="server" Text="编辑资料" CssClass="inputBt" OnClick="Save_Click" />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
