﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_OrderList, App_Web_fef3q6en" title="订单列表" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="5" bgcolor="#FFFFFF" class="mainTitle">
                    "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>" 订单检索&nbsp;
                </td>
            </tr>
            <tr>
                <td align="right" bgcolor="#FFFFFF">
                    订单状态:
                </td>
                <td bgcolor="#ffffff">
                    买家:
                    <asp:DropDownList ID="PurchaserStateList" runat="server">
                        <asp:ListItem Value="0,1,2">所有状态</asp:ListItem>
                        <asp:ListItem Value="0">未付款</asp:ListItem>
                        <asp:ListItem Value="1">已付款</asp:ListItem>
                        <asp:ListItem Value="2">已到货</asp:ListItem>
                    </asp:DropDownList>
                    商家:
                    <asp:DropDownList ID="BargainorStateList" runat="server">
                        <asp:ListItem Value="0,1,2,3">所有状态</asp:ListItem>
                        <asp:ListItem Value="0">未确认</asp:ListItem>
                        <asp:ListItem Value="1">已确认到款</asp:ListItem>
                        <asp:ListItem Value="2">已发货</asp:ListItem>
                        <asp:ListItem Value="3">已归档</asp:ListItem>
                    </asp:DropDownList>
                </td>
                <td bgcolor="#FFFFFF" align="right">
                    订单编号:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="OrderNumKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="订单检索" OnClick="Search_Click"
                        ValidationGroup="ProductSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="OrderListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="OrderList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ProductList_PageIndexChanging" DataKeyNames="OrderId" OnRowCancelingEdit="ProductList_RowCancelingEdit"
                    OnRowEditing="ProductList_RowEditing" OnRowUpdating="ProductList_RowUpdating"
                    PageSize="11" OnRowDeleting="ProductList_RowDeleting" CellPadding="0" CssClass="gv"
                    Width="100%" EmptyDataText="暂无任何订单" OnRowCommand="OrderList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="OrderId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="OrderNum" HeaderText="订单编号" ReadOnly="True" SortExpression="OrderNum" />
                        <asp:BoundField DataField="AddTime" HeaderText="生成时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:TemplateField HeaderText="订单状态">
                            <EditItemTemplate>
                                <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="State" runat="server" Text='<%# GetGlobalResourceObject("WebResourcesGlobal", "BargainorState"+Eval("BargainorState")).ToString()+"["+GetGlobalResourceObject("WebResourcesGlobal", "PurchaserState"+Eval("PurchaserState")).ToString()+"]" %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="订单总额">
                            <EditItemTemplate>
                                <asp:TextBox ID="TextBox2" runat="server"></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="TotalPrices" runat="server" Text='<%# Convert.ToSingle(Eval("TotalPrices")).ToString(".00") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="AddIP" HeaderText="提交IP" />
                        <asp:TemplateField HeaderText="处理订单">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CommandName="orderDisposal" CommandArgument='<%# Eval("OrderId").ToString().Trim() %>'
                                    Text="处理订单." CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="OrderSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Panel ID="OrderDisposalPanel" runat="server" CssClass="hide">
                    <asp:HiddenField ID="EditId" runat="server" />
                    <table width="100%" class="mainMarginTop8 mainMarginBottom8" border="0" cellpadding="2"
                        cellspacing="1" bgcolor="#D7D7D7">
                        <tr>
                            <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                                "<asp:Label ID="OrderNum1" runat="server" ForeColor="Black"></asp:Label>" 订单信息
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                订单ID:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Label ID="OrderId" runat="server" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                                订单编号:
                            </td>
                            <td bgcolor="#FFFFFF" class="mainContentRightTd">
                                <asp:Literal ID="OrderNum" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                订单状态:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="State" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                下单时间:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="AddTime" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                提交IP:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:Literal ID="AddIP" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                支付总额:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="TotalPrices" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                配送方式:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <div>
                                    <span class="deliveryName">
                                        <asp:Literal ID="DeliveryName" runat="server"></asp:Literal>
                                    </span>
                                    <asp:Label ID="DeliveryMoneyLabel" runat="server" CssClass="deliveryMoneyLabel" Text="配送价格:"></asp:Label><asp:Label
                                        ID="DeliveryMoney" CssClass="deliveryMoney" runat="server"></asp:Label>
                                </div>
                                <div class="deliveryContent">
                                    <asp:Literal ID="DeliveryContent" runat="server"></asp:Literal>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                支付方式:
                            </td>
                            <td bgcolor="#ffffff">
                                <div>
                                    <span class="paymentName">
                                        <asp:Literal ID="PaymentName" runat="server"></asp:Literal>
                                    </span>
                                </div>
                                <div class="paymentContent">
                                    <asp:Literal ID="PaymentContent" runat="server"></asp:Literal>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                订单操作:
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Button ID="Button1" runat="server" Text="确认到款" CssClass="inputBt" OnClick="Button1_Click" />
                                &nbsp;
                                <asp:Button ID="Button2" runat="server" Text="已发货" CssClass="inputBt" OnClick="Button2_Click" />&nbsp;
                                <asp:Button ID="Button3" runat="server" Text="归档订单" CssClass="inputBt" OnClick="Button3_Click" />&nbsp;
                                <asp:Button ID="Button0" runat="server" Text="取消订单" CssClass="inputBt" OnClick="Button0_Click" />
                            </td>
                        </tr>
                    </table>
                    <asp:GridView ID="GoodsList" runat="server" AutoGenerateColumns="False" PageSize="11"
                        CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何商品">
                        <Columns>
                            <asp:TemplateField HeaderText="商品货号" SortExpression="OrderNum">
                                <EditItemTemplate>
                                    <asp:Label ID="Label1" runat="server" Text='<%# Eval("OrderNum") %>'></asp:Label>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    &nbsp;<asp:Label ID="ProductNumber" runat="server" Text='<%# Bind("ProductNumber") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="商品名称" SortExpression="AddTime">
                                <EditItemTemplate>
                                    <asp:Label ID="Label2" runat="server" Text='<%# Eval("AddTime") %>'></asp:Label>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    <asp:HyperLink ID="ProductName" runat="server" CssClass="productName" NavigateUrl='<%# String.Format("~/ProductDetail.aspx?id={0}&fileName={1}&Language={2}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.ManageSiteInfo.SiteLanguage()) %>'
                                        Target="_blank" Text='<%# Eval("ProductName") %>' ToolTip='<%# Eval("ProductName") %>'></asp:HyperLink>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="商品价格">
                                <EditItemTemplate>
                                    <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    &nbsp;<asp:Label ID="Price" runat="server" Text='<%# Convert.ToSingle(Eval("Price")).ToString(".00") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="订购数量">
                                <EditItemTemplate>
                                    <asp:TextBox ID="TextBox2" runat="server"></asp:TextBox>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    &nbsp;<asp:Label ID="GoodsNum" runat="server" Text='<%# Eval("Num") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="小计">
                                <EditItemTemplate>
                                    <asp:TextBox ID="TextBox3" runat="server" Text='<%# Bind("AddIP") %>'></asp:TextBox>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    <asp:Label ID="Subtotal" runat="server" Text='<%# (Convert.ToSingle(Eval("Num").ToString())*Convert.ToSingle(Eval("Price"))).ToString(".00") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                        <RowStyle CssClass="gvRow" />
                        <EditRowStyle CssClass="gvEditRow" />
                        <PagerStyle CssClass="gvPage" />
                        <HeaderStyle CssClass="gvHeader" />
                        <AlternatingRowStyle CssClass="gvAlternatingRow" />
                    </asp:GridView>
                    <table width="100%" id="mainBottTable" border="0" cellpadding="2" cellspacing="1"
                        bgcolor="#D7D7D7">
                        <tr>
                            <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                                收货人信息
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                                收货人姓名:
                            </td>
                            <td bgcolor="#FFFFFF" class="mainContentRightTd">
                                <asp:Literal ID="ConsigneeName" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                电子信箱:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="ConsigneeEmail" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                电话:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="ConsigneeTel" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                邮政编码:
                            </td>
                            <td bgcolor="#ffffff">
                                <asp:Literal ID="ConsigneePost" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                联系地址:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="ConsigneeAddress" runat="server"></asp:Literal>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                备注:
                            </td>
                            <td bgcolor="#FFFFFF">
                                <asp:Literal ID="ConsigneeRemark" runat="server"></asp:Literal>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
