﻿<%@ page language="C#" masterpagefile="~/manage/Main.master" autoeventwireup="true" inherits="manage_Pic, App_Web_ch4l_m16" validaterequest="false" title="添加图文" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="5" bgcolor="#FFFFFF" class="mainTitle">
                    "<asp:Label ID="SearchMenuName" runat="server" ForeColor="Black"></asp:Label>" 图文检索&nbsp;
                </td>
            </tr>
            <tr>
                <td align="right" bgcolor="#FFFFFF">
                    属于分类:
                </td>
                <td bgcolor="#ffffff">
                    <asp:DropDownList ID="SearchClassList" runat="server">
                    </asp:DropDownList>
                </td>
                <td bgcolor="#FFFFFF" align="right">
                    图文标题/内容:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="SearchKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="图文检索" OnClick="Search_Click"
                        ValidationGroup="PicSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="PicListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="PicList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="PicList_PageIndexChanging" DataKeyNames="PicId,PicClassId"
                    OnRowCancelingEdit="PicList_RowCancelingEdit" OnRowEditing="PicList_RowEditing"
                    OnRowUpdating="PicList_RowUpdating" PageSize="11" OnRowDeleting="PicList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何图文" OnRowDataBound="PicList_RowDataBound"
                    OnRowCommand="PicList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="PicId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="ClassName" HeaderText="所属分类" ReadOnly="True" SortExpression="ClassName" />
                        <asp:BoundField DataField="Title" HeaderText="图文标题" ReadOnly="True" SortExpression="Title" />
                        <asp:HyperLinkField DataNavigateUrlFields="PicPathSmall" HeaderText="小图预览" Target="_blank"
                            Text="小图预览" />
                        <asp:HyperLinkField DataNavigateUrlFields="PicPathBig" HeaderText="大图预览" Text="大图预览"
                            Target="_blank" />
                        <asp:BoundField DataField="AddTime" HeaderText="添加时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editPic"
                                    CommandArgument='<%# Eval("PicId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加图文">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addPic" CommandArgument='<%# Eval("PicId").ToString().Trim() %>'
                                    Text="添加图文" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="PicSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>"
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>图文<asp:HiddenField
                                ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            所属分类:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:DropDownList ID="PicClassList" runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            图文标题:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="PicTitle" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="PicTitle"
                                Display="Dynamic" ErrorMessage="文章标题必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            小图:
                        </td>
                        <td bgcolor="#FFFFFF" id="PicSmallTd">
                            <asp:HyperLink ID="PicSmallHyperLink" runat="server" Target="_blank" Visible="false">预览原图</asp:HyperLink>
                            <span class="explain" id="PicSmallEditSpan" runat="server" visible="false">不修改请留空</span>
                            <asp:HiddenField ID="PicSmall" runat="server" Value="无" EnableViewState="false" />
                            <iframe height="24" width="550" frameborder="0" scrolling="no" src="UpLoad.aspx?type=Small&menuId=<%=ShanRui.Web.ManageSiteInfo.GetMenuId() %>">
                            </iframe>
                            &nbsp;
                            <asp:CustomValidator ID="PicSmallCustomValidator" runat="server" Display="Dynamic"
                                ErrorMessage="小图路径必须选择" ClientValidationFunction="ValidationPicSmall"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            大图:
                        </td>
                        <td bgcolor="#FFFFFF" id="PicBigTd">
                            <asp:HyperLink ID="PicBigHyperLink" runat="server" Target="_blank" Visible="false">预览原图</asp:HyperLink>
                            <span class="explain" id="PicBigEditSpan" runat="server" visible="false">不修改请留空</span>
                            <asp:HiddenField ID="PicBig" runat="server" Value="无" EnableViewState="false" />
                            <iframe height="24" width="550" frameborder="0" scrolling="no" src="UpLoad.aspx?type=Big&menuId=<%=ShanRui.Web.ManageSiteInfo.GetMenuId() %>">
                            </iframe>
                            &nbsp;
                            <asp:CustomValidator ID="PicBigCustomValidator" runat="server" ClientValidationFunction="ValidationPicBig"
                                Display="Dynamic" ErrorMessage="大图路径必须选择"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            添加时间:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="AddTime" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="添加时间必须填写"></asp:RequiredFieldValidator>&nbsp;
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="时间格式错误！" OnServerValidate="CustomValidator1_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            内容摘要:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="PicShortContent" runat="server" Rows="4" TextMode="MultiLine"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            图文内容:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="PicContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加图文" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
