﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_Vote, App_Web__x3qmtgh" title="投票管理" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="VoteListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="VoteList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="VoteList_PageIndexChanging" DataKeyNames="VoteId" OnRowCancelingEdit="VoteList_RowCancelingEdit"
                    OnRowEditing="VoteList_RowEditing" OnRowUpdating="VoteList_RowUpdating" PageSize="11"
                    OnRowDeleting="VoteList_RowDeleting" CellPadding="0" CssClass="gv" Width="100%"
                    EmptyDataText="暂无任何投票" OnRowDataBound="VoteList_RowDataBound" OnRowCommand="VoteList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="VoteId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="Title" HeaderText="投票标题" ReadOnly="True" SortExpression="Title" />
                        <asp:TemplateField HeaderText="类型">
                            <ItemTemplate>
                                <asp:Label ID="Label1" runat="server" Text='<%# Eval("Type").ToString()=="True"?"多选":"单选" %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:CheckBoxField DataField="Locked" HeaderText="是否锁定" ReadOnly="True">
                            <ControlStyle CssClass="checkBox" />
                        </asp:CheckBoxField>
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editVote"
                                    CommandArgument='<%# Eval("VoteId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加投票">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addVote" CommandArgument='<%# Eval("VoteId").ToString().Trim() %>'
                                    Text="添加投票" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="VoteSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>投票&nbsp;
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainLeftTd">
                            投票标题:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="VoteTitle" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="VoteTitle"
                                Display="Dynamic" ErrorMessage="投票标题必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            投票类型:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:RadioButtonList ID="TypeList" runat="server" CssClass="radio" RepeatDirection="Horizontal"
                                RepeatLayout="Flow">
                                <asp:ListItem Value="false">单选投票</asp:ListItem>
                                <asp:ListItem Value="true">多选投票</asp:ListItem>
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TypeList"
                                Display="Dynamic" ErrorMessage="投票类型必须选择"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            是否锁定:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:RadioButtonList ID="LockedList" runat="server" CssClass="radio" RepeatDirection="Horizontal"
                                RepeatLayout="Flow">
                                <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                                <asp:ListItem Value="true">是</asp:ListItem>
                            </asp:RadioButtonList>
                            <span class="explain">锁定后用户将不能再进行投票</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            投票选项:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:TextBox ID="LabelStr" runat="server" Rows="5" TextMode="MultiLine" CssClass="fLeft"></asp:TextBox>
                            <span class="explain fLeft">
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="LabelStr"
                                    Display="Dynamic" ErrorMessage="投票选项列表必须填写&lt;br /&gt;"></asp:RequiredFieldValidator>
                                投票选项一行一条<br />
                                例如:<br />
                                好<br />
                                一般<br />
                                还行<br />
                                差</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            初始化票数:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                            <asp:TextBox ID="ValueStr" runat="server" Rows="5" TextMode="MultiLine" CssClass="fLeft"></asp:TextBox>
                            <span class="explain fLeft">
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="ValueStr"
                                    Display="Dynamic" ErrorMessage="初始化票数必须填写<br />"></asp:RequiredFieldValidator>
                                初始化票数一行一条<br />
                                例如:<br />
                                30<br />
                                20<br />
                                5<br />
                                3</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加投票" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
