﻿<%@ page language="C#" autoeventwireup="true" inherits="phone_Notice_NoticeList, Web" %>

<%@ Register Src="~/phone/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/phone/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>学校网上订餐预约系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/phone/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <style type="text/css">
        .l {
            font-weight: inherit;
        }
    </style>
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container-fluid ">
        <div class="row">
            <div class="col-xs-12 cont">
                <div class="panel panel-default">
                    <!-- Default panel contents -->
                    <div class="panel-heading">
                        <span style="font-weight: bold;">在线公告
                        </span>
                    </div>

                    <div id="list" class="list-group" style="font-size: 15px;">
                        <asp:Repeater ID="rptData" runat="server">
                            <ItemTemplate>
                                <a class="list-group-item l " href="NoticeDetail.aspx?id=<%#Eval("n_id")%>">
                                    <span class="badge badge_1">
                                        <i class="glyphicon glyphicon-chevron-right"></i>
                                    </span>
                                    <%#Eval("n_title")%>
                                    [<%#((DateTime)Eval("n_date")).ToString("yyyy-MM-dd") %>]
                                </a>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                </div>

            </div>
        </div>
    </div>


    <div class="container">
        <div class="row">
            <div class="col-xs-12">

                <div style="width: 100%; bottom: 0; position: fixed; right: 0; left: 0; z-index: 1030;">
                    <!-- Large modal -->
                    <div class="btn-group btn-group-justified" role="group" aria-label="...">
                        <div class="btn-group" role="group">
                            <a href="/phone/OrderMeal/OrderMeal.aspx" type="button" class="btn btn-default btn-bm ">
                                <i class="glyphicon glyphicon-plus"></i>
                                订餐</a>
                        </div>
                        <div class="btn-group" role="group">
                            <a href="/phone/OrderMeal/CurrentOrderMeal.aspx" type="button" class="btn btn-default btn-bm">
                                <i class="glyphicon glyphicon-th"></i>
                                我的订餐</a>
                        </div>

                         <div class="btn-group" role="group">
                        <a href="/phone/Notice/NoticeList.aspx" type="button" class="btn btn-default btn-bm">
                            <i class="glyphicon glyphicon-th-list"></i>
                            在线公告</a>
                        
                         </div>
       
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var index = 2;
        var size = 10;
        var canload = 1;
        $(window).scroll(function () {
            if ($(document).scrollTop() >= $(document).height() - $(window).height()) {
                if(canload==1)
                    loadPageing();
            }
        });
        function loadPageing() {
                ZENG.msgbox.show('加载中', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "index":index,"size":size },
                    success: function (result) {
                        canload = result.canload;
                        var list = result.list;
                        var l = list.length;
                        var sb = new StringBuilder();
                        for (var i = 0; i < l; i++) {
                            var item = list[i]
                            sb.append("<a class='list-group-item l' href='NoticeDetail.aspx?id"+item.id+"'>");
                            sb.append("<span class='badge badge_1'>");
                            sb.append("<i class='glyphicon glyphicon-chevron-right'></i>");
                            sb.append("</span>");
                            sb.append(item.title)
                            sb.append("["+item.date+"]");
                            sb.append("</a>");
                        }
                        $("#list").append(sb.tostring());
                        index++;
                        ZENG.msgbox._hide();
                    }
                });
        }


        function StringBuilder() {
            this.__strings__ = new Array;

            if (typeof StringBuilder._initialized == "undefined") {
                StringBuilder.prototype.append = function (str) {
                    this.__strings__.push(str);
                };

                StringBuilder.prototype.prvAppend = function (str) {
                    this.__strings__.unshift(str);
                };

                StringBuilder.prototype.tostring = function () {
                    return this.__strings__.join("");
                };
                StringBuilder._initialized = true;
            }
        }
        //------------------Format---------------------------
        String.prototype.format = function () {
            var args = arguments;
            return this.replace(/\{(\d+)\}/g,
                function (m, i) {
                    return args[i];
                });
        }
        String.format = function () {
            if (arguments.length == 0)
                return null;

            var str = arguments[0];
            for (var i = 1; i < arguments.length; i++) {
                var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
                str = str.replace(re, arguments[i]);
            }
            return str;
        }

    </script>
</body>
</html>