﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_Config, Web" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>学校网上订餐预约系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/My97DatePicker/WdatePicker.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
    <style>
         .rd{
            color:red;
        }
    </style>
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container">
        <div class="row">
            <div class="col-xs-12 ">
                <h3 class="page-header">系统设置<small> 设置系统相关参数</small></h3>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">

                <form id="from1" runat="server">
                    <div class="form-group">
                        <label class="control-label">
                            系统名称<span class='rd'>*</span>：
                            <asp:RequiredFieldValidator ID="rfvt_name" runat="server" ForeColor="Red" ErrorMessage="请填写"
                            ControlToValidate="txtt_name"></asp:RequiredFieldValidator>
                        </label>
                        <asp:TextBox ID="txtt_name" runat="server" MaxLength="50" CssClass="form-control"></asp:TextBox>
                    </div>
                    <h3 class="page-header"><small>提前预定时间</small></h3>
                    <div class="form-group">
                        <label class="control-label">
                            早餐<span class='rd'>*</span>：
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ForeColor="Red" ErrorMessage="请填写"
                            ControlToValidate="txt_time1"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="revbmeal" runat="server" ForeColor="Red" ControlToValidate="txt_time1" ValidationExpression="^-?\d+$" Display="Dynamic"
                                ErrorMessage="必须是整数"></asp:RegularExpressionValidator>
                        </label>
                        <asp:TextBox ID="txt_time1" runat="server"  placeholder="小时" MaxLength="50" CssClass="form-control"></asp:TextBox>
                         <p class="help-block">按当天9点计算，若要前一天20点前预定，应设置13（小时）</p>
                    </div>
                    <div class="form-group">
                        <label class="control-label">
                            午餐<span class='rd'>*</span>：
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ForeColor="Red" ErrorMessage="请填写" Display="Dynamic"
                            ControlToValidate="txt_time2"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="revtime2" runat="server" ForeColor="Red" ControlToValidate="txt_time2" ValidationExpression="^-?\d+$" Display="Dynamic"
                                ErrorMessage="必须是整数"></asp:RegularExpressionValidator>
                        </label>
                        <asp:TextBox ID="txt_time2" runat="server" MaxLength="50" CssClass="form-control"></asp:TextBox>
                         <p class="help-block">按当天14点计算</p>
                    </div>
                    <div class="form-group">
                        <label class="control-label">
                            晚餐<span class='rd'>*</span>：
                            <asp:RequiredFieldValidator ID="rfvtime3" runat="server" ForeColor="Red" ErrorMessage="请填写"
                            ControlToValidate="txt_time3"></asp:RequiredFieldValidator> 
                             <asp:RegularExpressionValidator ID="revtime3" runat="server" ForeColor="Red" ControlToValidate="txt_time3" ValidationExpression="^-?\d+$" Display="Dynamic"
                                ErrorMessage="必须是整数"></asp:RegularExpressionValidator>                          
                        </label>
                        <asp:TextBox ID="txt_time3" runat="server" MaxLength="50" CssClass="form-control"></asp:TextBox>
                         <p class="help-block">按当天20点计算</p>
                    </div>
                    <div class="form-group">
                        <label class="control-label">
                            部门设置<span class='rd'>*</span>：
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ForeColor="Red" ErrorMessage="请填写"
                            ControlToValidate="txt_dept"></asp:RequiredFieldValidator>                
                        </label>
                        <asp:TextBox ID="txt_dept" runat="server" MaxLength="50" TextMode="MultiLine" Rows="2" CssClass="form-control"></asp:TextBox>
                        <p class="help-block">部门之间用英文的“,”分隔</p>
                    </div>
                    <div class="form-group">
                        <asp:Button ID="btnSubmit" runat="server" Text="提交设置"
                            CssClass="btn  btn-primary btn-block"
                            OnClick="btnSubmit_Click" />
                    </div>

                </form>

            </div>
        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />
    <script>
        $('textarea').on('input', function () {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    </script>
</body>
</html>
