using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Threading.Tasks;

namespace OneMore.Areas.Admin.Models
{
    public class mydbContext : DbContext
    {
        public mydbContext(DbContextOptions<mydbContext> options) : base(options) { }

        public DbSet<Qxlist> Qxlists { get; set; }
        public DbSet<Amenu> Amenus { get; set; }
        public DbSet<QAzu> QAzus { get; set; }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Qxlist>().ToTable("Admin_qxs");
            modelBuilder.Entity<Amenu>().ToTable("Admin_menu");
            modelBuilder.Entity<QAzu>().ToTable("Admin_zu");
        }
    }

    public class QAzu
    {//Table:Admin_zu 后台权限组规划及管理员权限组设置
        public int Id { get; set; }
        public string zuid { get; set; }
        public string zm { get; set; }
        public int px { get; set; }
        public string lx { get; set; }//s表示后台权限组规划
        public string sm { get; set; }//分组备注
    }
    public class Qxlist
    {//Table:Admin_qxs 权限列表模型 
        public int Id { get; set; }
        public string scid { get; set; }
        public string c { get; set; }
        public string a { get; set; }
        public string v { get; set; }
        public string sta { get; set; }
    }
    public class Amenu
    {//Table:Admin_menu 后台菜单
        public int Id { get; set; }
        public string muid { get; set; }
        public string mjb { get; set; }
        public string mname { get; set; }
        public string mlx { get; set; }
        public string mroute { get; set; }
        public string mcontroller { get; set; }
        public string maction { get; set; }
        public string murl { get; set; }
        public int px { get; set; }
    }

    public class Memlogin
    {
        public string pid { get; set; }
        public string lgm { get; set; }
        public string xm { get; set; }
        public string lx { get; set; }
        public string zuids { get; set; }
        public virtual List<Mqxlist> ustop { get; set; }
    }

    public class Mqxlist
    {
        public string c { get; set; }//Controller值
        public string a { get; set; }//Action值
        public string v { get; set; }//自定义权限代码
        public string s { get; set; }//Super标记
    }

    public class Amem
    {//帐号列表模型 
        public int Id { get; set; }
        public string pid { get; set; }
        public string lgm { get; set; }
        public string xm { get; set; }
        public string pwd { get; set; }
        public string zuids { get; set; }
        public string lx { get; set; }
        public string ctime { get; set; }
    }




    //eMsg消息传递

    public class eMsgv
    {
        public enum go  //枚举类型
        {
            goAction = 1,
            goBack = 2,
            goUrl = 3
        }

        public string Msgtxt { get; set; }
        public string RoutName { get; set; }
        public string Controller { get; set; }
        public string Action { get; set; }
        public string Url { get; set; }
        public string v { get; set; }
        public int Udo { get; set; }
    }



}
