using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.AspNetCore.Razor.TagHelpers;
using Microsoft.AspNetCore.Routing;
using Microsoft.EntityFrameworkCore;
using Newtonsoft.Json;
using OneMore.Areas.Admin.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace OneMore.Models
{

    public static class Ones
    {
        private static IHttpContextAccessor HttpContextAccessor;
        public static void Configure(IHttpContextAccessor httpContextAccessor)
        {
            HttpContextAccessor = httpContextAccessor;
        }
        public static HttpContext HttpContext
        {
            get
            {
                return HttpContextAccessor.HttpContext;
            }
        }




        public static bool uPermit(String cv, String av)
        {//未登录 无权访问 授权访问
            var mems = HttpContext.Session.GetObj<Memlogin>("mems");
            if (mems == null) { return false; }
            if (mems.lx == "S")
            {
                return true;
            }
            //如果是A判断是否在Super禁止中
            if (mems.lx == "A")
            {
                if (mems.ustop.Where(m => m.s == "1" && String.Compare(m.c, cv, true) == 0 && String.Compare(m.a, av, true) == 0).Count() > 0)
                { return false; }
                else { return true; }
            }
            //普通用户
            if (mems.ustop.Where(m => String.Compare(m.c, cv, true) == 0 && String.Compare(m.a, av, true) == 0).Count() > 0)
            { return false; }
            else { return true; }
        }

        public static bool uPermit(String icode)
        {
            var mems = HttpContext.Session.GetObj<Memlogin>("mems");
            if (mems == null) { return false; }
            if (mems.lx == "S")
            {
                return true;
            }
            //如果是A判断是否在Super禁止中
            if (mems.lx == "A")
            {
                if (mems.ustop.Where(m => m.s == "1" && String.Compare(m.v, icode, true) == 0).Count() > 0)
                { return false; }
                else { return true; }
            }
            //普通用户
            if (mems.ustop.Where(m => String.Compare(m.v, icode, true) == 0).Count() > 0)
            { return false; }
            else { return true; }
        }

    }

    public class One
    {


    }


    public class Dbfohelper
    {
        /// <summary>
        /// var result1 = dbdb.SqlQuery<mfoods>(db, "select xm from mems");
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="db"></param>
        /// <param name="sql"></param>
        /// <param name="parameters"></param>
        /// <returns></returns>
        public static IList<T> SqlQuery<T>(DbContext db, string sql, params object[] parameters) where T : new()
        {
            //注意：不要对GetDbConnection获取到的conn进行using或者调用Dispose，否则DbContext后续不能再进行使用了，会抛异常
            var conn = db.Database.GetDbConnection();
            try
            {
                conn.Close();
                conn.Open();
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = sql;
                    command.Parameters.AddRange(parameters);
                    var propts = typeof(T).GetProperties();
                    var rtnList = new List<T>();
                    T model;
                    object val;
                    
                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            model = new T();

                            for (var i = 0; i < reader.FieldCount; i++)
                            {
                                foreach (var l in propts)
                                {
                                    if (Equals(l.Name, reader.GetName(i)))
                                    {
                                        val = reader[l.Name];
                                        if (val == DBNull.Value)
                                        {
                                            l.SetValue(model, null);
                                        }
                                        else
                                        {
                                            l.SetValue(model, val);
                                        }
                                    }
                                }
                            }
                            rtnList.Add(model);
                        }
                    }
                    return rtnList;
                }
            }
            finally
            {
                conn.Close();
            }
        }

    }

    public static class SessionEx
    {
        public static void SetObj(this ISession session, string key, object value)
        {
            session.SetString(key, JsonConvert.SerializeObject(value));
        }

        public static T GetObj<T>(this ISession session, string key)
        {
            var value = session.GetString(key);
            return value == null ? default(T) : JsonConvert.DeserializeObject<T>(value);
        }
    }
}

namespace HHFcoreTag.TagHelpers
{
    [HtmlTargetElement("HF.gl")]//<HF.gl selbool="true" selint="2" >abc【或】def</HF.gl>
    [HtmlTargetElement(Attributes = nameof(Selbool))]
    [HtmlTargetElement(Attributes = nameof(Selint))]
    public class MyTagHelper : TagHelper
    {
        public bool Selbool { get; set; }
        public int Selint { get; set; }
        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            output.TagName = "";
            var htmls = Regex.Split(output.GetChildContentAsync().Result.GetContent(), "【或】", RegexOptions.IgnoreCase);

            //不可同时使用两个条件
            if (context.AllAttributes.ContainsName("selbool") == true && context.AllAttributes.ContainsName("selint") == true)
            {
                output.Content.SetHtmlContent("<b><font color=#ff0000>错误：selbool、selint条件属性不可同时使用！</font></b>");
                return;
            }

            //条件选择（布尔值）
            if (context.AllAttributes.ContainsName("selbool"))
            {
                if (Selbool == true)
                {
                    output.Content.SetHtmlContent(htmls[0]);
                }
                else
                {
                    if (htmls.Count() > 0) { output.Content.SetHtmlContent(htmls[1]); } else { output.Content.SetHtmlContent(""); }
                }
            }

            //条件选择（数字序号）
            if (context.AllAttributes.ContainsName("selint"))
            {
                if (Selint <= htmls.Count() && Selint >= 1)
                {
                    output.Content.SetHtmlContent(htmls[Selint - 1]);
                }
                else { output.Content.SetHtmlContent(""); }
            }

        }
    }



}

