﻿Public Class frmBookReturn
    Dim UserStr As String
    Dim columStr(5) As String
    Dim FieldStr(5) As String
    Private Sub btnReturn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnReturn.Click
        Dim UserString As String = UserStr
        Dim ReturnKind As Integer = UserKind

        If UserKind = OwerKind.Taff Then
            If txtUserID.Text.Trim <> "" Then
                UserString = txtUserID.Text.Trim
                ReturnKind = OwerKind.User
            End If
        End If

        If lsBook.SelectedItems.Count <= 0 Then
            MsgBox("未选择图书，请选择你要归还的图书", MsgBoxStyle.Information + MsgBoxStyle.OkOnly, "信息")
            Exit Sub
        Else
            '删除借阅表里对应的记录
            Dim Num As Integer = lsBook.SelectedItems(0).Index
            If cbFindKind.Text.Trim = "权限内所有用户" Then
                ReturnKind = 1
                UserString = lsBook.Items(Num).SubItems(1).Text.Trim
            End If
            DBBorrow.RturnBook(UserString, ReturnKind, lsBook.Items(Num).SubItems(2).Text.Trim)
            '删除列表框里对应的行
            lsBook.Items.RemoveAt(lsBook.SelectedItems(0).Index)
            MsgBox("还书成功！", MsgBoxStyle.Information + MsgBoxStyle.OkOnly, "信息")
        End If
    End Sub

    Private Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub
    '查找用户 已经借阅的图书 并且尚未归还的图书
    Private Sub btnFind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFind.Click
        Dim Table As New DataTable
        Dim UserString As String = UserStr         '初始化查找条件
        Dim ReturnKind As Integer = UserKind       '初始化查找条件

        Me.lsBook.Items.Clear()                    '每次查找的时候都将上次的查找结果清空

        If UserKind = OwerKind.Taff Then
            Select Case cbFindKind.SelectedIndex
                Case 0 '什么也不做
                Case 1 '查找对象是单个用户
                    If txtUserID.Text.Trim = "" Then
                        MsgBox("您未输入查找的用户的ID号，请重新输入", _
                               MsgBoxStyle.Exclamation + MsgBoxStyle.OkOnly, "错误")
                        Exit Sub
                    Else
                        UserString = txtUserID.Text.Trim
                        ReturnKind = OwerKind.User
                    End If
                Case 2 '查找对象是权限范围内所有的用户
                    If Taff.UserID = "Admin" Then
                        UserString = "All"
                    Else
                        UserString = "AllUser"
                    End If
            End Select
        End If

        Table = DBBorrow.SelectBookBorrow(UserString, ReturnKind)

        If Table IsNot Nothing Then
            If Table.Rows.Count <= 0 Then
                MsgBox("没有在借的书目", MsgBoxStyle.Information + MsgBoxStyle.OkOnly, "消息")
                btnReturn.Enabled = False
                Exit Sub
            Else
                Dim DView As DataView
                DView = New DataView(Table)
                Dim Str As String
                Dim Count As Integer = Table.Rows.Count
                Dim dr As DataRowView
                '将查找的记录录入列表框内
                For Each dr In DView
                    Str = dr(FieldStr(0)).ToString
                    Dim ListItem As New ListViewItem(Str)
                    Str = dr(FieldStr(1)).ToString
                    ListItem.SubItems.Add(Str)
                    Str = dr(FieldStr(2)).ToString
                    ListItem.SubItems.Add(Str)
                    Str = dr(FieldStr(3)).ToString
                    ListItem.SubItems.Add(Str)
                    Str = dr(FieldStr(4)).ToString
                    ListItem.SubItems.Add(Str)
                    Str = dr(FieldStr(5)).ToString
                    ListItem.SubItems.Add(Str)
                    lsBook.Items.Add(ListItem)
                Next
            End If

        End If
        btnReturn.Enabled = True
    End Sub
    '初始化为列表框控件添加列标题
    Private Sub frmBookReturn_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '如果是管理员择可以查找所有人的借书记录，
        '如果是普通用户的话就只能查看自己的借书记录
        If UserKind = OwerKind.Taff Then
            cbFindKind.SelectedIndex = 1
            UserStr = Taff.UserID
        Else
            lbID.Visible = False
            txtUserID.Visible = False
            lbKind.Visible = False
            cbFindKind.Visible = False
            UserStr = User.UserID
        End If
        lsBook.View = View.Details
       
        columStr(0) = "用户姓名"                              '初始化动态添加列表框的表头
        columStr(1) = "用户ID"
        columStr(2) = "图书ID"
        columStr(3) = "书籍名称"
        columStr(4) = "ISBN"                                  '初始化动态添加列表框的表头
        columStr(5) = "借阅时间"
        FieldStr(0) = "name"
        FieldStr(1) = "userid"
        FieldStr(2) = "bookid"                                '初始化动态添加列表框的表头
        FieldStr(3) = "bookname"
        FieldStr(4) = "ISBN"
        FieldStr(5) = "borrowtime"                            '初始化动态添加列表框的表头

        For i As Integer = 0 To 5
            lsBook.Columns.Add(columStr(i), 70, HorizontalAlignment.Left)
        Next
        btnReturn.Enabled = False
    End Sub
    '选择不同的查找选项对应的输入条件文本框的状态
    Private Sub cbFindKind_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbFindKind.SelectedIndexChanged
        Select Case cbFindKind.Text.Trim
            Case "本用户"
                txtUserID.Enabled = False
            Case "权限内所有用户"
                txtUserID.Enabled = False
            Case "单个用户"
                txtUserID.Enabled = True
        End Select
    End Sub
End Class