﻿Public Class frmBookSelect
    Public BorrowBookID As String
    Public BorrowNum As Integer
    Dim SelectKind As FindKind
    Dim FindText As String
    '数据绑定标志
    Dim BandFlag As Boolean
    Dim SuperFindFlag As Boolean = False
    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        Me.Close()
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub frmBookSelect_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        BandFlag = False
        btnBorrow.Enabled = False
        If SuperFindFlag = False Then
            Me.Height = 365                 '初始化不显示高级查找控件
        Else
            Me.Height = 490                 '显示高级查找控件
        End If
    End Sub
    '查找相关书目
    Private Sub btnFind_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFind.Click
        If SuperFindFlag = True Then            '高级查找条件

            dgviewBook.DataSource = Nothing     '每次查找的时候都将上次的查找结果清空
            SelectKind = FindKind.BookSuper
            If txtAuthor.Text.Trim = "" And txtID.Text.Trim = "" _
                       And txtISBN.Text.Trim = "" And txtName.Text.Trim = "" Then  '当什么条件都没有写的时候
                MsgBox("您未输入任何查询条件无法进行查询，请输入查询条件", _
                                               MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation, "错误")
                txtName.Focus()
                Exit Sub
            Else
                FindText = "select  [bookid] as 书目ID," + _
                               "[bookname] as 书目名称," + _
                               "[ISBN] as ISBN号," + _
                               "[price] as 单价," + _
                               "[author] as 作者," + _
                               "[time] as 出版年份," + _
                               "[remark] as 备注," + _
                               "[station] as 状态一," + _
                               "[station1] as 状态二 " + _
                               "from tbBook" + _
                               " where [author] like '%" + txtAuthor.Text.Trim + "%' and " + _
                               "[bookname] like '%" + txtName.Text.Trim + "%' and " + _
                               "[ISBN] like '%" + txtISBN.Text.Trim + "%' and " + _
                               "[bookid] like '%" + txtID.Text.Trim + "%'"
            End If
            '普通查找的查找条件
        Else
            FindText = txtFind.Text.Trim
            If FindText = "" And comboxFind.Text.Trim <> "所有书目" Then
                MsgBox("请输入你要查询的条件", MsgBoxStyle.Information + MsgBoxStyle.OkOnly, "消息")
                Exit Sub
            End If

            Select Case comboxFind.Text.Trim
                Case "书目名称"
                    SelectKind = FindKind.BookName
                Case "图书ISBN"
                    SelectKind = FindKind.BookISBN
                Case "图书作者"
                    SelectKind = FindKind.BookAuthor
                Case "书目ID"
                    SelectKind = FindKind.BookId
                Case "所有书目"
                    SelectKind = FindKind.All
            End Select

        End If
        '置绑定标志为真
        BandFlag = True
        '绑定数据
        BandData()
    End Sub
    '初始绑定借阅书籍的数据到窗体上或借阅后预约后重新绑定数据
    Public Sub BandData()
        Dim BookTable As New DataTable
        BookTable = Book.SelectBook(SelectKind, FindText)
        If BookTable.Rows.Count > 0 Then
            btnBorrow.Enabled = True
            Me.dgviewBook.DataSource = BookTable
        Else
            MsgBox("没有相关信息，查找失败", MsgBoxStyle.Information + MsgBoxStyle.OkOnly, "信息")
            btnBorrow.Enabled = False
        End If
    End Sub
    '调用显示借阅窗体事件
    Private Sub btnBorrow_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnBorrow.Click
        If dgviewBook.SelectedRows.Count <= 0 Then
            If dgviewBook.SelectedCells.Count <= 0 Then
                MsgBox("请选择你要借阅的书目！", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation, "信息框")
                Exit Sub
            End If
            BorrowNum = dgviewBook.SelectedCells(0).RowIndex
        Else
            BorrowNum = dgviewBook.SelectedRows(0).Index
        End If

        Me.Visible = False
        BorrowBookID = dgviewBook.Rows(BorrowNum).Cells("书目ID").Value
        Dim frmBorrowBookDlg As Form = frmBookBorrow
        frmBorrowBookDlg.MdiParent = Me.MdiParent
        frmBorrowBookDlg.Show()

        BandFlag = True
    End Sub

    Private Sub frmBookSelect_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
        '判断是不是第一次加载窗体如果是的话就不绑定数据，否则就绑定数据
        If Me.Visible = True And BandFlag = True Then
            BandData()
        End If
    End Sub

    Private Sub btnSuperFind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSuperFind.Click
        btnSuperFind.Text = "普通查找"
        If SuperFindFlag = False Then           '高级查找显示窗体隐藏的控件
            txtName.Text = ""
            txtAuthor.Text = ""
            txtID.Text = ""
            txtISBN.Text = ""
            comboxFind.Enabled = False          '高级查找时候普通查找控件无效
            txtFind.Enabled = False
            SuperFindFlag = True
            Me.Height = 490
        Else                                     '普通查找隐藏高级查找控件
            comboxFind.Enabled = True            '普通查找时候普通查找控件有效
            txtFind.Enabled = True
            btnSuperFind.Text = "高级查找"
            SuperFindFlag = False
            Me.Height = 365
        End If
    End Sub
End Class