﻿Public Class frmChangBook
    Private Sub frmChangBook_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim Table As New DataTable
        Dim dr As DataRow

        Table = Book.SelectBook(frmBookManage.EditId)
        If Table.Rows.Count > 0 Then
            dr = Table.Rows(0)
            With Me
                .txtBookID.Text = dr("bookid").ToString.Trim
                .txtISBN.Text = dr("ISBN").ToString.Trim
                .txtName.Text = dr("bookname").ToString.Trim
                .txtPrice.Text = dr("price").ToString.Trim
                .txtAuthor.Text = dr("author").ToString.Trim
                .txtTime.Text = dr("time").ToString.Trim
                .txtTemp.Text = dr("remark").ToString.Trim
                .txtBookID.Enabled = False
            End With
        Else
            Exit Sub
        End If
    End Sub
    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        Dim BookAdd As New DBBook("", "")
        Dim Sqlstr As String = ""
        Dim Table As New DataTable
        If txtName.Text.Trim = "" Then
            MsgBox("书目名不能为空，请重新填写！", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation, "警告")
            Exit Sub
        ElseIf txtISBN.Text.Trim = "" Then
            MsgBox("ISBN号不能为空，请重新填写！", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation, "警告")
            Exit Sub
        End If
        If txtPrice.Text <> "" Then  '判断输入的价格是否是合法的
            Try
                Dim price As Decimal
                price = Convert.ToDecimal(txtPrice.Text.Trim)
                If price < 0 Then
                    MsgBox("您输入的价格非法，请重新输入!", MsgBoxStyle.Critical + MsgBoxStyle.OkOnly, "操作错误")
                    txtPrice.Text = ""
                    txtPrice.Focus()
                    Exit Sub
                End If
            Catch ex As Exception
                MsgBox("您输入的价格非法，请重新输入!", MsgBoxStyle.Critical + MsgBoxStyle.OkOnly, "操作错误")
                txtPrice.Text = ""
                txtPrice.Focus()
                Exit Sub
            End Try
        End If
        If txtTime.Text <> "" Then       '判断输入的年份是否是非法的
            Try
                Dim year As Integer
                year = Convert.ToDecimal(txtTime.Text.Trim) ' Then
                If year < 0 Or year > Now.Year Then
                    MsgBox("您输入的年份非法，请重新输入!", MsgBoxStyle.Critical + MsgBoxStyle.OkOnly, "操作错误")
                    txtTime.Text = ""
                    txtTime.Focus()
                    Exit Sub
                End If
            Catch ex As Exception
                MsgBox("您输入的年份非法，请重新输入!", MsgBoxStyle.Critical + MsgBoxStyle.OkOnly, "操作错误")
                Exit Sub
            End Try
        End If

        BookAdd.BookID = txtBookID.Text.Trim
        BookAdd.BookName = txtName.Text.Trim
        BookAdd.ISBN = txtISBN.Text.Trim
        BookAdd.Price = txtPrice.Text.Trim
        BookAdd.Remark = txtTemp.Text.Trim
        BookAdd.Author = txtAuthor.Text.Trim
        BookAdd.Time = txtTime.Text.Trim

        If BookAdd.UpdateBook(BookAdd) = False Then
            MsgBox("修改书目信息失败！", MsgBoxStyle.OkOnly + MsgBoxStyle.Critical, "信息")
        End If

        MsgBox("修改书目信息成功！", MsgBoxStyle.OkOnly + MsgBoxStyle.Information, "信息")
        frmBookManage.Band()

        Me.Finalize()
        Me.Close()
    End Sub
    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Finalize()
        Me.Close()
    End Sub
End Class 