﻿
/**
*判断元素是否在数组里
*/
function in_array(item, list) {
    for (var i = 0; i < list.length; i++) {
        if (item == list[i]) {
            return true;
        }
    }
    return false;
}

/**
 * 返回指定元素在数组中的索引, 如果没找到, 返回-1;
 */
function array_find(list, item) {
    for (var i = 0; i < list.length; i++) {
        if (item == list[i]) {
            return i;
        }
    }
    return -1;
}

// 从数组中删除元素. 返回新数组.
function array_del(list, item) {
    var arr = [];
    for (var i = 0; i < list.length; i++) {
        if (item != list[i]) {
            arr.push(list[i]);
        }
    }
    return arr;
}

// 从数组中删除元素. 返回新数组.
function array_del_all(list, items) {
    var arr = [];
    for (var i = 0; i < list.length; i++) {
        if (array_find(items, list[i]) == -1) {
            arr.push(list[i]);
        }
    }
    return arr;
}

/**
 * 把数组当作环形的, 返回从start开始, 一共count个元素.
 * 如果count大于数组长度, 返回整个数组.
 */
function array_slice(list, start, count) {
    var ret;

    ret = list.slice(start, start + count);
    if (ret.length < count) {
        ret = ret.concat(list.slice(0, count - ret.length));
    }

    return ret;
}

// 扰乱数组元素的顺序.
function array_shuffle(list) {
    var len = list.length;
    for (var i = 0; i < len * 5; i++) {
        var p1 = parseInt(len * Math.random());
        var p2 = parseInt(len * Math.random());
        var tmp = list[p1];
        list[p1] = list[p2];
        list[p2] = tmp;
    }
}