﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Hweny.TabSlider.TabSlideControl;
using System.Diagnostics;

namespace Hweny.TabSliderTest
{
    public partial class TabSliderDemo : Form
    {
        private SlideableTabControl slideTab1;
        private SlideableTabControl slideTab2;
        private AutoPlayTabControl slideTab3;
        private AutoPlayTabControl slideTab4;

        private Random r = new Random();

        public TabSliderDemo()
        {
            InitializeComponent();
 
            BindData();
            SetupControl();
        }

        /// <summary>
        /// 这里把控件命名为中文，主要是为了看的清楚
        /// </summary>
        public void BindData()
        {
            Control[] 滑动效果控件 = { 飞入, 先减速后加速飞入 };
            TabSlider.TabSlideEffectStyle[] 滑动效果 = { TabSlider.TabSlideEffectStyle.FLEW_INTO, TabSlider.TabSlideEffectStyle.FLEW_LOW_FLEW_HIGH_INTO };
            for (int i = 0; i < 滑动效果控件.Length; i++)
            {
                滑动效果控件[i].Tag = 滑动效果[i];
            }

            Control[] 滑动方向控件 = 
            {
                无方向,
                从上往下,
                从下往上,
                从左到右,
                从右往左,
                从左上往右下,
                从右下往左上,
                从左下往右上,
                从右上往左下
            };
            TabSlider.TabSlideEffectDirection[] 滑动方向 =
            {
                TabSlider.TabSlideEffectDirection.NONE,
                TabSlider.TabSlideEffectDirection.UP_TO_DOWN,
                TabSlider.TabSlideEffectDirection.DOWN_TO_UP,
                TabSlider.TabSlideEffectDirection.LEFT_TO_RIGHT,
                TabSlider.TabSlideEffectDirection.RIGHT_TO_LEFT,
                TabSlider.TabSlideEffectDirection.LEFT_UP_TO_RIGHT_DOWN,
                TabSlider.TabSlideEffectDirection.RIGHT_DOWN_TO_LEFT_UP,
                TabSlider.TabSlideEffectDirection.LEFT_DOWN_TO_RIGHT_UP,
                TabSlider.TabSlideEffectDirection.RIGHT_UP_TO_LEFT_DOWN
            };
            for (int i = 0; i < 滑动方向控件.Length; i++)
            {
                滑动方向控件[i].Tag = 滑动方向[i];
            }

            Control[] 自动滑动模式控件 = 
            {
                环绕,
                往返,
                随机
            };
            AutoPlayMode[] 自动滑动模式 =
            {
                AutoPlayMode.WRAP,
                AutoPlayMode.REVERSE,
                AutoPlayMode.RANDOM
            };
            for (int i = 0; i < 自动滑动模式控件.Length; i++)
            {
                自动滑动模式控件[i].Tag = 自动滑动模式[i];
            }

            int no = 1;
            foreach (TabPage page in tabControl3.TabPages)
            {
                page.BackColor = Color.Indigo;
                foreach (Control ctl in page.Controls)
                {
                    Panel tile = ctl as Panel;
                    if (tile != null)
                    {
                        Label lbl = new Label();
                        lbl.Text = no.ToString();
                        lbl.ForeColor = Color.White;
                        lbl.Font = new Font("黑体", 20f);
                        tile.Controls.Add(lbl);
                        tile.BackColor = Color.FromArgb(r.Next(0, 256), r.Next(0, 256), r.Next(0, 256));
                        no++;
                    }
                }
            }

            DataTable dt = new DataTable();
            dt.Columns.Add("A");
            dt.Columns.Add("B");
            dt.Columns.Add("C");
            for (int i = 0; i < 5; i++)
            {
                DataRow row = dt.NewRow();
                row[0] = "aaa" + i.ToString();
                row[1] = "bbb" + i.ToString();
                row[2] = "ccc" + i.ToString();
                dt.Rows.Add(row);
            }

            dataGridView1.AutoGenerateColumns = true;
            dataGridView1.DataSource = dt;

            Application.Idle += new EventHandler(Application_Idle);
        }

        void Application_Idle(object sender, EventArgs e)
        {
            foreach (Control ctl in groupBox1.Controls)
            {
                RadioButton rbtn = ctl as RadioButton;
                if (rbtn != null && rbtn.Checked)
                {
                    slideTab1.SetEffect((TabSlider.TabSlideEffectStyle)rbtn.Tag);
                    slideTab3.SetEffect((TabSlider.TabSlideEffectStyle)rbtn.Tag);
                    break;
                }
            }

            foreach (Control ctl in groupBox2.Controls)
            {
                RadioButton rbtn = ctl as RadioButton;
                if (rbtn != null && rbtn.Checked)
                {
                    slideTab1.PageUpDirection = (TabSlider.TabSlideEffectDirection)rbtn.Tag;
                    slideTab1.PageDownDirection = (TabSlider.TabSlideEffectDirection)rbtn.Tag;

                    slideTab3.PageUpDirection = slideTab1.PageUpDirection;
                    slideTab3.PageDownDirection = slideTab1.PageDownDirection;
                    break;
                }
            }

            foreach (Control ctl in groupBox5.Controls)
            {
                RadioButton rbtn = ctl as RadioButton;
                if (rbtn != null && rbtn.Checked)
                {
                    slideTab3.Mode = (AutoPlayMode)rbtn.Tag;
                    break;
                }
            }

            slideTab1.SlidePageEamless = 标签页无缝滑动.Checked;
            slideTab3.SlidePageEamless = 标签页无缝滑动.Checked;
        }

        public void SetupControl()
        {
            slideTab1 = new SlideableTabControl(tabControl1);
            slideTab2 = new SlideableTabControl(tabControl2);
            slideTab3 = new AutoPlayTabControl(tabControl3);
            slideTab4 = new AutoPlayTabControl(tabControl4);

            slideTab3.Play();
            slideTab3.SlidePageChanged += new EventHandler(slideTab3_SlidePageChanged);
            label12.Text = "重绘TabControl后效果更好 第 " + (tabControl3.SelectedIndex + 1) + " 页";

            slideTab4.PageUpDirection = TabSlider.TabSlideEffectDirection.RIGHT_DOWN_TO_LEFT_UP;
            slideTab4.PageDownDirection = TabSlider.TabSlideEffectDirection.LEFT_TO_RIGHT;
            slideTab4.SetEffect(TabSlider.TabSlideEffectStyle.FLEW_INTO,100,100);
            slideTab4.SlidePageEamless = true;
            slideTab4.Play();
        }

        void slideTab3_SlidePageChanged(object sender, EventArgs e)
        {
            label12.Text = "重绘TabControl后效果更好 第 " + (tabControl3.SelectedIndex+1) + " 页";
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Process.Start("iexplore.exe", linkLabel1.Text);
            }
            catch { }
        }
    }
}
