using System;
using System.Collections.Generic;
using System.Text;
using EasyMR.Common.Data;
using EasyMR.Common;
using Newtonsoft.Json;
using EasyMR.Net;
using EasyMR.Base;

namespace EasyMR.Mgr.Base
{
    /// <summary>
    /// ¼
    /// </summary>
    public delegate void DataArrivedEventHandler(object sender, string command, object data);

    /// <summary>
    /// cell
    /// </summary>
    public class CellMgr
    {
        #region  

        /// <summary>
        /// ڵб
        /// </summary>
        private Dictionary<string, ClientService> CellList = new Dictionary<string, ClientService>();

        #endregion

        #region 캯

        public CellMgr()
        {

        }

        #endregion

        #region ¼

        /// <summary>
        /// ״̬ı¼
        /// </summary>
        public event NetStatusChangedEventHandler StatusChangedEventHandler;

        protected virtual void OnStatusChanged(object sender, NetStatusChangedClass obj)
        {
            if (StatusChangedEventHandler != null)
                StatusChangedEventHandler(sender, obj);
        }

        /// <summary>
        /// ݵ¼
        /// </summary>
        public event DataArrivedEventHandler DataArrivedEventHandler;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="taskName"></param>
        /// <param name="index"></param>
        protected virtual void OnDataArrived(object sender, string command, object obj)
        {
            if (DataArrivedEventHandler != null)
                DataArrivedEventHandler(sender, command, obj);
        }

        #endregion

        #region 

        /// <summary>
        /// 첽Ӽڵ
        /// </summary>
        /// <param name="ip"></param>
        /// <param name="port"></param>
        public void BeginConnectToCell(string ip, int port)
        {
            //ڵб
            ClientService client;

            if (CellList.ContainsKey(ip))
            {
                client = CellList[ip];
            }
            else
            {
                client = new ClientService();

                //״̬ı¼
                client.StatusChangedEventHandler += new NetStatusChangedEventHandler(client_StatusChangedEventHandler);

                //ݵ¼
                client.DataArrivedEventHandler += new NetDataArrivedEventHandler(client_DataArrivedEventHandler);

                CellList.Add(ip, client);
            }

            //ʼ
            client.BeginOpen(ip, port);
        }


        /// <summary>
        /// ݵ¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="data"></param>
        void client_DataArrivedEventHandler(object sender, object data)
        {
            RtpFrame frame = (RtpFrame)data;

            byte[] buffer = (byte[])frame.Data;

            string dataValue;
            string command;
            //
            if (!Protocal.ParseProtocal(buffer, out command, out dataValue))
            {
                return;
            }

            //ݵ¼
            this.OnDataArrived(sender, command, dataValue);

            ////ִ
            //switch (command)
            //{
            //    //ͬűɹ
            //    case Protocal.CMD_SynScriptOK:
            //        SynScriptRet(command, dataValue);
            //        break;

            //    //ִ״̬ı
            //    case Protocal.CMD_RunRet:
            //        RunScriptRet(command, dataValue);
            //        break;

            //    default:
            //        //ݵ¼
            //        this.OnDataArrived(command, dataValue);
            //}

        }

        /// <summary>
        /// 첽״̬ı¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="status"></param>
        void client_StatusChangedEventHandler(object sender, NetStatusChangedClass status)
        {
            this.OnStatusChanged(sender, status);
        }

        /// <summary>
        /// ͽű
        /// </summary>
        /// <param name="ip"></param>
        /// <param name="script"></param>
        public void SendScript(string ip, Script script)
        {
            ClientService client;

            if (CellList.ContainsKey(ip))
            {
                client = CellList[ip];
            }
            else
            {
                throw new Exception("ˣɣлûн.");
            }

            //سɹ
            DSynScript dRet = new DSynScript();

            dRet.DLLs = script.DLLs;
            dRet.ScriptCode = script.ScriptCode;
            dRet.TaskAssemblyName = script.TaskAssemblyName;

            string ret = JsonConvert.SerializeObject(dRet);

            ret = Protocal.CMD_SynScript + ret;

            //
            byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(ret);

            client.SendData(bData);

        }


        ///// <summary>
        ///// ͬű
        ///// </summary>
        ///// <param name="command"></param>
        ///// <param name="dataValue"></param>
        //private void SynScriptRet(string command, string data)
        //{
        //    //
        //    DSynScriptRet dData = JsonConvert.DeserializeObject<DSynScriptRet>(data);


        //    //ݵ¼
        //    this.OnDataArrived(command, dData);
        //}

        ///// <summary>
        ///// ִнű
        ///// </summary>
        ///// <param name="command"></param>
        ///// <param name="dataValue"></param>
        //private void RunScriptRet(string command, string data)
        //{
        //    //
        //    DRunRet dData = JsonConvert.DeserializeObject<DRunRet>(data);


        //    //ݵ¼
        //    this.OnDataArrived(command, dData);
        //}


        /// <summary>
        /// нű
        /// </summary>
        /// <param name="strJobID"></param>
        /// <param name="keys"></param>
        /// <param name="taskAssemblyName"></param>
        public void RunScript(string ip, string strJobID, string[] keys, string taskAssemblyName)
        {
            ClientService client;

            if (CellList.ContainsKey(ip))
            {
                client = CellList[ip];
            }
            else
            {
                throw new Exception("ˣɣлûн.");
            }

            //سɹ
            DRun dRet = new DRun();

            dRet.JobID = strJobID;
            dRet.Keys = keys;
            dRet.TaskAssemblyName = taskAssemblyName;

            string ret = JsonConvert.SerializeObject(dRet);

            ret = Protocal.CMD_Run + ret;

            //
            byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(ret);

            client.SendData(bData);

        }


        #endregion
    }

    /// <summary>
    /// űͬ״̬
    /// </summary>
    public enum SynScriptStatus
    {
        //δʼͬ
        UnSyn = 1,
        //ʼͬ
        StartSyn = 2,
        //ͬɹ
        SynOK = 3,
        //ͬʧ
        SynFailed = 4,
    }

    /// <summary>
    /// ״̬
    /// </summary>
    public enum RunStatus
    {
        //δʼͬ
        Unknown = 1,
        //ʼͬ
        Start = 2,
        //ͬɹ
        OK = 3,
        //ͬʧ
        Failed = 4,
    }
}
