using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Threading;
using System.Net;

using EasyMR.Net;
using EasyMR.Base;
using EasyMR.Common;

namespace EasyMR.Mgr.Base
{
    /// <summary>
    /// ¼
    /// </summary>
    public delegate void NetDataArrivedEventHandler(object sender, object data);

    /// <summary>
    /// ״̬¼
    /// </summary>
    public delegate void NetStatusChangedEventHandler(object sender, NetStatusChangedClass status);

    /// <summary>
    /// 
    /// </summary>
    public class ClientService
    {
        #region /ʼ

        /// <summary>
        /// ʼ
        /// </summary>
        public ClientService()
        {
        }

        #endregion

        #region /

        /// <summary>
        /// ӹ
        /// </summary>
        private Socket socket;

        /// <summary>
        /// 
        /// </summary>
        private object LockObject = new object();

        /// <summary>
        /// ݵ¼
        /// </summary>
        public event NetDataArrivedEventHandler DataArrivedEventHandler;

        /// <summary>
        /// ͬ
        /// </summary>
        public ManualResetEvent allDone = new ManualResetEvent(false);

        /// <summary>
        /// IPַ
        /// </summary>
        public string IP;

        /// <summary>
        /// ˿
        /// </summary>
        public int Port;

        private NetStatus _status = NetStatus.Unknow;
        /// <summary>
        /// ״̬
        /// </summary>
        public NetStatus Status
        {
            get
            {
                return _status;
            }
            set
            {
                //״ֵ̬ûиı䣬
                if (_status == value)
                {
                    return;
                }

                this.OnStatusChanged(this, new NetStatusChangedClass(_status, value));

                _status = value;
            }
        }

        /// <summary>
        /// ʱ
        /// </summary>
        private uint TSIncrement = 1;

        /// <summary>
        /// ʱ
        /// </summary>
        private uint TS = 0;

        /// <summary>
        /// ʶ
        /// </summary>
        private uint SSRC;

        /// <summary>
        /// ֡-
        /// </summary>
        private RtpFrame FrameSend;

        /// <summary>
        /// ֡-
        /// </summary>
        private Dictionary<uint, RtpFrame> FrameReceivePool;

        /// <summary>
        /// Millisecond delay to add between packet sends, used to govern network throughput on limited networks such as 802.11b
        /// </summary>
        private short DelayBetweenPackets = 1;

        ///// <summary>
        ///// ͬ
        ///// </summary>
        //public ManualResetEvent SendAllDone = new ManualResetEvent(false);

        /// <summary>
        /// ݳ
        /// </summary>
        private Stack<byte[]> BufferPool = new Stack<byte[]>(64);

        #endregion

        #region ¼
        /// <summary>
        /// 
        /// </summary>
        /// <param name="taskName"></param>
        /// <param name="index"></param>
        protected virtual void OnDataArrived(object sender, object obj)
        {
            if (DataArrivedEventHandler != null)
                DataArrivedEventHandler(sender, obj);
        }

        /// <summary>
        /// ״̬ı¼
        /// </summary>
        public event NetStatusChangedEventHandler StatusChangedEventHandler;

        protected virtual void OnStatusChanged(object sender, NetStatusChangedClass obj)
        {
            if (StatusChangedEventHandler != null)
                StatusChangedEventHandler(sender, obj);
        }

        #endregion

        #region 

        /// <summary>
        /// 첽
        /// </summary>
        /// <param name="port">4502-4534</param>
        public void BeginOpen(string ip,int port)
        {

            //IP
            this.IP = ip;
            this.Port = port;

            //ʼ֡
            this.FrameSend = new RtpFrame(Rtp.MAX_PACKET_SIZE, PayloadType.MyForum, TS);
            this.FrameReceivePool = new Dictionary<uint, RtpFrame>();

            //ʼ
            this.socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);

            //õķɣкͼض˿
            IPAddress address = IPAddress.Parse(this.IP);

            //ӵ㵥Ԫ
            this.socket.BeginConnect(address, this.Port, new AsyncCallback(ProcessConnect), null);

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="port">4502-4534</param>
        public NetStatus Open(string ip, int port)
        {
            //IP
            this.IP = ip;
            this.Port = port;

            //ʼ֡
            this.FrameSend = new RtpFrame(Rtp.MAX_PACKET_SIZE, PayloadType.MyForum, TS);
            this.FrameReceivePool = new Dictionary<uint, RtpFrame>();

            //ʼ
            this.socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);

            //õķɣкͼض˿
            IPAddress address = IPAddress.Parse(this.IP);

            //ӵ㵥Ԫ
            this.socket.Connect(address, this.Port);

            //ʧܣ
            if (this.socket.Connected)
            {

                //ӳɹ
                this.Status = NetStatus.Connected;

                //ʼ
                StartReceiving();
            }

            else
            {
                //ʧ
                this.Status = NetStatus.Disconnected;
            }


            return this.Status;
        }


        /// <summary>
        /// ɹӺĹ
        /// </summary>
        private void ProcessConnect(IAsyncResult ar)
        {

            //ʧܣ
            if (this.socket.Connected)
            {

                //ӳɹ
                this.Status = NetStatus.Connected;

                this.socket.EndConnect(ar);

                //ʼ
                StartReceiving();
            }

            else
            {
                //ʧ
                this.Status = NetStatus.Disconnected;
            }

        }

        /// <summary>
        /// ͳɹ
        /// </summary>
        /// <param name="e"></param>
        private void ProcessReceive(IAsyncResult ar)
        {
            try
            {
                //ȡݰ
                int iReadCount = 0;

                //ȡ
                ReceiveObject o = (ReceiveObject)ar.AsyncState;

                try
                {
                    //Ͽӣͷ
                    if (o == null || !o.Client.Connected)
                    {
                        //״̬
                        this.Status = NetStatus.Disconnected;

                        return;
                    }
                    iReadCount = o.Client.EndReceive(ar);

                }
                catch { }


                //ݳΪ0ͱѾϿ
                if (iReadCount < 1)
                {
                    //
                    o.Client.Close();
                    o = null;

                    //״̬
                    this.Status = NetStatus.Disconnected;

                    return;
                }

                lock (FrameReceivePool)
                {
                    //ȡ
                    byte[] buffer = new byte[iReadCount];

                    Array.Copy(o.Buffer, 0, buffer, 0, iReadCount);

                    //ճͷְ
                    if (BufferPool.Count > 0)
                    {
                        while (BufferPool.Count > 0)
                        {
                            byte[] temp1Chunk = (byte[])BufferPool.Pop();
                            byte[] temp2Chunk = buffer;

                            buffer = new byte[temp1Chunk.Length + temp2Chunk.Length];
                            Array.Copy(temp1Chunk, 0, buffer, 0, temp1Chunk.Length);
                            Array.Copy(temp2Chunk, 0, buffer, temp1Chunk.Length, temp2Chunk.Length);
                        }
                    }

                    RtpPacket packet = new RtpPacket((BufferChunk)buffer);

                    //ְ
                    if (packet.PacketTransLength > packet.Buffer.Length)
                    {
                        BufferPool.Push(buffer);

                        //ʼٴν
                        this.StartReceiving();

                        return;
                    }

                    //ճ
                    if (packet.PacketTransLength < packet.Buffer.Length)
                    {
                        //
                        byte[] temp1Chunk = (byte[])packet.Buffer.Peek((int)packet.PacketTransLength,
                            packet.Buffer.Length - (int)packet.PacketTransLength);

                        BufferPool.Push(temp1Chunk);

                        //ݴ
                        byte[] temp2Chunk = (byte[])packet.Buffer.Peek(0,
                            (int)packet.PacketTransLength);

                        packet = new RtpPacket((BufferChunk)temp2Chunk);
                    }

                    RtpFrame frame = GetFrame(packet.SSRC);

                    //
                    if (null == frame)
                    {
                        frame = new RtpFrame(packet.PacketsInFrame, packet.TimeStamp);
                        frame[packet.FrameIndex] = packet;
                        FrameReceivePool.Add(packet.SSRC, frame);
                    }
                    else
                    {
                        frame[packet.FrameIndex] = packet;
                    }

                    if (frame.Complete)
                    {
                        //ݵ¼
                        this.OnDataArrived(this, frame);

                        //Ƴ
                        FrameReceivePool.Remove(packet.SSRC);
                    }
                }

                //ʼٴν
                this.StartReceiving();


            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="SSRC"></param>
        private RtpFrame GetFrame(uint SSRC)
        {

            RtpFrame frame = null;
            if (FrameReceivePool.ContainsKey(SSRC))
            {
                frame = FrameReceivePool[SSRC];
            }

            return frame;

        }



        /// <summary>
        /// ʼ
        /// </summary>
        private void StartReceiving()
        {
            try
            {
                //
                ReceiveObject o = new ReceiveObject();
                o.Buffer = new byte[Rtp.MAX_PACKET_SIZE];
                o.Client = this.socket;

                //ٴοʼ
                AsyncCallback recieveData = new AsyncCallback(ProcessReceive);

                this.socket.BeginReceive(o.Buffer, 0, o.Buffer.Length,
                      SocketFlags.None, recieveData, o);
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="data"></param>
        public void SendData( byte[] data)
        {
            try
            {

                //̲߳
                lock (this.FrameSend)
                {
                    unchecked { TS += TSIncrement; }

                    //ʼ֡
                    this.FrameSend = new RtpFrame(Rtp.MAX_PACKET_SIZE, PayloadType.MyForum, TS);

                    //ӵ֡
                    //this.FrameSend.TimeStamp = TS;
                    this.FrameSend.Data = (BufferChunk)data;

                    //µSSRC
                    SSRC = ID.GetUInt;

                    this.FrameSend.Ssrc = SSRC;

                    for (ushort iIndex = 0; iIndex < this.FrameSend.PacketCount; iIndex++)
                    {
                        //this.FrameSend[iIndex].SourceID = NetID.ClientID;
                        //this.FrameSend[iIndex].ReceiverID = recID;
                        this.FrameSend[iIndex].PacketTransLength =
                         (uint)this.FrameSend[iIndex].Buffer.Length;

                        byte[] buffer = (byte[])this.FrameSend[iIndex].Buffer;

                        //첽
                        AsyncCallback sendData = new AsyncCallback(ProcessSend);
                        this.socket.BeginSend(buffer, 0, buffer.Length, SocketFlags.None, sendData, null);

                        if (DelayBetweenPackets != 0)
                        {
                            Thread.Sleep(DelayBetweenPackets); // To control bandwidth
                        }
                    }

                }
            }
            catch (Exception ex)
            {
                //¼־
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="e"></param>
        private void ProcessSend(IAsyncResult ar)
        {

        }

        /// <summary>
        /// ر
        /// </summary>
        /// <returns></returns>
        public NetStatus Close()
        {
            lock (this.LockObject)
            {
                if (null != this.socket)
                {
                    if (this.socket.Connected)
                    {
                        //this.socket.Shutdown(SocketShutdown.Both);
                        this.socket.Close();
                    }
                    this.socket = null;
                }

                return NetStatus.Disconnected;
            }
        }

        #endregion

    }



    /// <summary>
    /// ݸʽ
    /// </summary>
    public enum TranDataType
    {
        //ı
        Text = 1,
        //ͼƬ
        Image = 2,
        //ļ
        File = 3,
    }

    /// <summary>
    /// ״̬
    /// </summary>
    public enum NetStatus
    {
        //δ֪
        Unknow = 0,
        //Ͽ
        Disconnected = 1,
        //ӳɹ
        Connected = 2,
        //

    }

    public class NetStatusChangedClass
    {
        public NetStatusChangedClass(NetStatus lastStatus,
            NetStatus currentStatus)
        {
            this.LastStatus = lastStatus;
            this.CurrentStatus = currentStatus;
        }
        public NetStatus LastStatus = NetStatus.Unknow;
        public NetStatus CurrentStatus = NetStatus.Unknow;
    }

    /// <summary>
    /// ն
    /// </summary>
    public class ReceiveObject
    {
        /// <summary>
        /// 
        /// </summary>
        public Socket Client;

        /// <summary>
        /// 
        /// </summary>
        public byte[] Buffer;
    }
}
