using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.CSharp;
using System.CodeDom.Compiler;
using System.Reflection;

using Newtonsoft.Json;
using EasyMR.Net;
using EasyMR.Base;
using EasyMR.Common;
using EasyMR.Common.Data;

namespace EasyMR.Cell
{
    public class Cell
    {
        #region 

        /// <summary>
        /// ͨ
        /// </summary>
        private NetService Net;

        /// <summary>
        /// ˿
        /// </summary>
        private int Port = 3000;

        /// <summary>
        /// 
        /// </summary>
        public Config CellConfig = new Config();

        /// <summary>
        /// űбɡ
        /// </summary>
        public Dictionary<string, Assembly> JobScripts = new Dictionary<string, Assembly>();

        #endregion

        #region 

        public Cell()
            : this(3000, 20, 95)
        {

        }


        public Cell(int port, int intavl, int CPU)
        {
            this.Port = port;

            //Ĭֵ
            this.CellConfig.Intavl = intavl;
            this.CellConfig.CPU = CPU;

            //ͨ
            this.Net = new NetService(this.Port);

            this.Net.Start();

            this.Net.StatusChangedEventHandler += new SocketServerStatusChangedEventHandler(Net_StatusChangedEventHandler);

            this.Net.DataArrivedEventHandler += new NetDataArrivedEventHandler(Net_DataArrivedEventHandler);
        }

        #endregion

        #region ¼

        /// <summary>
        /// ݵ¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="packet"></param>
        private void Net_DataArrivedEventHandler(object sender, RtpFrame packet)
        {
            try
            {
                //
                byte[] buffer = packet.Data.Buffer;

                string data;
                string command;
                //
                if (!Protocal.ParseProtocal(buffer, out command, out data))
                {

                    return;
                }

                //ִ
                switch (command)
                {
                    //ͬű
                    case Protocal.CMD_SynScript:
                        SynScript(data);
                        break;
                    //ִ
                    case Protocal.CMD_Run:
                        Run(data);
                        break;
                }
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// ״̬¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="data"></param>
        private void Net_StatusChangedEventHandler(object sender, SocketServerStatusChangedClass data)
        {

        }


        #endregion

        #region 

        /// <summary>
        /// ͬű
        /// </summary>
        private void SynScript(string data)
        {
            //
            DSynScript dData = JsonConvert.DeserializeObject<DSynScript>(data);

            //̬
            // 1.CSharpCodePrivoder
            CSharpCodeProvider objCSharpCodePrivoder = new CSharpCodeProvider();

            // 2.ICodeComplier
            ICodeCompiler objICodeCompiler = objCSharpCodePrivoder.CreateCompiler();

            // 3.CompilerParameters
            CompilerParameters objCompilerParameters = new CompilerParameters();

            //ĬϻDLL
            objCompilerParameters.ReferencedAssemblies.Add("System.dll");
            objCompilerParameters.ReferencedAssemblies.Add("System.Data.dll");
            objCompilerParameters.ReferencedAssemblies.Add("System.Xml.dll");
            objCompilerParameters.ReferencedAssemblies.Add("EasyMR.Base.dll");

            foreach (string dll in dData.DLLs)
            {
                objCompilerParameters.ReferencedAssemblies.Add(dll);
            }

            objCompilerParameters.GenerateExecutable = false;
            objCompilerParameters.GenerateInMemory = true;

            // 4.CompilerResults
            CompilerResults cr = objICodeCompiler.CompileAssemblyFromSource(objCompilerParameters, dData.ScriptCode);

            bool isOK = true;
            string strError = "";

            if (cr.Errors.Count > 0)
            {
                isOK = false;

                foreach (CompilerError ce in cr.Errors)
                {
                    strError += ce.ToString() + "\n";
                }
            }
            else
            {
                Assembly objAssembly = cr.CompiledAssembly;

                //Ķв
                if (JobScripts.ContainsKey(dData.TaskAssemblyName))
                {
                    JobScripts.Remove(dData.TaskAssemblyName);
                }
                JobScripts.Add(dData.TaskAssemblyName, objAssembly);

            }

            //سɹ
            DSynScriptRet dRet = new DSynScriptRet();
            dRet.OK = isOK;
            dRet.ErrorInfo = strError;
            string ret = JsonConvert.SerializeObject(dRet);

            ret = Protocal.CMD_SynScriptOK + ret;

            //
            byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(ret);

            this.Net.SendData(bData);

        }

        /// <summary>
        /// ִ
        /// </summary>
        /// <param name="data"></param>
        private void Run(string data)
        {
            //
            DRun dData = JsonConvert.DeserializeObject<DRun>(data);

            Job job = new Job(this.CellConfig);

            job.JobID = dData.JobID;

            //ȡб
            Queue<Key> keys = new Queue<Key>();

            foreach (string strkey in dData.Keys)
            {
                Key key = new Key();
                key.KeyVal = strkey;

                keys.Enqueue(key);
            }

            //ɲ
            object[] args = new object[] { keys };

            //ȡִнű,ʵű
            Assembly ass = JobScripts[dData.TaskAssemblyName];

            object oTask = ass.CreateInstance(dData.TaskAssemblyName, true, BindingFlags.Default, null, args, System.Globalization.CultureInfo.CurrentCulture, null);

            TaskBase task = (TaskBase)oTask;

            //ֵ
            job.Task = task;

            //¼
            job.JobStatusChangedEvent += new JobStatusEventHandler(job_JobStatusChangedEvent);
            job.JobRunErrorEvent += new JobRunErrorEventHandler(job_JobRunErrorEvent);
            //ִ
            job.Run();

        }

        /// <summary>
        /// ִг¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="key"></param>
        /// <param name="info"></param>
        void job_JobRunErrorEvent(object sender, string key, string info)
        {
            //سɹ
            DRunErrorRet dRet = new DRunErrorRet();
            dRet.Info = info;
            dRet.Key = key;
            dRet.JobID = ((Job)sender).JobID;

            string ret = JsonConvert.SerializeObject(dRet);

            ret = Protocal.CMD_RunError + ret;

            //
            byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(ret);

            this.Net.SendData(bData);
        }

        /// <summary>
        /// й̻ش
        /// </summary>
        /// <param name="data"></param>
        /// <param name="job"></param>
        private void job_JobStatusChangedEvent(JobStatusObject data, Job job)
        {
            //سɹ
            DRunRet dRet = new DRunRet();

            dRet.Status = (int)data.Status;
            dRet.JobID = job.JobID;

            string ret = JsonConvert.SerializeObject(dRet);

            ret = Protocal.CMD_RunRet + ret;

            //
            byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(ret);

            this.Net.SendData(bData);
        }


        #endregion

    }

}
