using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using System.IO;
using System.Xml;

using EasyMR.Net;
using EasyMR.Base;

namespace EasyMR.Cell
{


    /// <summary>
    /// ״̬¼
    /// </summary>
    public delegate void SocketServerStatusChangedEventHandler(object sender, SocketServerStatusChangedClass data);

    /// <summary>
    /// ¼
    /// </summary>
    public delegate void SocketServerNewConnectionEventHandler(object sender, SocketServerNewConnectionClass data);


    /// <summary>
    /// ¼
    /// </summary>
    public delegate void NetDataArrivedEventHandler(object sender, RtpFrame packet);

    /// <summary>
    /// 
    /// </summary>
    public class NetService
    {
        #region /

        /// <summary>
        /// 
        /// </summary>
        private TcpListener SocketListener;

        /// <summary>
        /// ƽ̨
        /// </summary>
        private Socket SocketMgr;

        /// <summary>
        /// 
        /// </summary>
        static ManualResetEvent TcpClientConnected = new ManualResetEvent(false);

        /// <summary>
        /// 
        /// </summary>
        public const int LengthPenndingQuere = 10;

        /// <summary>
        /// ֡-
        /// </summary>
        private RtpFrame FrameSend;

        /// <summary>
        /// ʱ
        /// </summary>
        private uint TSIncrement = 1;

        /// <summary>
        /// ʱ
        /// </summary>
        private uint TS = 0;

        /// <summary>
        /// ʶ
        /// </summary>
        private uint SSRC;

        private SocketServerStatus _status = SocketServerStatus.Unknow;

        /// <summary>
        /// ݴ߳
        /// </summary>
        private Thread thProcessData;

        /// <summary>
        /// ݻ
        /// </summary>
        private Queue ReceivedPackets = Queue.Synchronized(new Queue());

        /// <summary>
        /// Signals the Distribution thread it has work to do
        /// </summary>
        private AutoResetEvent NewPacket = new AutoResetEvent(false);

        /// <summary>
        /// ݻ
        /// </summary>
        private Queue ReceivedSavePackets = Queue.Synchronized(new Queue());

        /// <summary>
        /// ݳ
        /// </summary>
        private Stack BufferPool = Stack.Synchronized(new Stack(64));

        /// <summary>
        /// ֡-
        /// </summary>
        private Dictionary<uint, RtpFrame> FrameReceivePool;

        /// <summary>
        /// ״̬
        /// </summary>
        public SocketServerStatus Status
        {
            get
            {
                return _status;
            }
            set
            {
                //״ֵ̬ûиı䣬
                if (_status == value)
                {
                    return;
                }

                this.OnStatusChanged(this, new SocketServerStatusChangedClass(_status, value));

                _status = value;
            }
        }


        /// <summary>
        /// ͻб
        /// </summary>
        private ArrayList Clients = new ArrayList();

        #endregion

        #region ¼
        /// <summary>
        /// ״̬ı¼
        /// </summary>
        public event SocketServerStatusChangedEventHandler StatusChangedEventHandler;

        protected virtual void OnStatusChanged(object sender, SocketServerStatusChangedClass obj)
        {
            if (StatusChangedEventHandler != null)
                StatusChangedEventHandler(sender, obj);
        }


        /// <summary>
        /// ݵ¼
        /// </summary>
        public event NetDataArrivedEventHandler DataArrivedEventHandler;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="taskName"></param>
        /// <param name="index"></param>
        protected virtual void OnDataArrived(object sender, RtpFrame packet)
        {
            if (DataArrivedEventHandler != null)
                DataArrivedEventHandler(sender, packet);
        }

        #endregion

        #region 캯

        /// <summary>
        /// ʼ
        /// </summary>
        /// <param name="listenIP"></param>
        public NetService(int port)
        {
            //IP 
            SocketListener = new TcpListener(IPAddress.Any, port);

            //ʼ֡
            this.FrameSend = new RtpFrame(Rtp.MAX_PACKET_SIZE, PayloadType.MyForum, TS);

            this.FrameReceivePool = new Dictionary<uint, RtpFrame>();

        }

        #endregion

        #region 

        /// <summary>
        /// ʼ
        /// </summary>
        public void Start()
        {
            //ʼ
            SocketListener.Start();

            //
            SocketListener.BeginAcceptTcpClient(new AsyncCallback(EndAccept), null);

            //״̬
            this.Status = SocketServerStatus.Running;

            //ʼ߳
            thProcessData = new Thread(new ThreadStart(BatchProcessData));

            thProcessData.IsBackground = true;
            thProcessData.Start();
        }


        /// <summary>
        /// ֹͣ
        /// </summary>
        public void Stop()
        {
            //ر
            this.SocketListener.Stop();

            //
            GC.Collect();
            GC.WaitForPendingFinalizers();

            //װ
            this.Status = SocketServerStatus.Stoped;

        }

        #endregion

        #region ݴ

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ar"></param>
        private void EndAccept(IAsyncResult ar)
        {
            try
            {
                //ӵSocket
                TcpClient tcpClient = this.SocketListener.EndAcceptTcpClient(ar);

                //ٿʼһ첽
                this.SocketListener.BeginAcceptTcpClient(new AsyncCallback(EndAccept), null);

                //ʼ
                SetupRecieveCallback(tcpClient.Client);
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="data"></param>
        public void TranceData(Socket client, byte[] data)
        {
            //Ͽӣͷ
            if (client == null || !client.Connected)
            {
                return;
            }

            //
            AsyncCallback sendData = new AsyncCallback(AsyncSendData);
            client.BeginSend(data, 0, data.Length, SocketFlags.None, sendData, null);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="data"></param>
        public void SendData(byte[] data)
        {
            Socket client = this.SocketMgr;

            //Ͽӣͷ
            if (client == null || !client.Connected)
            {
                return;
            }
            //̲߳
            lock (this.FrameSend)
            {
                //ʼ֡
                this.FrameSend = new RtpFrame(Rtp.MAX_PACKET_SIZE, PayloadType.MyForum, TS);

                //ӵ֡
                unchecked { TS += TSIncrement; }
                this.FrameSend.TimeStamp = TS;
                this.FrameSend.Data = (BufferChunk)data;

                //µSSRC
                SSRC = ID.GetUInt;
                this.FrameSend.Ssrc = SSRC;

                //ʼ첽
                for (ushort iIndex = 0; iIndex < this.FrameSend.PacketCount; iIndex++)
                {
                    this.FrameSend[iIndex].PacketTransLength =
                      (uint)this.FrameSend[iIndex].Buffer.Length;

                    byte[] buffer = (byte[])this.FrameSend[iIndex].Buffer;

                    AsyncCallback sendData = new AsyncCallback(AsyncSendData);
                    client.BeginSend(buffer, 0, buffer.Length, SocketFlags.None, sendData, null);
                }
            }
        }

        /// <summary>
        /// ݵ
        /// </summary>
        public void SetupRecieveCallback(Socket client)
        {
            try
            {
                //
                ReceiveObject o = new ReceiveObject();
                o.Buffer = new byte[Rtp.MAX_PACKET_SIZE];
                o.Client = client;


                //ٴοʼ
                AsyncCallback recieveData = new AsyncCallback(AsyncRecievedData);

                o.Client.BeginReceive(o.Buffer, 0, o.Buffer.Length,
                     SocketFlags.None, recieveData, o);
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// 첽յ
        /// </summary>
        /// <param name="ar"></param>
        private void AsyncRecievedData(IAsyncResult ar)
        {
            try
            {
                //ȡݰ
                int iReadCount = 0;

                //ȡ
                ReceiveObject o = (ReceiveObject)ar.AsyncState;

                try
                {
                    //Ͽӣͷ
                    if (o == null || !o.Client.Connected)
                    {
                        return;
                    }
                    iReadCount = o.Client.EndReceive(ar);

                }
                catch { }

                //ݳΪ0ͱѾϿ
                if (iReadCount < 1)
                {
                    //
                    o.Client.Close();
                    o = null;

                    return;
                }

                //ȡ
                byte[] bufferData = new byte[iReadCount];

                Array.Copy(o.Buffer, 0, bufferData, 0, iReadCount);

                //ѹݶջ
                object[] ao = new object[] { bufferData, o.Client };

                ReceivedPackets.Enqueue(ao);
                NewPacket.Set();

                //½
                Array.Clear(o.Buffer, 0, o.Buffer.Length);
                SetupRecieveCallback(o.Client);

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }



        /// <summary>
        /// 첽
        /// </summary>
        /// <param name="ar"></param>
        private void AsyncSendData(IAsyncResult ar)
        {

        }

        //int i = 0;
        //bool ok = false;
        /// <summary>
        /// 
        /// </summary>
        private void BatchProcessData()
        {
            while (NewPacket.WaitOne())
            {
                while (ReceivedPackets.Count > 0)
                {
                    try
                    {
                        object[] ao = (object[])ReceivedPackets.Dequeue();

                        byte[] bufferData = (byte[])ao[0];
                        Socket client = (Socket)ao[1];

                        if (BufferPool.Count > 0)
                        {
                            while (BufferPool.Count > 0)
                            {
                                byte[] temp1Chunk = (byte[])BufferPool.Pop();
                                byte[] temp2Chunk = bufferData;

                                bufferData = new byte[temp1Chunk.Length + temp2Chunk.Length];
                                Array.Copy(temp1Chunk, 0, bufferData, 0, temp1Chunk.Length);
                                Array.Copy(temp2Chunk, 0, bufferData, temp1Chunk.Length, temp2Chunk.Length);
                            }
                        }

                        RtpPacket packet = new RtpPacket((BufferChunk)bufferData);

                        //ְ
                        if (packet.PacketTransLength > packet.Buffer.Length)
                        {
                            BufferPool.Push(bufferData);
                            continue;
                        }

                        //ճ
                        if (packet.PacketTransLength < packet.Buffer.Length)
                        {

                            //
                            byte[] temp1Chunk = (byte[])packet.Buffer.Peek((int)packet.PacketTransLength,
                                packet.Buffer.Length - (int)packet.PacketTransLength);

                            BufferPool.Push(temp1Chunk);

                            //ݴ
                            byte[] temp2Chunk = (byte[])packet.Buffer.Peek(0,
                                (int)packet.PacketTransLength);

                            packet = new RtpPacket((BufferChunk)temp2Chunk);
                        }

                        RtpFrame frame = GetFrame(packet.SSRC);

                        //
                        if (null == frame)
                        {
                            frame = new RtpFrame(packet.PacketsInFrame, packet.TimeStamp);
                            frame[packet.FrameIndex] = packet;
                            FrameReceivePool.Add(packet.SSRC, frame);
                        }
                        else
                        {
                            frame[packet.FrameIndex] = packet;
                        }

                        if (frame.Complete)
                        {
                            ////
                            //this.ProcessData(client, packet);

                            //¼̨Socket
                            SocketMgr = client;

                            //ݵ¼
                            this.OnDataArrived(this, frame);

                            //Ƴ
                            FrameReceivePool.Remove(packet.SSRC);
                        }
                    }
                    catch (Exception ex)
                    {
                        SysLog.WriteLog(ex);
                    }
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="SSRC"></param>
        private RtpFrame GetFrame(uint SSRC)
        {

            RtpFrame frame = null;
            if (FrameReceivePool.ContainsKey(SSRC))
            {
                frame = FrameReceivePool[SSRC];
            }

            return frame;

        }
        #endregion

        #region ҵ񷽷

        /// <summary>
        /// 
        /// </summary>
        private void ProcessData(Socket client, RtpPacket packet)
        {
            try
            {
                //ҵ

                ////Ƿַ
                //RegClient(packet.SourceID, client);

                ////ĿĵַΪ0ֻע
                //if (packet.ReceiverID == 0)
                //{
                //    return;
                //}

                //bool isOnline = true;
                ////ǷĿĵַ
                //if (RoutRecords.ContainsKey(packet.ReceiverID))
                //{
                //    Socket receiveClient = RoutRecords[packet.ReceiverID].Client;

                //    //ĿĵַӹرվƳ
                //    if (receiveClient == null || !receiveClient.Connected)
                //    {
                //        UnRegClient(packet.ReceiverID, null);
                //        return;
                //    }

                //    if (receiveClient == null || !receiveClient.Connected)
                //    {
                //        //ע·ɼ¼
                //        UnRegClient(0, receiveClient);

                //        //
                //        receiveClient.Close();
                //        receiveClient.Dispose();

                //        //Ŀַ
                //        isOnline = false;
                //    }
                //    else
                //    {
                //        //ڲԷͣת
                //        TranceData(receiveClient, (byte[])packet.Buffer);
                //    }
                //}
                //else
                //{
                //    //Ŀַ
                //    isOnline = false;
                //}

                ////ھͷһ
                //if (!isOnline)
                //{
                //    //ͷ
                //    string strCommand = AllFreeProtocal.OnlineStatusResult + "0";

                //    //
                //    byte[] bData = UnicodeEncoding.BigEndianUnicode.GetBytes(strCommand);

                //    //ڲԷͣת
                //    SendData(client, bData);
                //}
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }


        #endregion


    }

    /// <summary>
    /// ״̬
    /// </summary>
    public enum SocketServerStatus
    {
        //ȱʡ
        Unknow = 0,
        //
        Running = 1,
        //ֹͣ
        Stoped = 2,
    }

    /// <summary>
    /// 
    /// </summary>
    public class SocketServerStatusChangedClass
    {
        public SocketServerStatusChangedClass(SocketServerStatus lastStatus,
            SocketServerStatus currentStatus)
        {
            this.LastStatus = lastStatus;
            this.CurrentStatus = currentStatus;
        }

        /// <summary>
        /// һ״̬
        /// </summary>
        public SocketServerStatus LastStatus = SocketServerStatus.Unknow;

        /// <summary>
        /// ״̬
        /// </summary>
        public SocketServerStatus CurrentStatus = SocketServerStatus.Unknow;
    }

    /// <summary>
    /// 
    /// </summary>
    public class SocketServerNewConnectionClass
    {
        public SocketServerNewConnectionClass(Socket socket)
        {
            this.ClientSocket = socket;
        }

        /// <summary>
        /// ͻSocket
        /// </summary>
        public Socket ClientSocket;
    }

    /// <summary>
    /// ն
    /// </summary>
    public class ReceiveObject
    {
        /// <summary>
        /// 
        /// </summary>
        public Socket Client;

        /// <summary>
        /// 
        /// </summary>
        public byte[] Buffer;
    }
}
