using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using EasyMR.Base;
using EasyMR.Common;
using EasyMR.Net;
using EasyMR.Mgr.Base;
using EasyMR.Common.Data;
using Newtonsoft.Json;

namespace EasyMR.Mgr
{
    public partial class FrmMain : Form
    {
        #region  

        /// <summary>
        /// ƽ̨
        /// </summary>
        private CellMgr cellMgr = new CellMgr();

        /// <summary>
        /// ʼʱʱ
        /// </summary>
        private DateTime dtStart;

        /// <summary>
        /// Keyб
        /// </summary>
        private string[] Keys;

        /// <summary>
        /// нű
        /// </summary>
        private Script runScript = new Script();

        #endregion

        #region 캯

        public FrmMain()
        {
            InitializeComponent();
        }

        #endregion

        #region ¼

        private void FrmMain_Load(object sender, EventArgs e)
        {
            try
            {
                //رն̼߳
                Control.CheckForIllegalCrossThreadCalls = false;

                //CellMgr¼
                this.cellMgr.StatusChangedEventHandler += new NetStatusChangedEventHandler(cellMgr_StatusChangedEventHandler);

                this.cellMgr.DataArrivedEventHandler += new DataArrivedEventHandler(cellMgr_DataArrivedEventHandler);

                //־¼
                SysLog.LogedEvent += new LogedEventHandler(SysLog_LogedEvent);
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }

        }



        private void btnConnectToCell_Click(object sender, EventArgs e)
        {
            try
            {
                //
                this.cellMgr.BeginConnectToCell(this.txtIP.Text, int.Parse(this.txtPort.Text));

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void cellMgr_DataArrivedEventHandler(object sender, string command, object data)
        {
            try
            {
                //ݷ״̬д
                switch (command)
                {
                    //ͬűɹ
                    case Protocal.CMD_SynScriptOK:
                        SynScriptRet(sender, command, data);
                        break;
                    //ִ״̬ı
                    case Protocal.CMD_RunRet:
                        RunScriptRet(command, data);
                        break;

                    //ִ״̬ı
                    case Protocal.CMD_RunError:
                        RunScriptError(command, data);
                        break;
                }
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void cellMgr_StatusChangedEventHandler(object sender, NetStatusChangedClass status)
        {
            try
            {
                //ӳɹ
                if (status.CurrentStatus == NetStatus.Connected)
                {
                    ShowInfo("IPַ" + ((ClientService)sender).IP + " ӳɹ");

                    //ӵб
                    this.lstCellList.Items.Add(((ClientService)sender).IP + ":" + ((ClientService)sender).Port);
                }
                //ʧ
                if (status.CurrentStatus == NetStatus.Disconnected)
                {
                    ShowInfo("IPַ" + ((ClientService)sender).IP + " ʧܣ");
                }

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void btnSendScript_Click(object sender, EventArgs e)
        {
            try
            {
                //ÿIPͽű
                foreach (object oIP in this.lstCellList.Items)
                {
                    //
                    string ip = (string)oIP;
                    ip = ip.Substring(0, ip.IndexOf(':'));

                    this.cellMgr.SendScript(ip, this.runScript);
                }
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void btnStartRun_Click(object sender, EventArgs e)
        {
            try
            {
                //ִнű
                this.RunScript();

                //ʼʱ
                this.dtStart = DateTime.Now;
                this.timSpan.Enabled = true;
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void btnTestCode_Click(object sender, EventArgs e)
        {
            try
            {
                //Queue<Key> keys = new Queue<Key>();
                //Key key = new Key();
                //key.KeyVal = "A0574";
                //keys.Enqueue(key);
                //TestCase.BizRDay bizR = new TestCase.BizRDay(keys);
                //bizR.Process("3101998");
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void timSpan_Tick(object sender, EventArgs e)
        {
            try
            {
                lock (this.txtSpanTime)
                {
                    TimeSpan span = DateTime.Now.Subtract(this.dtStart);
                    this.txtSpanTime.Text = span.Seconds.ToString();
                }

            }
            catch
            {

            }
        }

        /// <summary>
        /// ༭ű
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEditScript_Click(object sender, EventArgs e)
        {
            try
            {
                //򿪴
                using (FrmScript frm = new FrmScript(this.runScript))
                {
                    if (frm.ShowDialog(this) == DialogResult.OK)
                    {

                        this.runScript = frm.runScript;
                    }
                }

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// ༭Keys
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEditKeys_Click(object sender, EventArgs e)
        {
            try
            {
                //򿪴
                using (FrmKeys frm = new FrmKeys(this.Keys))
                {
                    if (frm.ShowDialog(this) == DialogResult.OK)
                    {
                        this.Keys = frm.Keys;
                    }
                }

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }


        /// <summary>
        /// ־
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnClearLog_Click(object sender, EventArgs e)
        {
            try
            {
                lock (this.txtLogInfo)
                {
                    this.txtLogInfo.Clear();
                }

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="data"></param>
        private void SysLog_LogedEvent(LogedData data)
        {
            try
            {
                //ʾ쳣
                this.ShowInfo(data.Message);
            }
            catch {
            }
        }

        #endregion

        #region 

        /// <summary>
        /// ִнű
        /// </summary>
        private void RunScript()
        {
            if (this.Keys == null || this.Keys.Length == 0)
            {
                this.ShowInfo("KeysбΪգ");

                return;
            }

            //ƽ
            List<string>[] jobKeys = new List<string>[this.lstCellList.Items.Count];

            //ʼ
            for (int i = 0; i < jobKeys.Length; i++)
            {
                jobKeys[i] = new List<string>();
            }

            //
            for (int i = 0; i < this.Keys.Length; i++)
            {
                jobKeys[i % jobKeys.Length].Add(this.Keys[i]);
            }

            //
            for (int i = 0; i < jobKeys.Length; i++)
            {
                object oIP = this.lstCellList.Items[i];
                string ip = (string)oIP;
                ip = ip.Substring(0, ip.IndexOf(':'));

                this.cellMgr.RunScript(ip, i.ToString(), jobKeys[i].ToArray(), this.runScript.TaskAssemblyName);
            }
        }
        /// <summary>
        /// ͬű
        /// </summary>
        /// <param name="command"></param>
        /// <param name="dataValue"></param>
        private void SynScriptRet(object sender, string command, object data)
        {
            //
            DSynScriptRet dData = JsonConvert.DeserializeObject<DSynScriptRet>((string)data);

            if (dData.OK)
            {
                this.ShowInfo("IP" + ((ClientService)sender).IP + "ͬɹ");
            }
            else
            {
                this.ShowInfo("IP" + ((ClientService)sender).IP + "ͬʧܣ");
            }
        }

        /// <summary>
        /// ִнű
        /// </summary>
        /// <param name="command"></param>
        /// <param name="dataValue"></param>
        private void RunScriptRet(string command, object data)
        {
            //
            DRunRet dData = JsonConvert.DeserializeObject<DRunRet>((string)data);

            if (dData.Status == (int)JobStatus.Stare)
            {
                this.ShowInfo("" + dData.JobID + " ʼִУ");

                return;
            }
            if (dData.Status == (int)JobStatus.Finished)
            {
                this.ShowInfo("" + dData.JobID + " ִɣ");
            }
            if (dData.Status == (int)JobStatus.ExpFinished)
            {
                this.ShowInfo("" + dData.JobID + " ִʧܣ");
            }

            //ֹͣʱ
            this.timSpan.Enabled = false;
        }

        /// <summary>
        /// ִнű
        /// </summary>
        /// <param name="command"></param>
        /// <param name="dataValue"></param>
        private void RunScriptError(string command, object data)
        {
            //
            DRunErrorRet dData = JsonConvert.DeserializeObject<DRunErrorRet>((string)data);

            this.ShowInfo("" + dData.JobID + " ִгKEY:" + dData.Key + " info: " + dData.Info);

            lock (this.txtLogInfo)
            {
                this.txtLogInfo.Text += dData.Key + "\n";
            }
        }


        /// <summary>
        /// ʾϢ
        /// </summary>
        /// <param name="info"></param>
        private void ShowInfo(string info)
        {
            lock (this.txtLogInfo)
            {
                this.txtLogInfo.Text += info + "\n";
            }
        }

        #endregion

      








    }
}