using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using EasyMR.Mgr.Base;
using EasyMR.Base;

namespace EasyMR.Mgr
{
    public partial class FrmScript : Form
    {


        #region  

        /// <summary>
        /// нű
        /// </summary>
        public Script runScript = new Script();

        #endregion

        #region ¼

        public FrmScript(Script script)
        {
            InitializeComponent();

            //ֵ
            this.runScript = script;
        }

        private void FrmScript_Load(object sender, EventArgs e)
        {
            try
            {
                //ֵ
                if (this.runScript != null)
                {
                    if (this.runScript.ScriptCode != null && this.runScript.ScriptCode != "")
                    {
                        this.txtScriptCode.Text = this.runScript.ScriptCode;
                    }

                    if (this.runScript.TaskAssemblyName != null && this.runScript.ScriptCode != "")
                    {
                        this.txtTaskAssemblyName.Text = this.runScript.TaskAssemblyName;
                    }

                    if (this.runScript.DLLs != null && this.runScript.DLLs.Length > 0)
                    {
                        foreach (string strDll in this.runScript.DLLs)
                        {
                            this.txtDlls.Text += strDll + "\n";
                        }
                    }

                }
            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        private void btnSaveScript_Click(object sender, EventArgs e)
        {
            try
            {
                //ɽű
                this.runScript.DLLs = this.txtDlls.Text.Split(new char[] { '\n' }, StringSplitOptions.RemoveEmptyEntries);
                this.runScript.ScriptCode = this.txtScriptCode.Text;
                this.runScript.TaskAssemblyName = this.txtTaskAssemblyName.Text;

                //
                this.DialogResult = DialogResult.OK;

            }
            catch (Exception ex)
            {
                SysLog.WriteLog(ex);
            }
        }

        #endregion


    }
}