﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
//Author  : Syed Shanu
//Date    : 2014-08-01
//Description : Shanu Pareto Chart

namespace SHANUParetoChart_DEMO
{
    public partial class frmShanuPaerto : Form
    {
        DataTable dt = new DataTable();
        private static readonly Random random = new Random();
        int gridMinvalue = 1;
        int gridMaxvalue = 56;


        public frmShanuPaerto()
        {
            InitializeComponent();
            loadGridColums();
            loadgrid(1);
        }
        public void loadGridColums()
        {
            dt.Columns.Add("No");

            dt.Columns.Add("Names");
            dt.Columns.Add("Frequency");
            dt.Columns["Frequency"].DataType = Type.GetType("System.Int32");
        }


        private static int RandomNumberBetween(int minValue, int maxValue)
        {
            int next = random.Next(minValue, maxValue);

            return next;
        }
        public void loadgrid(int loadtype)
        {
            dt.Clear();
            dt.Rows.Clear();

            if (loadtype == 1)
            {
                DataRow row = dt.NewRow();
                row["No"] = "1";
                row["Names"] = "Pareto1";
                row["Frequency"] = 53;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "2";
                row["Names"] = "Pareto2";
                row["Frequency"] = 45;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "3";
                row["Names"] = "Pareto3";
                row["Frequency"] = 43;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "4";
                row["Names"] = "Pareto4";
                row["Frequency"] = 37;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "5";
                row["Names"] = "Pareto5";
                row["Frequency"] = 35;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "6";
                row["Names"] = "Pareto6";
                row["Frequency"] = 27;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "7";
                row["Names"] = "Pareto7";
                row["Frequency"] = 23;
                dt.Rows.Add(row);

                row = dt.NewRow();
                row["No"] = "8";
                row["Names"] = "Pareto8";
                row["Frequency"] = 12;
                dt.Rows.Add(row);


            }
            else
            {

                for (int i = 1; i <= numericUpDown1.Value; i++)
                {
                    DataRow row = dt.NewRow();
                    row["No"] = i.ToString();
                    row["Names"] = "Pareto" + i.ToString();
                    row["Frequency"] = RandomNumberBetween(gridMinvalue, gridMaxvalue);
                    dt.Rows.Add(row);
                }
            }

            dt.DefaultView.Sort = "Frequency DESC";
            dt = dt.DefaultView.ToTable();

            dataGridView1.AutoResizeColumns();
            dataGridView1.DataSource = dt;
            // dataGridView1.DataBindings();
            dataGridView1.AutoResizeColumns();
        }

        private void frmShanuPaerto_Load(object sender, EventArgs e)
        {
            loadgrid(1);
            shanuParetoChart.Bindgrid(dt);   
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (button1.Text == "Real Time Data ON")
            {
                timer1.Enabled = true;
                timer1.Start();
                button1.Text = "Real Time Data Off";
            }
            else
            {
                timer1.Enabled = false;
                timer1.Stop();
                button1.Text = "Real Time Data ON";
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            loadgrid(2);
            shanuParetoChart.Bindgrid(dt);   
        }
    }
}
