﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;

using System.Globalization;
using System.Drawing.Drawing2D;

using System.Windows.Forms;
//Author  : Syed Shanu
//Date    : 2014-08-01
//Description : Shanu Pareto Chart

namespace ShanuParetoChart_CTL
{
    public partial class ShanuParetoChart : UserControl
    {
        #region Members
        private System.Windows.Forms.PictureBox PicBox;
        private System.Windows.Forms.Panel OuterPanel;
        private System.ComponentModel.Container components = null;
        private string m_sPicName = "";
        ContextMenuStrip docmenu = new System.Windows.Forms.ContextMenuStrip();
        ToolStripMenuItem saveimg = new ToolStripMenuItem();

        int NoofPlots = 5;

        public DataTable dt = new DataTable();

        Font f12 = new Font("arial", 12, FontStyle.Bold, GraphicsUnit.Pixel);
        Pen B1pen = new Pen(Color.Black, 1);
        Pen B2pen = new Pen(Color.Black, 2);
        Double XDoublkeBAR = 0;
        Double RBAR = 0;
        Double XBARUCL = 0;
        Double XBARLCL = 0;

        Double RANGEUCL = 0;
        Double RANGELCL = 0;
        Double[] intMeanArrayVals;
        Double[] intRangeArrayVals;
        Double[] intSTDEVArrayVals;
        Double[] intXBARArrayVals;

       int[] intDataValue;
        int[] intCumulativeValue;
        Double[] intCumulativeValuePer;
        Double[] XaxisplotWidth;

        int First_chartDatarectHeight = 400;
        int First_chartDatarectWidth = 600;
        Font f10 = new Font("arial", 10, FontStyle.Bold, GraphicsUnit.Pixel);
        LinearGradientBrush a2 = new LinearGradientBrush(new RectangleF(0, 0, 100, 19), Color.DarkGreen, Color.Green, LinearGradientMode.Horizontal);
        LinearGradientBrush a3 = new LinearGradientBrush(new RectangleF(0, 0, 100, 19), Color.DarkRed, Color.Red, LinearGradientMode.Horizontal);
        LinearGradientBrush a1 = new LinearGradientBrush(new RectangleF(0, 0, 100, 19), Color.Blue, Color.DarkBlue, LinearGradientMode.Horizontal);

        #endregion

        #region Constants

        private double ZOOMFACTOR = 1.25;	// = 25% smaller or larger
        private int MINMAX = 2;				// 5 times bigger or smaller than the ctrl

        #endregion

         #region Designer generated code

        private void InitializeComponent()
        {
            this.PicBox = new System.Windows.Forms.PictureBox();
            this.OuterPanel = new System.Windows.Forms.Panel();
            ((System.ComponentModel.ISupportInitialize)(this.PicBox)).BeginInit();
            this.OuterPanel.SuspendLayout();
            this.SuspendLayout();
            // 
            // PicBox
            // 
            this.PicBox.BackColor = System.Drawing.Color.White;
            this.PicBox.Dock = System.Windows.Forms.DockStyle.Fill;
            this.PicBox.Location = new System.Drawing.Point(0, 0);
            this.PicBox.Name = "PicBox";
            this.PicBox.Size = new System.Drawing.Size(818, 518);
            this.PicBox.TabIndex = 3;
            this.PicBox.TabStop = false;
            // 
            // OuterPanel
            // 
            this.OuterPanel.AutoScroll = true;
            this.OuterPanel.BackColor = System.Drawing.Color.White;
            this.OuterPanel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.OuterPanel.Controls.Add(this.PicBox);
            this.OuterPanel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.OuterPanel.Location = new System.Drawing.Point(0, 0);
            this.OuterPanel.Name = "OuterPanel";
            this.OuterPanel.Size = new System.Drawing.Size(820, 520);
            this.OuterPanel.TabIndex = 4;
            // 
            // ShanuParetoChart
            // 
            this.Controls.Add(this.OuterPanel);
            this.Name = "ShanuParetoChart";
            this.Size = new System.Drawing.Size(820, 520);
            ((System.ComponentModel.ISupportInitialize)(this.PicBox)).EndInit();
            this.OuterPanel.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion
        #region Constructors
        public ShanuParetoChart()
        {
          InitializeComponent();
            InitCtrl();
        }
        #endregion

        #region Properties
        public void Bindgrid(DataTable dtnew)
        {
            if (dtnew != null)
            {
                dt = dtnew;
                PicBox.Refresh();
            }
        }
          #endregion

          #region Other Methods

        /// <summary>
        /// Special settings for the picturebox ctrl
        /// </summary>
        private void InitCtrl()
        {
            PicBox.SizeMode = PictureBoxSizeMode.StretchImage;
            PicBox.Location = new Point(0, 0);
            OuterPanel.Dock = DockStyle.Fill;
            OuterPanel.Cursor = System.Windows.Forms.Cursors.NoMove2D;
            OuterPanel.AutoScroll = true;
            OuterPanel.MouseEnter += new EventHandler(PicBox_MouseEnter);
            PicBox.MouseEnter += new EventHandler(PicBox_MouseEnter);
            OuterPanel.MouseWheel += new MouseEventHandler(PicBox_MouseWheel);
            PicBox.Paint += new PaintEventHandler(PicBox_Paint);
            PicBox.DoubleClick += new EventHandler(PicBox_DoubleClick);

            saveimg.Text = "SaveImage";
            docmenu.Items.AddRange(new ToolStripMenuItem[] { saveimg });

            docmenu.Click += new EventHandler(docmenu_Click);
            PicBox.ContextMenuStrip = docmenu;
        }

        private void PicBox_DoubleClick(object sender, EventArgs e)
        {
            saveImages();
        }

        private void docmenu_Click(object sender, EventArgs e)
        {
            saveImages();
        }

        public void saveImages()
        {
            if (dt.Rows.Count <= 0)
            {
                return;
            }

            using (var bitmap = new Bitmap(PicBox.Width, PicBox.Height))
            {
                PicBox.DrawToBitmap(bitmap, PicBox.ClientRectangle);


                SaveFileDialog dlg = new SaveFileDialog();
                dlg.FileName = "*";
                dlg.DefaultExt = "bmp";
                dlg.ValidateNames = true;

                dlg.Filter = "Bitmap Image (.bmp)|*.bmp|Gif Image (.gif)|*.gif|JPEG Image (.jpeg)|*.jpeg|Png Image (.png)|*.png";
                if (dlg.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {

                    bitmap.Save(dlg.FileName);
                }



            }
        }
           #endregion

          #region Zooming Methods
        /// <summary>
        /// Pictuerbox Paint where we draw.
        /// </summary>
        /// <remarks>Maximum 5 times bigger</remarks>
        /// 
        public void PicBox_Paint(object sender, PaintEventArgs e)
        {            
           


            int opacity = 58; // 50% opaque (0 = invisible, 255 = fully opaque)

            e.Graphics.DrawString("SHANU Pareto CHART",
                new Font("Arial", 28),
                new SolidBrush(Color.FromArgb(opacity, Color.OrangeRed)),
                20,
                 10);
            if (dt.Rows.Count <= 2)
            {
                return;
            }

            int NoofTrials = dt.Rows.Count;
            int NoofParts = dt.Columns.Count - 1;
            NoofPlots = NoofTrials;


            intDataValue = new int[NoofTrials];
            intCumulativeValue = new int[NoofTrials];
            intCumulativeValuePer = new Double[NoofTrials];
            if (dt.Rows.Count <= 2)
            {
                return;
            }
            int idataval = 0;
            dt.DefaultView.Sort = "Frequency DESC";
            dt = dt.DefaultView.ToTable();


            for (int iRow = 0; iRow < dt.Rows.Count; iRow++)
            {
                intDataValue[idataval] = System.Convert.ToInt32(dt.Rows[iRow][2].ToString());
                idataval = idataval + 1;

            }
            int sumofFrequence = intDataValue.Sum();
            intCumulativeValue[0] = intDataValue[0];
            intCumulativeValuePer[0] = Convert.ToDouble(intCumulativeValue[0]) / Convert.ToDouble(sumofFrequence) * 100;
            for (int ival = 1; ival < intDataValue.Length; ival++)
            {

                intCumulativeValue[ival] = intCumulativeValue[ival - 1] + intDataValue[ival];
                intCumulativeValuePer[ival] = Convert.ToDouble(intCumulativeValue[ival]) / Convert.ToDouble(sumofFrequence) * 100;

            }

            drawPareto(e.Graphics, sumofFrequence);

        }

        public void drawPareto(Graphics e, int sumofFrequence)
        {
            try
            {
                First_chartDatarectHeight = PicBox.Height - 20;
                First_chartDatarectWidth = PicBox.Width - 20;


                // 1) For the Chart Data Display ---------
                e.DrawRectangle(Pens.Black, 10, 10, First_chartDatarectWidth, First_chartDatarectHeight);

                int historgramHeigt = First_chartDatarectHeight - 30;
                int historgramWidth = First_chartDatarectWidth - 20;
                int StartXval = 80;
                int startyval = 60;

                // Measurement Horizontal Line
                e.DrawLine(B1pen, StartXval, historgramHeigt, historgramWidth, historgramHeigt);

                //Frequency Vertical line
                e.DrawLine(B1pen, StartXval, startyval, StartXval, historgramHeigt);

                //Cumulative frequency Persentage Ploting
                e.DrawLine(B1pen, historgramWidth, startyval, historgramWidth, historgramHeigt);

                //  NoofPlots =7;
                //Draw Xaxis plots
                int widthcalculation = (historgramWidth) / NoofPlots + 1;
                if (widthcalculation <= StartXval)
                {
                    widthcalculation = StartXval;
                }
                int XvalPosition = widthcalculation;

                widthcalculation = widthcalculation - 18;

                String[] Xaxisplotdata = new String[NoofPlots];

                XaxisplotWidth = new Double[NoofPlots];

                RectangleF rectF1 = new RectangleF(30, 10, 100, 122);

                // End of Xaxis Plot

                Double yValmaxDataVal = intDataValue.Max();
                Double yValminDataVal = intDataValue.Min();
                Double yValresultMaxMin = yValmaxDataVal - yValminDataVal;

                //for ploting the xval data
                Double yValMeasurementYAxisValue = yValmaxDataVal / NoofPlots;
                int yValheightcalculation = historgramHeigt / NoofPlots;
                int yValXvalPosition = yValheightcalculation;

                Double plotYvals = yValmaxDataVal + 4;

                Double[] YaxisplotHight = new Double[NoofPlots];
                Double[] YaxisplotData = new Double[NoofPlots];

                for (int ival = 0; ival < NoofPlots; ival++)
                {
                    //Draw Xaxis plots
                    String MeasurementXAxisValue = dt.Rows[ival][1].ToString();
                    Xaxisplotdata[ival] = MeasurementXAxisValue;
                    e.DrawLine(B1pen, XvalPosition, historgramHeigt, XvalPosition, historgramHeigt + 15);
                    rectF1 = new RectangleF(XvalPosition, historgramHeigt + 6, widthcalculation, 34);
                    e.DrawString(MeasurementXAxisValue.ToString(), f10, a2, rectF1);
                    // e.DrawRectangle(Pens.Black, Rectangle.Round(rectF1));

                    XaxisplotWidth[ival] = XvalPosition;
                    XvalPosition = XvalPosition + widthcalculation;

                    // End of Xaxis Plot

                    // Draw Y axis Plot
                    if (ival == NoofPlots - 1)
                    {
                        e.DrawString("0", f10, a2, StartXval - 12, yValXvalPosition + 4);
                    }
                    else
                    {
                        e.DrawLine(B1pen, StartXval - 10, yValXvalPosition, StartXval, yValXvalPosition);
                        e.DrawString(Math.Round(plotYvals, 0).ToString(), f10, a2, StartXval - 20, yValXvalPosition + 4);
                    }

                    //else
                    //{
                    //    plotYvals = plotYvals - yValMeasurementYAxisValue;
                    //}
                    YaxisplotData[ival] = plotYvals;
                    plotYvals = plotYvals - yValMeasurementYAxisValue;

                    YaxisplotHight[ival] = yValXvalPosition;
                    yValXvalPosition = yValXvalPosition + yValheightcalculation;

                    //End of Yaxis Plot.

                }

                int widthcalculation_new = historgramWidth / NoofPlots;

                int XvalPosition_Start = Convert.ToInt32(XaxisplotWidth[0]);

                int XvalPosition_new = Convert.ToInt32(XaxisplotWidth[1]) - XvalPosition_Start;

                widthcalculation = widthcalculation - 18;

                int Ystartval = 100;
                int YEndval = 100;
                //Fill Rectangle
                LinearGradientBrush a6;// new LinearGradientBrush(new RectangleF(StartXval, Ystartval, widthcalculation_new - StartXval, YEndval), Color.GreenYellow, Color.Green, LinearGradientMode.Vertical);

                Font f2 = new Font("arial", 12, FontStyle.Bold, GraphicsUnit.Pixel);
                for (int ival = 0; ival < YaxisplotData.Length - 1; ival++)
                {
                    for (int yval = 1; yval < YaxisplotData.Length - 1; yval++)
                    {

                        Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intDataValue[ival]) * 6);


                        if (intDataValue[ival] <= YaxisplotData[yval - 1] && intDataValue[ival] > YaxisplotData[yval])
                        {

                            Ystartval = Convert.ToInt32(finaldisplayvalue);
                            YEndval = historgramHeigt - Convert.ToInt32(finaldisplayvalue);
                        }

                        else if (intDataValue[ival] <= YaxisplotData[yval - 1] && intDataValue[ival] < YaxisplotData[yval])
                        {
                            //  Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intDataValue[ival]));

                            Ystartval = Convert.ToInt32(finaldisplayvalue);
                            YEndval = historgramHeigt - Convert.ToInt32(finaldisplayvalue);
                        }
                    }

                    if (YEndval > 2)
                    {
                    }
                    else
                    {
                        Ystartval = historgramHeigt - 2;
                        YEndval = 2;
                    }
                    a6 = new LinearGradientBrush(new RectangleF(StartXval, Ystartval, XvalPosition_new, YEndval), Color.LightBlue, Color.CornflowerBlue, LinearGradientMode.Vertical);

                    XvalPosition_Start = Convert.ToInt32(XaxisplotWidth[ival]);
                    e.DrawRectangle(B1pen, XvalPosition_Start, Ystartval, XvalPosition_new, YEndval);
                    e.FillRectangle(a6, XvalPosition_Start, Ystartval - 1, XvalPosition_new - 1, YEndval - 1);
                    e.DrawString(intDataValue[ival].ToString(), f2, a2, XvalPosition_Start + 10, Ystartval - 20);



                    XvalPosition_new = Convert.ToInt32(XaxisplotWidth[ival + 1]) - XvalPosition_Start;// XvalPosition_Start+XvalPosition_new + widthcalculation_new;


                    if (ival == YaxisplotData.Length - 2)
                    {
                        for (int yval = 1; yval < YaxisplotData.Length - 1; yval++)
                        {
                            if (intDataValue[ival + 1] <= YaxisplotData[yval - 1] && intDataValue[ival] > YaxisplotData[yval])
                            {
                                Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intDataValue[ival + 1]) * 6);

                                Ystartval = Convert.ToInt32(finaldisplayvalue);
                                YEndval = historgramHeigt - Convert.ToInt32(finaldisplayvalue);
                            }
                            else if (intDataValue[ival + 1] <= YaxisplotData[yval - 1] && intDataValue[ival + 1] < YaxisplotData[yval])
                            {
                                Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intDataValue[ival + 1]) * 6);

                                Ystartval = Convert.ToInt32(finaldisplayvalue);
                                YEndval = historgramHeigt - Convert.ToInt32(finaldisplayvalue);
                            }
                        }

                        if (YEndval > 2)
                        {
                        }
                        else
                        {
                            Ystartval = historgramHeigt - 2;
                            YEndval = 2;
                        }


                        XvalPosition_Start = Convert.ToInt32(XaxisplotWidth[ival + 1]);

                        if (XvalPosition_Start + XvalPosition_new > historgramWidth)
                        {
                            XvalPosition_new = XvalPosition_new - (XvalPosition_Start + XvalPosition_new - historgramWidth);
                        }


                        //  a6 = new LinearGradientBrush(new RectangleF(StartXval, Ystartval, XvalPosition_new, YEndval), Color.GreenYellow, Color.Green, LinearGradientMode.Vertical);
                        e.DrawRectangle(B1pen, XvalPosition_Start, Ystartval, XvalPosition_new, YEndval);
                        e.FillRectangle(a6, XvalPosition_Start, Ystartval - 1, XvalPosition_new - 1, YEndval - 1);
                        e.DrawString(intDataValue[ival + 1].ToString(), f2, a2, XvalPosition_Start + 10, Ystartval - 20);
                    }


                }

                //Draw Line Curve on pareto Chart
                drawParetoCurveLine(e);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }
        public void drawParetoCurveLine(Graphics e)
        {

            First_chartDatarectHeight = PicBox.Height - 20;
            First_chartDatarectWidth = PicBox.Width - 20;


            int historgramHeigt = First_chartDatarectHeight - 30;
            int historgramWidth = First_chartDatarectWidth - 20;
            int StartXval = historgramWidth + 12;
            int startyval = 60;

            Double yValmaxDataVal = 100;
            Double yValminDataVal = 0;
            Double yValresultMaxMin = yValmaxDataVal - yValminDataVal;
            int NoofPlots = 5;
            Double yValMeasurementYAxisValue = yValmaxDataVal / NoofPlots;
            int yValheightcalculation = historgramHeigt / NoofPlots;
            int yValXvalPosition = startyval;// yValheightcalculation;

            Double plotYvals = yValmaxDataVal;

            Double[] YaxisplotHight = new Double[NoofPlots];
            Double[] YaxisplotData = new Double[NoofPlots];

            for (int ival = 0; ival <= NoofPlots - 1; ival++)
            {

                if (ival == NoofPlots)
                {
                    e.DrawString("0", f10, a2, StartXval - 12, yValXvalPosition + 4);
                }
                else
                {
                    e.DrawLine(B1pen, StartXval - 10, yValXvalPosition, StartXval, yValXvalPosition);
                    e.DrawString(Math.Round(plotYvals, 0).ToString() + "%", f10, a2, StartXval - 11, yValXvalPosition + 4);
                }

                YaxisplotData[ival] = plotYvals;
                plotYvals = plotYvals - yValMeasurementYAxisValue;

                YaxisplotHight[ival] = yValXvalPosition;
                yValXvalPosition = yValXvalPosition + yValheightcalculation;


            }


            SolidBrush brush = new SolidBrush(Color.Aquamarine);
            Random rnd = new Random();

            NoofPlots = intCumulativeValuePer.Length;

            int widthcalculation_new = historgramWidth / NoofPlots;

            int XvalPosition_Start = Convert.ToInt32(XaxisplotWidth[0]);

            int XvalPosition_new = Convert.ToInt32(XaxisplotWidth[1]) - XvalPosition_Start;



            int Ystartval = 100;
            int YEndval = 100;
            //Fill Rectangle
            LinearGradientBrush a6 = new LinearGradientBrush(new RectangleF(StartXval, Ystartval, widthcalculation_new - StartXval, YEndval), Color.GreenYellow, Color.Green, LinearGradientMode.Vertical);
            brush = new SolidBrush(Color.Aquamarine);
            Pen pen = new Pen(Color.Gray);
            Font f2 = new Font("arial", 12, FontStyle.Bold, GraphicsUnit.Pixel);
            Point p1 = new Point();
            Point p2 = new Point();
            int smallLength = (historgramWidth / (intCumulativeValuePer.Length + 1));
            Double smallHeight = 0;
            // int smallX = topX;
            for (int i = 0; i < intCumulativeValuePer.Length - 1; i++)
            {


                brush.Color = Color.FromArgb(rnd.Next(200, 255), rnd.Next(255),
           rnd.Next(255), rnd.Next(255));
                p1 = p2;

                if (i == 0)
                {
                    p2.X = p2.X + smallLength + 40;
                }
                else
                {
                    p2.X = p2.X + smallLength + 14;
                }

                smallHeight = YaxisplotHight[YaxisplotHight.Length - 1] + ((YaxisplotData[YaxisplotHight.Length - 1] - intCumulativeValuePer[i]) * 2);


                for (int yval = 1; yval < YaxisplotData.Length; yval++)
                {

                    // Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intCumulativeValuePer[i])*10);

                    Double finaldisplayvalue = YaxisplotHight[yval] + ((YaxisplotData[yval] - intCumulativeValuePer[i]) * 2);
                    if (intCumulativeValuePer[i] <= YaxisplotData[yval - 1] && intCumulativeValuePer[i] > YaxisplotData[yval])
                    {

                        Ystartval = Convert.ToInt32(finaldisplayvalue);
                        smallHeight = Convert.ToInt32(finaldisplayvalue);
                    }



                }
                // smallHeight = historgramHeigt - YaxisplotHight[i]+150;

                p2.Y = Convert.ToInt32(smallHeight);
                if (p1.X != 0 && p1.Y != 0)
                {
                    e.DrawLine(pen, p1, p2);

                }
                Color pointColor = new Color();
                pointColor = Color.Green;


                DrawDots(e, p2, pointColor);
                e.DrawString(Math.Round(intCumulativeValuePer[i], 2).ToString(), f2, a2, p2.X, p2.Y - 18);

                if (i == 0)
                {
                    smallLength = smallLength - 15;
                }

                if (i == intCumulativeValuePer.Length - 2)
                {
                    p1.X = p2.X;
                    p1.Y = p2.Y;
                    for (int yval = 1; yval < YaxisplotData.Length; yval++)
                    {

                        // Double finaldisplayvalue = YaxisplotHight[yval - 1] + ((YaxisplotData[yval - 1] - intCumulativeValuePer[i])*10);

                        Double finaldisplayvalue = YaxisplotHight[yval] + ((YaxisplotData[yval] - intCumulativeValuePer[i + 1]) * 3);
                        if (intCumulativeValuePer[i + 1] <= YaxisplotData[yval - 1] && intCumulativeValuePer[i + 1] > YaxisplotData[yval])
                        {

                            Ystartval = Convert.ToInt32(finaldisplayvalue);
                            smallHeight = Convert.ToInt32(finaldisplayvalue);
                        }


                    }
                    //    p2.X = p2.X + smallLength - 24;
                    p2.Y = Convert.ToInt32(smallHeight);
                    if (p1.X != 0 && p1.Y != 0)
                    {


                        p2.X = p2.X + smallLength + 14;
                        e.DrawLine(pen, p1, p2);

                    }
                    DrawDots(e, p2, pointColor);
                    e.DrawString(Math.Round(intCumulativeValuePer[i + 1], 2).ToString(), f2, a2, p2.X, p2.Y - 18);
                }

                // smallX = smallX + smallLength;

            }




        }

        private void DrawDots(Graphics e, Point p1, Color c1)
        {
            Pen pen = new Pen(Color.Red);
            c1 = Color.Red;
            e.DrawPie(pen, p1.X - 5, p1.Y - 5, 10, 10, 0, 360);
            e.FillPie(new SolidBrush(c1), p1.X - 5, p1.Y - 5, 10, 10, 0, 360);
        }
          #endregion

        #region Zooming Methods

        /// <summary>
        /// Make the PictureBox dimensions larger to effect the Zoom.
        /// </summary>
        /// <remarks>Maximum 5 times bigger</remarks>
        private void ZoomIn()
        {
            if ((PicBox.Width < (MINMAX * OuterPanel.Width)) &&
                (PicBox.Height < (MINMAX * OuterPanel.Height)))
            {
                PicBox.Width = Convert.ToInt32(PicBox.Width * ZOOMFACTOR);
                PicBox.Height = Convert.ToInt32(PicBox.Height * ZOOMFACTOR);
                PicBox.SizeMode = PictureBoxSizeMode.StretchImage;
            }
        }

        /// <summary>
        /// Make the PictureBox dimensions smaller to effect the Zoom.
        /// </summary>
        /// <remarks>Minimum 5 times smaller</remarks>
        private void ZoomOut()
        {
            if ((PicBox.Width > (OuterPanel.Width / MINMAX)) &&
                (PicBox.Height > (OuterPanel.Height / MINMAX)))
            {
                PicBox.SizeMode = PictureBoxSizeMode.StretchImage;
                PicBox.Width = Convert.ToInt32(PicBox.Width / ZOOMFACTOR);
                PicBox.Height = Convert.ToInt32(PicBox.Height / ZOOMFACTOR);
            }
        }

        #endregion

        #region Mouse events

        /// <summary>
        /// We use the mousewheel to zoom the picture in or out
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void PicBox_MouseWheel(object sender, MouseEventArgs e)
        {
            if (e.Delta < 0)
            {
                ZoomIn();
            }
            else
            {
                ZoomOut();
            }
        }

        /// <summary>
        /// Make sure that the PicBox have the focus, otherwise it doesn큧 receive 
        /// mousewheel events !.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void PicBox_MouseEnter(object sender, EventArgs e)
        {
            if (PicBox.Focused == false)
            {
                PicBox.Focus();
            }
        }

        #endregion

        #region Disposing

        /// <summary>
        /// Die verwendeten Ressourcen bereinigen.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                    components.Dispose();
            }
            base.Dispose(disposing);
        }

        #endregion
    }
}
