﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ws.aspx.cs" Inherits="MyITJob.ws" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>

    <script src="/js/jquery-Service.js" type="text/javascript"></script>

    <style type="text/css">
        #form1 {font-size:14px;}
        .hover { cursor: pointer; /*小手*/ background: #ffc; /*背景*/ }
        .button { float: left; text-align: center; margin: 10px; padding: 10px; border: 1px solid #888; }
        #dictionary { text-align: center; font-size: 18px; clear: both; border-top: 3px solid #888; }
        #loading { border: 1px #000 solid; background-color: #eee; padding: 20px; margin: 100px 0 0 200px; position: absolute; display: none; }
        #switcher { }
    </style>

    <script type="text/javascript">        
        //无参数调用
        $(document).ready(function() {
            $('#btn1').click(function() {
                $.ajax({
                    type: "POST",   //访问WebService使用Post方式请求
                    contentType: "application/json", //WebService 会返回Json类型
                    url: "WebService1.asmx/HelloWorld", //调用WebService的地址和方法名称组合 ---- WsURL/方法名
                    data: "{}",         //这里是要传递的参数，格式为 data: "{paraName:paraValue}",下面将会看到       
                    dataType: 'json',
                    success: function(result) {     //回调函数，result，返回值
                        alert(result);
                        $('#dictionary').append(result.d);
                    }
                });
                //setInterval(csb, 500);
            });
        });
        
        //无参数调用 - 采集企业
        $(document).ready(function() {
            $('#btn2').click(function() {
                $.ajax({
                    type: "POST",   //访问WebService使用Post方式请求
                    contentType: "application/json", //WebService 会返回Json类型
                    url: "WebService1.asmx/jsMessage", //调用WebService的地址和方法名称组合 ---- WsURL/方法名
                    data: "{}",         //这里是要传递的参数，格式为 data: "{paraName:paraValue}",下面将会看到       
                    dataType: 'json',
                    success: function(result) {     //回调函数，result，返回值
                        alert(result);
                        $('#dictionary').append(result.d);
                    }
                });                
            });
        });

        //无参数调用 - 采集文章
        $(document).ready(function() {
            $('#btn3').click(function() {
                $.ajax({
                    type: "POST",   //访问WebService使用Post方式请求
                    contentType: "application/json", //WebService 会返回Json类型
                    url: "WebService1.asmx/Aritcles", //调用WebService的地址和方法名称组合 ---- WsURL/方法名
                    data: "{}",         //这里是要传递的参数，格式为 data: "{paraName:paraValue}",下面将会看到       
                    dataType: 'json',
                    success: function(result) {     //回调函数，result，返回值
                        alert(result);
                        $('#dictionary').append(result.d);
                    }
                });
            });
        });


        //有参数调用
        $(document).ready(function() {
            $("#btn2").click(function() {
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    url: "WebService1.asmx/GetWish",
                    data: "{value1:'心想事成',value2:'万事如意',value3:'牛牛牛',value4:2009}",
                    dataType: 'json',
                    success: function(result) {
                        $('#dictionary').append(result.d);
                    }
                });
            });
        });


        //返回集合（引用自网络，很说明问题）
        $(document).ready(function() {
            $("#btn3").click(function() {
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    url: "WebService1.asmx/GetArray",
                    data: "{i:10}",
                    dataType: 'json',
                    success: function(result) {
                        $(result.d).each(function() {
                            //alert(this);
                            $('#dictionary').append(this.toString() + " ");
                            //alert(result.d.join(" | "));
                        });
                    }
                });
            });
        });


        //返回复合类型
        $(document).ready(function() {
            $('#btn4').click(function() {
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    url: "WebService1.asmx/GetClass",
                    data: "{}",
                    dataType: 'json',
                    success: function(result) {
                        $(result.d).each(function() {
                            //alert(this);
                            $('#dictionary').append(this['ID'] + " " + this['Value']);
                            //alert(result.d.join(" | "));
                        });

                    }
                });
            });
        });

        //返回DataSet(XML)
        $(document).ready(function() {
            $('#btn5').click(function() {
                $.ajax({
                    type: "POST",
                    url: "WebService1.asmx/GetDataSet",
                    data: "{}",
                    dataType: 'xml', //返回的类型为XML ，和前面的Json，不一样了
                    success: function(result) {
                        //演示一下捕获
                        try {
                            $(result).find("Table1").each(function() {
                                $('#dictionary').append($(this).find("ID").text() + " " + $(this).find("Value").text());
                            });
                        }
                        catch (e) {
                            alert(e);
                            return;
                        }
                    },
                    error: function(result, status) { //如果没有上面的捕获出错会执行这里的回调函数
                        if (status == 'error') {
                            alert(status);
                        }
                    }
                });
            });
        });




        //Ajax 为用户提供反馈，利用ajaxStart和ajaxStop 方法，演示ajax跟踪相关事件的回调，他们两个方法可以添加给jQuery对象在Ajax前后回调
        //但对与Ajax的监控，本身是全局性的
        $(document).ready(function() {
            $('#loading').ajaxStart(function() {
                $(this).show();
            }).ajaxStop(function() {
                $(this).hide();
            });
        });

        // 鼠标移入移出效果，多个元素的时候，可以使用“，”隔开
        $(document).ready(function() {
            $('div.button').hover(function() {
                $(this).addClass('hover');
            }, function() {
                $(this).removeClass('hover');
            });
        });
        
        
    </script>

</head>
<body>
    <form id="form1" runat="server">
    <div id="switcher">
        <h2>
            工作易 特有 .NET 超大批量采集功能</h2>
            <div>超大量采集 —— 对目标开始进行采集。每次采集企业地址无限制，可直接复制几十成百上千企业地址进入采集器进行后台自动采集，无需人工等待（挂机处理）</div>
        <div class="button" id="btn1">
            1、点击按钮测试进程，显示HelloWorld表示环境正常</div>
        <%if(_type == "c") {%>
        <div class="button" id="btn2">
            2、点击按钮开始挂机处理采集</div><%} else {%>
        <div class="button" id="btn3">
            2、点击按钮开始文章挂机处理采集</div>    
            <%} %>
        <!--<div class="button" id="btn3">
            返回集合</div>
        <div class="button" id="btn4">
            返回复合类型</div>
        <div class="button" id="btn5">
            返回DataSet(XML)</div>-->
    </div>
    <div id="loading">
        服务器处理中，您可以同时完成其他操作（该页面请勿关闭）。任务完成后，该对话框会自动消失。
    </div>
    <div id="dictionary">
    </div>
    <br />
    <div style="color:Red; text-indent:2em;">
        特殊说明：<p>因为是NET的特殊进程（.NET3.5），挂机处理会导致CPU使用率的上升和流量的使用率增加<p>
        如果是虚拟空间，请确认您空间的CPU上限和流量上限，否则有可能被空间商禁止空间的访问。<p>
        如果是VPS或独立IP空间、主机、服务器，那么恭喜你……尽情的采集吧！<p>
        真正实现一夜之间拥有千万数据量，只要你指定多少采集地址，系统就帮你完成多少采集任务。
    </div>
    </form>
</body>
</html>
