﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TemplateProperty.aspx.cs" Inherits="Certificate.Web.Template.TemplateProperty1" Theme="default" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script src="../themes/default/Scripts/jquery-1.7.1.min.js"></script>
    <script src="../themes/default/Scripts/json.js"></script>
    <script src="../themes/default/Scripts/templateproperty.js"></script>
    <script src="../themes/default/Scripts/jquery.contextmenu.r2.packed.js"></script>
    <link href="../themes/default/Styles/templateproperty.css" rel="stylesheet" />
    <script src="../themes/default/layer/layer.min.js"></script>
    <link href="../themes/default/layer/skin/layer.css" rel="stylesheet" />
    <link href="../themes/default/Styles/jquery.bigcolorpicker.css" rel="stylesheet" />
    <script src="../themes/default/Scripts/jquery.bigcolorpicker.js"></script>
    <title></title>
    <style>
        body, form
        {
            margin: 0px;
        }

        *
        {
            font-family: 宋体,Tahoma;
            font-size: 12px;
            margin: 0px;
            padding: 0px;
        }

        .container
        {
            position: relative;
            border: 1px solid #808080;
            background-repeat: no-repeat;
            margin: 0px;
            padding: 0px;
        }

        .dragdivborder
        {
            background: #f6f6f6;
            filter: alpha(Opacity=80);
            -moz-opacity: 0.8;
            opacity: 0.8;
        }

        .addwenti
        {
            width: 550px;
            border-collapse: collapse;
            background: #fff;
        }

            .addwenti th
            {
                text-align: right;
                border-collapse: collapse;
                border: 1px #D7E6F0 solid;
                border-top: 0px;
                border-collapse: collapse;
                height: 18px;
                line-height: 18px;
                background-color: #F0F9FE;
                color: #1757B1;
                font-weight: normal;
            }

            .addwenti td
            {
                text-align: left;
                border-collapse: collapse;
                border-top: 0px;
                height: 18px;
                line-height: 18px;
                padding: 6px;
                color: #333;
                border: 1px #D7E6F0 solid;
                border-top: 0px;
            }

                .addwenti td p
                {
                    color: #666;
                }

                .addwenti td input
                {
                    color: #333;
                }

        .main
        {
            margin: 10px auto;
        }

        .tool
        {
            width: 100%;
            height: 35px;
            background: url(../themes/default/images/requestlistthbg.png);
            border: #e8e8e8 solid 1px;
            margin-bottom: 5px;
        }

            .tool ul
            {
                float: left;
                list-style: none;
                padding-left: 10px;
            }

                .tool ul li
                {
                    float: left;
                    line-height: 35px;
                    height: 35px;
                    padding-left: 6px;
                    padding-right: 6px;
                }

                    .tool ul li:hover
                    {
                        background: #efefef;
                    }

        input.button
        {
            background-image: url('../themes/default/images/btn.jpg');
            background-position: left top;
            background-repeat: repeat-x;
            border: 1px #3D3D3D solid;
            height: 22px!important;
            line-height: 18px!important;
            padding-left: 10px;
            padding-right: 10px;
            margin-left: 3px;
            color: #000;
            background-color: #fff;
        }
    </style>
    <script>
       
        var data=<%=data%>;
        $(document).ready(function () {
            install();
            $("#txbfontcolor").bigColorpicker("txbfontcolor", "L", 5);
            $("#ctxbfontcolor").bigColorpicker("ctxbfontcolor", "L", 5);


            $("#btnsubmit").click(function () {
                if ($("#hidindex").val() != "") { //修改
                    var i = parseInt($("#hidindex").val());
                    data.main[i].content = $("#txatempcontent").val();
                    data.main[i].fontstyle = $("#sfontstyle").val();
                    data.main[i].font = $("#txbfont").val();
                    data.main[i].fontsize = $("#txbfontsize").val();
                    data.main[i].fontcolor = $("#txbfontcolor").val();
                    data.main[i].mx = $("#txblocationx").val();
                    data.main[i].my = $("#txblocationy").val();
                    data.main[i].mw = $("#txbtempwidth").val();
                    data.main[i].mh = $("#txbtempheight").val();
                    install();
                }
                else  //添加文本项目
                {
                    
                    var option = { 
                        "title": "title" + data.main.length+1, 
                        "content": $("#txatempcontent").val(),
                        "font": $("#txbfont").val(),
                        "fontsize": $("#txbfontsize").val(),
                        "fontcolor": $("#txbfontcolor").val(),
                        "mx": $("#txblocationx").val(),
                        "my": $("#txblocationy").val(),
                        "mw": $("#txbtempwidth").val(),
                        "mh": $("#txbtempheight").val(),
                        "fontorpic": "1",
                        "fontstyle": $("#sfontstyle").val()
                    }
                    data.main.push(option);
                    install();
                }
            });

            $("#btndysave").click(function () {
                if ($("#hidname").val() != "") {
                    for (var i = 0; i < data.variable.length; i++) {
                        if ($("#hidname").val() == data.variable[i].name) {
                            data.variable[i].fontstyle = $("#cstxbfontstyle").val();
                            data.variable[i].font = $("#ctxbfont").val();
                            data.variable[i].fontsize = $("#ctxbfontsize").val();
                            data.variable[i].fontcolor = $("#ctxbfontcolor").val();
                            install();
                        }
                    }
                }
            });

            $("#btnssave").click(function(){
                var option = {
                    "title": "title" + data.main.length + 1,
                    "content": "UploadFiles\\Template\\"+$("#<%=ddlseal.ClientID%>").val(),
                    "font": "",
                    "fontsize": "",
                    "fontcolor": "",
                    "mx": $("#txbsmx").val(),
                    "my": $("#txbsmy").val(),
                    "mw": $("#txbsmw").val(),
                    "mh": $("#txbsmh").val(),
                    "fontorpic": "2",
                    "fontstyle": ""
                }
                data.main.push(option);
                install();
            })


            $("#btnesave").click(function(){
                if ($("#hidecode").val() != "") { //修改
                    var i = parseInt($("#hidecode").val());
                    data.main[i].content = $("#txbccontent").val();
                    data.main[i].mx = $("#txbcmx").val();
                    data.main[i].my = $("#txbcmy").val();
                    data.main[i].mw = $("#cmx").val();
                    data.main[i].mh = $("#cmx").val();
                    install();
                }
                else
                {
                    var option = {
                        "title": "title" + data.main.length + 1,
                        "content":$("#txbccontent").val(),
                        "font": "",
                        "fontsize": "",
                        "fontcolor": "",
                        "mx": $("#txbcmx").val(),
                        "my": $("#txbcmy").val(),
                        "mw": $("#cmx").val(),
                        "mh": $("#cmx").val(),
                        "fontorpic": "3",
                        "fontstyle": ""
                    }
                    data.main.push(option);
                    install();
                }
                
            })


            $("#linew").click(function(){
                var lay = $.layer({                                
                    type: 1,
                    title: '添加文本项',
                    fix: false,
                    shade: [0],
                    area: ['550px', '340px'],
                    page: { dom: '#addwenti' }
                });
                $('#btnclose').on('click', function () {
                    layer.close(lay);
                });

                $("#txatempcontent").val("请输入内容");
                $("#sfontstyle").val("regular");
                $("#txbfont").val("方正隶二简体");
                $("#txbfontsize").val("20");
                $("#txbfontcolor").val("#333333");
                $("#txblocationx").val("30");
                $("#txblocationy").val("30");
                $("#txbtempwidth").val("");
                $("#txbtempheight").val("");
                $("#hidindex").val("");
            })

            $("#linewimg").click(function () {
                var lay = $.layer({
                    type: 1,
                    title: '添加印章项',
                    fix: false,
                    shade: [0],
                    area: ['550px', '160px'],
                    page: { dom: '#yinzhang' }
                });
                $('#btnsclose').on('click', function () {
                    layer.close(lay);
                });
                $("#txbcmx").val("30");
                $("#txbcmx").val("30");
                $("#txbcmy").val("30");
                $("#txbcmw").val("180");
                $("#txbcmh").val("180");
            })
            $("#linewecode").click(function () {
                var lay = $.layer({
                    type: 1,
                    title: '添加二维码',
                    fix: false,
                    shade: [0],
                    area: ['550px', '265px'],
                    page: { dom: '#tbecode' }
                });
                $('#btneclose').on('click', function () {
                    layer.close(lay);
                });
                
                $("#txbccontent").val("http://url.com/renzheng.aspx?id=[certificateid]");
                $("#cmx").val("2");
                $("#txbcmy").val("30");
                $("#txbcmx").val("30");
                $("#hidecode").val(""); 
            })
        })

        function install() {
            $("#dragContainer").html("");
            for (var i = 0; i < data.main.length; i++) { //循环主数据
                var content = data.main[i].content.replace(" ", "&nbsp;&nbsp;");
                var wh = "";
                var div = "";
                if (data.main[i].fontorpic == "2")
                {
                    content = "<img src=\"/" + data.main[i].content + "\" style=\"width:" + data.main[i].mw + "px; height:" + data.main[i].mh + "px;\"/>";
                    div = "<div id=\"dragdiv" + i + "\" style=\"position:absolute;" + cssfontstyle + "left:" + data.main[i].mx + "px; top:" + data.main[i].my + "px;\">" + content + "</div>";
                }
                else if (data.main[i].fontorpic == "3") //二维码
                {
                    content = "<img src=\"/themes/default/images/ecode.png\" style=\"width:" +parseFloat(  data.main[i].mw)*45 + "px; height:" + parseFloat(data.main[i].mh)*45 + "px;\"/><span  style=\"display:none\">二维码</span>";
                    div = "<div id=\"dragdiv" + i + "\" style=\"position:absolute;" + cssfontstyle + "left:" +data.main[i].mx + "px; top:" + data.main[i].my + "px;\">" + content + "</div>";
                }
                else
                {
                    if (data.variable.length > 0) {
                        for (var b = 0; b < data.variable.length; b++) {
                            var cssvfontstyle = "";
                            if (data.variable[b].fontstyle == "bold")
                                cssvfontstyle = "font-weight:bold;";
                            else if (data.variable[b].fontstyle == "italic")
                                cssvfontstyle = "font-style:italic;";
                            else if (data.variable[b].fontstyle == "strikeout")
                                cssvfontstyle = "text-decoration:line-through;";
                            else if (data.variable[b].fontstyle == "underline")
                                cssvfontstyle = "text-decoration:underline;";
                            else
                                cssvfontstyle = "";
                            content = content.replace(data.variable[b].name, "<span style=\"font-family:" + data.variable[b].font + "; " + cssvfontstyle + "font-size:" + data.variable[b].fontsize + "px; color:" + data.variable[b].fontcolor + "\">" + data.variable[b].name + "</span>");
                        }
                    }            
                  
                    if (data.main[i].mw != "")
                        wh = "width:" + data.main[i].mw + "px; height:" + data.main[i].mh + "px";
                    var cssfontstyle = "";
                    if (data.main[i].fontstyle == "bold")
                        cssfontstyle = "font-weight:bold;";
                    else if (data.main[i].fontstyle == "italic")
                        cssfontstyle = "font-style:italic;";
                    else if (data.main[i].fontstyle == "strikeout")
                        cssfontstyle = "text-decoration:line-through;";
                    else if (data.main[i].fontstyle == "underline")
                        cssfontstyle = "text-decoration:underline;";
                    else
                        cssfontstyle = "";

                    div = "<div id=\"dragdiv" + i + "\" style=\"position:absolute;" + cssfontstyle + "left:" + data.main[i].mx + "px; top:" + data.main[i].my + "px;font-family:" + data.main[i].font + ";color:" + data.main[i].fontcolor + "; font-size:" + data.main[i].fontsize + "px;" + wh + "\">" + content + "</div>";
                }

                $("#dragContainer").append(div);
                $("#dragdiv" + i).dragDrop({
                    fixarea: [0, $('#dragContainer').width() - $(this).width, 0, $('#dragContainer').height() - $(this).height], callback: function (params) {
                     
                        var index=params.id.replace("dragdiv", "");
                        data.main[parseInt(index)].mx = params.moveX;
                        data.main[parseInt(index)].my = params.moveY;
                    }
                }).mouseover(function () {
                    $(this).addClass("dragdivborder");
                }).mouseout(function () {
                    $(this).removeClass("dragdivborder");
                }).contextMenu('myMenu1', {
                    bindings: {
                        'main': function (t) {
                          
                            var lay = $.layer({                                
                                type: 1,
                                title: '设置格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '340px'],
                                page: { dom: '#addwenti' }
                            });
                            $('#btnclose').on('click', function () {
                                layer.close(lay);
                            });
                            

                            binddata(t.id.replace("dragdiv", ""));                          
                        },
                        'code': function (t) {
                          
                            var lay = $.layer({                                
                                type: 1,
                                title: '设置格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '270px'],
                                page: { dom: '#tbecode' }
                            });
                            $('#btneclose').on('click', function () {
                                layer.close(lay);
                            });
                            

                            bindcode(t.id.replace("dragdiv", ""));                          
                        },

                        
                        'certificateid': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[certificateid] 证书编号 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[certificateid]");                            
                        },
                        'worksname': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[worksname] 作品名称 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[worksname]");
                        },
                        'writer': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[mdate] 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[mdate]");
                        },
                        'unitname': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[unitname] 单位名称 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[unitname]");
                        },
                        'awards': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[awards] 奖项 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[awards]");
                        },
                        'province': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[province] 省 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[province]");
                        },
                        'city': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[city] 市 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[city]");
                        },
                        'zone': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[zone] 区/县 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[zone]");
                        },
                        'subject': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[subject] 科目 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[subject]");
                        },
                        'grade': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[grade] 年级 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[grade]");
                        },
                        'curriculum': function (t) {
                            var lay = $.layer({
                                type: 1,
                                title: '设置[curriculum] 课程 格式',
                                fix: false,
                                shade: [0],
                                area: ['550px', '130px'],
                                page: { dom: '#certificate' }
                            });
                            $('#btndyclose').on('click', function () {
                                layer.close(lay);
                            });
                            bindcertificate("[curriculum]");
                        },                        
                        'delete':function(t){
                            layer.confirm('确定要删除吗？', function (index) {
                                layer.close(index);
                                data.main.splice(parseInt(t.id.replace("dragdiv", "")),1);
                                install();
                               
                            });
                        }
                    },
                    onContextMenu: function (e) {
                        //if ($(e.target).html() == "")
                        //    return false;
                        //else
                        return true;
                    },
                    onShowMenu: function (e, menu) {
                   
                        var menutext = $(e.target).html();
                       
                        if($(e.currentTarget).html().indexOf("二维码")<=-1)
                        {
                            $('#code', menu).remove();
                         
                        }
                        if (menutext == "")
                            $('#main', menu).remove();


                    
                        if (menutext.indexOf("[certificateid]", 0) < 0) {
                            $('#certificateid', menu).remove();
                        }
                        if (menutext.indexOf("[worksname]", 0) < 0) {
                            $('#worksname', menu).remove();
                        }
                       
                        if (menutext.indexOf("[mdate]", 0) < 0) {
                            $('#writer', menu).remove();
                        }
                        if (menutext.indexOf("[unitname]", 0) < 0) {
                            $('#unitname', menu).remove();
                        }
                        if (menutext.indexOf("[awards]", 0) < 0) {
                            $('#awards', menu).remove();
                        }
                        if (menutext.indexOf("[province]", 0) < 0) {
                            $('#province', menu).remove();
                        }
                        if (menutext.indexOf("[city]", 0) < 0) {
                            $('#city', menu).remove();
                        }
                        if (menutext.indexOf("[zone]", 0) < 0) {
                            $('#zone', menu).remove();
                        }
                        if (menutext.indexOf("[subject]", 0) < 0) {
                            $('#subject', menu).remove();
                        }
                        if (menutext.indexOf("[grade]", 0) < 0) {
                            $('#grade', menu).remove();
                        }
                        if (menutext.indexOf("[curriculum]", 0) < 0) {
                            $('#curriculum', menu).remove();
                        }

                        
                        return menu;
                    },
                    menuStyle: {
                        border: '1px solid #c6dff6',
                        fontSize: '14px'
                    },
                    itemStyle: {
                        fontFamily: 'verdana',
                        backgroundColor: '#ffffff',
                        color: '#666666',
                        border: 'none',
                        padding: '1px',
                        fontSize: '14px'
                    },
                    itemHoverStyle: {
                        color: '#fff',
                        backgroundColor: '#6492ca',
                        border: 'none'
                    }

                });
            }
        }

        function binddata(ii) {           
            var i = parseInt(ii);
            $("#txatempcontent").val(data.main[i].content);
            $("#sfontstyle").val(data.main[i].fontstyle);
            $("#txbfont").val(data.main[i].font);
            $("#txbfontsize").val(data.main[i].fontsize);
            $("#txbfontcolor").val(data.main[i].fontcolor);
            $("#txblocationx").val(data.main[i].mx);
            $("#txblocationy").val(data.main[i].my);
            $("#txbtempwidth").val(data.main[i].mw);
            $("#txbtempheight").val(data.main[i].mh);
            $("#hidindex").val(i);            
        }

        function bindcertificate(name) {
            if (data.variable.length > 0) {
                for (var i = 0; i < data.variable.length; i++) {
                    if (data.variable[i].name == name) {
                        $("#cstxbfontstyle").val(data.variable[i].fontstyle);
                        $("#ctxbfont").val(data.variable[i].font);
                        $("#ctxbfontsize").val(data.variable[i].fontsize);
                        $("#ctxbfontcolor").val(data.variable[i].fontcolor);
                        $("#hidname").val(data.variable[i].name);
                        return;
                    }
                }
            }
            $("#hidindex").val(i);
        }

        function bindcode(ii) {           
            var i = parseInt(ii);
            $("#txbccontent").val(data.main[i].content);
          
            $("#txbcmx").val(data.main[i].mx);
            $("#txbcmy").val(data.main[i].my);
            $("#cmx").val(data.main[i].mw);
            $("#hidecode").val(i);            
        }

        

        function save() {
            $.ajax({
                type: "post",
                url: "ajax/savetempateproperty.ashx",
                dataType: 'text',
                data: { id: "<%=HidTempID.Value%>", data: JSON.stringify(data) },
                success: function (bdata) {
                    if (bdata == "1")
                        layer.alert("保存成功", 1, "保存模板数据");
                    else
                        layer.alert("保存失败", 2, "保存模板数据");
                }
            });
        }

    </script>
</head>
<body>

    <link rel="stylesheet" type="text/css" href="/themes/<%=themes %>/Styles/tabber.css">
    <link rel="stylesheet" type="text/css" href="/themes/<%=themes %>/Styles/farbtastic.css">
    <form id="form1" runat="server">

        <div class="main" style="width: <%=tempwidth%>px; height: <%=tempheight%>px;">
            <asp:Literal ID="LitTitle" runat="server" Visible="false"></asp:Literal>
            <div class="tool">
                <ul>
                    <li title="新建文本项">
                        <img src="../themes/default/ico/newpro.png" alt="新建文本项" id="linew" /></li>
                    <li title="添加印章项">
                        <img src="../themes/default/ico/newtask32.png" alt="添加印章项" id="linewimg" /></li>
                    <li title="添加二维码">
                        <img src="../themes/default/ico/newecode.png" alt="添加二维码" id="linewecode" /></li>
                    <li title="保存">
                        <img src="../themes/default/ico/savepro.png" alt="保存" onclick="save()" /></li>
                </ul>

            </div>

            <div id="dragContainer" class="container" style="width: <%=tempwidth%>px; height: <%=tempheight%>px; background-image: url('/<%=bgpic%>')">
            </div>
        </div>
        <div class="contextMenu" id="myMenu1">
            <ul>
                <li id="main">
                    <img src="../themes/default/ico/editquery16.png" />设置格式</li>
                <li id="code">
                    <img src="../themes/default/ico/editquery16.png" />设置格式</li>
                <li id="certificateid">[certificateid]</li>
                <li id="worksname">[worksname]</li>
                <li id="writer">[mdate]</li>
                <li id="unitname">[unitname]</li>
                <li id="awards">[awards]</li>
                <li id="province">[province]</li>
                <li id="city">[city]</li>
                <li id="zone">[zone]</li>
                <li id="subject">[subject]</li>
                <li id="grade">[grade]</li>
                <li id="curriculum">[curriculum]</li>

                <li id="delete">
                    <img src="../themes/default/ico/delete16.png" />删除</li>
            </ul>
        </div>

        <table class="addwenti" id="addwenti" style="display: none">

            <tr>
                <th style="width: 70px">内容:</th>
                <td colspan="3">
                    <textarea style="width: 98%; height: 50px;" id="txatempcontent"></textarea>
                </td>
            </tr>
            <tr>
                <th>字体样式:</th>
                <td>
                    <select id="sfontstyle">
                        <option value="regular">普通文本</option>
                        <option value="bold">加粗文本</option>
                        <option value="italic">倾斜文本</option>
                        <option value="strikeout">中横线文本</option>
                        <option value="underline">下划线文本</option>
                    </select>
                </td>
                <th>字体:</th>
                <td>
                    <input type="text" value="" id="txbfont" />
                </td>
            </tr>
            <tr>
                <th>字体大小:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbfontsize" />
                </td>
                <th>字体颜色:</th>
                <td>
                    <input type="text" value="#000000" id="txbfontcolor" />
                </td>
            </tr>

            <tr>
                <th>位置X:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txblocationx" />
                </td>
                <th>位置Y:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txblocationy" />
                </td>
            </tr>
            <tr>
                <th>[矩形]宽度:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbtempwidth" />
                </td>
                <th>[矩形]高度:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbtempheight" />
                    <input id="hidindex" type="hidden" value="" />
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <input id="btnsubmit" type="button" value="确定" class="button" />
                    <input id="btnclose" type="button" value="关闭" class="button" />

                </td>

            </tr>
            <tr>
                <th>动态字段：</th>
                <td colspan="3">防伪编号：[certificateid] 
                        产品名称：[worksname] 
                        公司名称：[unitname] <br/>
                        生产日期：[mdate] 
                       
                </td>

            </tr>
        </table>
        <table class="addwenti" id="certificate" style="display: none">


            <tr>

                <th>字体样式:</th>
                <td>
                    <select id="cstxbfontstyle">
                        <option value="regular">普通文本</option>
                        <option value="bold">加粗文本</option>
                        <option value="italic">倾斜文本</option>
                        <option value="strikeout">中横线文本</option>
                        <option value="underline">下划线文本</option>
                    </select>
                </td>
                <th>字体:</th>
                <td>
                    <input type="text" value="" id="ctxbfont" />
                </td>
            </tr>
            <tr>
                <th>字体大小:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="ctxbfontsize" />
                </td>
                <th>字体颜色:</th>
                <td>
                    <input type="text" value="#000000" id="ctxbfontcolor" />
                    <input type="hidden" id="hidname" />
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <input id="btndysave" type="button" value="确定" class="button" />
                    <input id="btndyclose" type="button" value="关闭" class="button" />

                </td>

            </tr>


        </table>
        <table class="addwenti" id="yinzhang" style="display: none">


            <tr>

                <th style="width: 100px;">印章:</th>
                <td colspan="3">
                    <asp:DropDownList ID="ddlseal" runat="server"></asp:DropDownList>
                </td>

            </tr>
            <tr>
                <th>位置X:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbsmx" />
                </td>
                <th>位置Y:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbsmy" />
                </td>
            </tr>
            <tr>
                <th>宽度:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbsmw" />
                </td>
                <th>高度:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbsmh" />
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <input id="btnssave" type="button" value="确定" class="button" />
                    <input id="btnsclose" type="button" value="关闭" class="button" />

                </td>

            </tr>


        </table>

        <table class="addwenti" id="tbecode" style="display: none">


            <tr>
                <th style="width: 70px">内容:</th>
                <td colspan="3">
                    <textarea style="width: 98%; height: 50px;" id="txbccontent"></textarea>
                </td>
            </tr>
            <tr>
                <th>位置X:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbcmx" />
                </td>
                <th>位置Y:</th>
                <td>
                    <input type="text" onkeyup="value=value.replace(/[^\d\.]/g,'')" value="" id="txbcmy" />
                </td>
            </tr>
            <tr>
                <th>正方型:</th>
                <td colspan="3">
                    <select id="cmx">
                        <option value="1">45</option>
                        <option value="2">90</option>
                        <option value="3">135</option>
                        <option value="4">180</option>
                        <option value="5">225</option>
                        <option value="6">270</option>
                        <option value="7">315</option>
                        <option value="8">360</option>
                    </select>
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <input id="btnesave" type="button" value="确定" class="button" />
                    <input id="btneclose" type="button" value="关闭" class="button" />
                    <input type="hidden" id="hidecode" />
                </td>

            </tr>
            <tr>
                <th>动态字段：</th>
                <td colspan="3">>防伪编号：[certificateid] 
                        产品名称：[worksname] 
                        公司名称：[unitname] 
                        生产日期：[mdate] 
                </td>

            </tr>

        </table>

        <asp:HiddenField ID="HidTempID" runat="server" />
    </form>
</body>
</html>
