﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace MultipleMonthViewCalender.CustomDatePicker
{
    public partial class CustomPopUpCalender : UserControl
    {
        public CustomPopUpCalender()
        {
            InitializeComponent();
            CalendeDateChanged();
            
        }

        private void Calnder_Main_DisplayDateChanged(object sender, CalendarDateChangedEventArgs e)
        {
            CalendeDateChanged();
        }
        private void CalendeDateChanged()
        {
            Calendar2.DisplayDate = Calendar_Main.DisplayDate.AddMonths(1);

            //On Change of Month Change the Display Month and Year of Header Label
            var dtf = System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat;
            string monthName = dtf.GetMonthName(Calendar_Main.DisplayDate.Month);
            lblMonth.Content = monthName + "," + Calendar_Main.DisplayDate.Year;
        }



        private void btnNext_Click(object sender, RoutedEventArgs e)
        {
            Calendar_Main.DisplayDate = Calendar_Main.DisplayDate.AddMonths(1);
        }

        private void btnPrev_Click(object sender, RoutedEventArgs e)
        {
            Calendar_Main.DisplayDate = Calendar_Main.DisplayDate.AddMonths(-1);
        }

        private void lblMonth_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            Calendar_Main.DisplayMode = CalendarMode.Year;

        }

        
    }
}
