﻿#region author
    // author: FengYi
    //     QQ: 85807571
    //  Email: fengyihot@qq.com
#endregion

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
//www.mycodes.net
namespace WebSite.FengYi
{
    public partial class Main : Form
    {
        RegistryKey regKeyAppRoot = Registry.CurrentUser.CreateSubKey("Software\\WebSite.FengYi");
        RegistryKey RunSeeting = Registry.CurrentUser.CreateSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Run");

        public Main()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            #region 开机时自动启动 WebSite
            if (RunSeeting.GetValue("WebSite") == null)
            {
                // The value doesn't exist, the application is not set to run at startup
                StartBegin.Checked = false;
            }
            else
            {
                // The value exists, the application is set to run at startup
                StartBegin.Checked = true;
            }
            #endregion


            #region Php
            if ((string)regKeyAppRoot.GetValue("WebSite_Php") == null)
            {
                regKeyAppRoot.SetValue("WebSite_Php", "On");
            }
            else
            {
                if ((string)regKeyAppRoot.GetValue("WebSite_Php") != "On" &&
                    (string)regKeyAppRoot.GetValue("WebSite_Php") != "Off")
                {
                    regKeyAppRoot.SetValue("WebSite_Php", "On");
                }
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_Php"))
            {
                case "On":
                    Start_App_Php.Checked = true;
                    break;
                case "Off":
                    Start_App_Php.Checked = false;
                    break;
            }
            #endregion

            #region MySql
            if ((string)regKeyAppRoot.GetValue("WebSite_MySql") == null)
            {
                regKeyAppRoot.SetValue("WebSite_MySql", "On");
            }
            else
            {
                if ((string)regKeyAppRoot.GetValue("WebSite_MySql") != "On" &&
                    (string)regKeyAppRoot.GetValue("WebSite_MySql") != "Off")
                {
                    regKeyAppRoot.SetValue("WebSite_MySql", "On");
                }
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_MySql"))
            {
                case "On":
                    Start_App_MySql.Checked = true;
                    break;
                case "Off":
                    Start_App_MySql.Checked = false;
                    break;
            }
            #endregion

            #region 启动和登录
            #region 启动 WebSite 后自动运行
            if ((string)regKeyAppRoot.GetValue("WebSite_Start_Auto_App") == null)
            {
                regKeyAppRoot.SetValue("WebSite_Start_Auto_App", "On");
            }
            else
            {
                if ((string)regKeyAppRoot.GetValue("WebSite_Start_Auto_App") != "On" &&
                    (string)regKeyAppRoot.GetValue("WebSite_Start_Auto_App") != "Off")
                {
                    regKeyAppRoot.SetValue("WebSite_Start_Auto_App", "On");
                }
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_Start_Auto_App"))
            {
                case "On":
                    Start_Auto_App.Checked = true;
                    break;
                case "Off":
                    Start_Auto_App.Checked = false;
                    break;
            }
            #endregion


            if ((string)regKeyAppRoot.GetValue("WebSite_RunHideMain") == null)
            {
                Run_Hide_Main.Checked = true;
            }
            else
            {
                Run_Hide_Main.Checked = false;
            }

            #endregion

            #region 始终保持在其它窗口前端
            switch ((string)regKeyAppRoot.GetValue("WebSite_TopMust"))
            {
                case "On":
                    this.TopMost = true;
                    TopMust.Checked = true;
                    break;
                case "Off":
                    this.TopMost = false;
                    TopMust.Checked = false;
                    break;
            }
            #endregion

            #region 关闭主面板时
            if ((string)regKeyAppRoot.GetValue("WebSite_Close_Remember") == null)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "Hide");
            }
            else
            {
                if ((string)regKeyAppRoot.GetValue("WebSite_Close_Remember") != "Hide" &&
                    (string)regKeyAppRoot.GetValue("WebSite_Close_Remember") != "Exit" &&
                    (string)regKeyAppRoot.GetValue("WebSite_Close_Remember") != "ExitAll")
                {
                    regKeyAppRoot.SetValue("WebSite_Close_Remember", "Hide");
                }
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_Close_Remember"))
            {
                case "Hide":
                    Close_Hide.Checked = true;
                    break;
                case "Exit":
                    Close_Exit.Checked = true;
                    break;
                case "ExitAll":
                    Close_All_App_Exit.Checked = true;
                    break;
            }

            if ((string)regKeyAppRoot.GetValue("WebSite_Close_Prompt") == null)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Prompt", "On");
            }
            else
            {
                if ((string)regKeyAppRoot.GetValue("WebSite_Close_Prompt") != "On" &&
                    (string)regKeyAppRoot.GetValue("WebSite_Close_Prompt") != "Off")
                {
                    regKeyAppRoot.SetValue("WebSite_Close_Prompt", "Off");
                }
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_Close_Prompt"))
            {
                case "On":
                    Close_Prompt.Checked = false;
                    break;
                case "Off":
                    Close_Prompt.Checked = true;
                    break;
            }
            #endregion

            #region 运行后自动隐藏主界面
            switch ((string)regKeyAppRoot.GetValue("WebSite_RunHideMain"))
            {
                case "On":
                    this.Opacity = 0;
                    this.Hide();
                    Run_Hide_Main.Checked = true;
                    break;
                case "Off":
                    Run_Hide_Main.Checked = false;
                    break;
            }
            #endregion

            #region 启动 WebSite 后自动运行
            if ((string)regKeyAppRoot.GetValue("WebSite_Start_Auto_App") == "On")
            {
                Start_Restart();
            }
            #endregion
        }
        private void Start_App_Php_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_App_Php.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Php", "On");
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_Php", "Off");
            }
        }
        private void Start_App_MySql_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_App_MySql.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_MySql", "On");
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_MySql", "Off");
            }
        }
        private void Start_App_Click(object sender, EventArgs e)
        {
            Start_Restart();
        }
        private void Stop_App_Click(object sender, EventArgs e)
        {
            killprocess("Website_php");
            killprocess("Website_mysqld");
            killprocess("Website_nginx");
        }
        private void Start_Auto_App_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_Auto_App.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Start_Auto_App", "On");
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_Start_Auto_App", "Off");
            }
        }
        private void StartBegin_CheckedChanged(object sender, EventArgs e)
        {
            if (StartBegin.Checked)
            {
                RunSeeting.SetValue("WebSite", '"' + Application.ExecutablePath.ToString() + '"');
            }
            else
            {
                RunSeeting.DeleteValue("WebSite", false);
            }
        }

        private void RegisterInStartup(bool isChecked)
        {
            RegistryKey registryKey = Registry.CurrentUser.OpenSubKey
                    ("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", true);
            if (isChecked)
            {
                registryKey.SetValue("ApplicationName", Application.ExecutablePath);
            }
            else
            {
                registryKey.DeleteValue("ApplicationName");
            }
        }

        private void TopMust_CheckedChanged(object sender, EventArgs e)
        {
            if (TopMust.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_TopMust", "On");
                this.TopMost = true;
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_TopMust", "Off");
                this.TopMost = false;
            }
        }
        private void Run_Hide_Main_CheckedChanged(object sender, EventArgs e)
        {
            if (Run_Hide_Main.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_RunHideMain", "On");
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_RunHideMain", "Off");
            }
        }
        private void Close_Hide_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "Hide");
            }
        }
        private void Close_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Exit.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "Exit");
            }
        }
        private void Close_All_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_All_App_Exit.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "ExitAll");
            }
        }
        private void Close_Prompt_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Prompt.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Prompt", "Off");
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_Close_Prompt", "On");
            }
        }

        #region Close Event
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                // Pause events

                switch ((string)regKeyAppRoot.GetValue("Website_Close_Prompt"))
                {
                    case "On":
                        MainClose _MainClose = new MainClose(this);
                        _MainClose.ShowDialog();
                        break;
                    case "Off":
                        switch ((string)regKeyAppRoot.GetValue("Website_Close_Remember"))
                        {
                            case "Hide":
                                this.Opacity = 0;
                                break;
                            case "Exit":
                                Dispose();
                                e.Cancel = false;
                                break;
                        }
                        break;
                }
                return;
            }

            e.Cancel = false;
        }
        #endregion
        public void Start_Restart()
        {
            killprocess("Website_php");
            killprocess("Website_mysqld");
            killprocess("Website_nginx");


            #region PHP
            if (Start_App_Php.Checked)
            {
                System.Diagnostics.ProcessStartInfo App_vcredist = new System.Diagnostics.ProcessStartInfo();
                App_vcredist.FileName = Application.StartupPath + "\\php\\vcredist_x86.exe";
                App_vcredist.Arguments = "/install /passive /norestart";
                System.Diagnostics.Process App_vcredistp;
                try
                {
                    App_vcredistp = System.Diagnostics.Process.Start(App_vcredist);
                    if (App_vcredistp != null)
                    {
                        App_vcredistp.WaitForExit();
                    }
                }
                catch
                {
                    MessageBox.Show("没有该文件...");
                }


                System.Diagnostics.ProcessStartInfo App_Php = new System.Diagnostics.ProcessStartInfo();
                App_Php.FileName = Application.StartupPath + "\\RunHiddenConsole.exe";
                App_Php.Arguments = "php\\Website_php.exe -b 127.0.0.1:9000 -c php\\php.ini";
                System.Diagnostics.Process App_Phpp;
                try
                {
                    App_Phpp = System.Diagnostics.Process.Start(App_Php);
                }
                catch
                {
                    MessageBox.Show("没有该文件...");
                }
            }
            #endregion

            #region MySql
            if (Start_App_MySql.Checked)
            {
                System.Diagnostics.ProcessStartInfo App_MySql = new System.Diagnostics.ProcessStartInfo();
                App_MySql.FileName = Application.StartupPath + "\\RunHiddenConsole.exe";
                App_MySql.Arguments = "mysql\\bin\\website_mysqld.exe";
                System.Diagnostics.Process App_Phpp;
                try
                {
                    App_Phpp = System.Diagnostics.Process.Start(App_MySql);
                }
                catch
                {
                    MessageBox.Show("没有该文件...");
                }
            }
            #endregion

            System.Diagnostics.ProcessStartInfo App_Ngnix = new System.Diagnostics.ProcessStartInfo();
            App_Ngnix.FileName = Application.StartupPath + "\\RunHiddenConsole.exe";
            App_Ngnix.Arguments = "Website_nginx.exe";
            System.Diagnostics.Process app_ngnixp;
            try
            {
                app_ngnixp = System.Diagnostics.Process.Start(App_Ngnix);
            }
            catch
            {
                MessageBox.Show("没有该文件...");
            }
        }
        public void killprocess(string aa)
        {
            System.Diagnostics.Process[] pcs = System.Diagnostics.Process.GetProcesses();
            foreach (System.Diagnostics.Process p in pcs)
            {
                if (p.ProcessName == aa)
                {
                    p.Kill();
                }
            }
        }

        private void ShowAndHide_Click(object sender, EventArgs e)
        {
            if (this.Opacity > 0)
            {
                this.Opacity = 0;
                this.Activate();
            }
            else
            {
                this.Opacity = 100;
                this.Activate();
            }
        }

        private void Exit_Application_Click(object sender, EventArgs e)
        {
            this.Activate();
            this.Close();
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (this.Opacity > 0)
            {
                this.Opacity = 0;
                this.Activate();
            }
            else
            {
                this.Opacity = 100;
                this.Activate();
            }
        }

        private void 配置NgnixToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.ProcessStartInfo App_Ngnix = new System.Diagnostics.ProcessStartInfo();
            App_Ngnix.FileName = Application.StartupPath + "\\conf\\nginx.conf";
            App_Ngnix.Arguments = "";
            System.Diagnostics.Process app_ngnixp;
            try
            {
                app_ngnixp = System.Diagnostics.Process.Start(App_Ngnix);
            }
            catch
            {
                MessageBox.Show("没有该文件...");
            }
        }

        private void mimeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.ProcessStartInfo App_Ngnix = new System.Diagnostics.ProcessStartInfo();
            App_Ngnix.FileName = Application.StartupPath + "\\conf\\mime.types";
            App_Ngnix.Arguments = "";
            System.Diagnostics.Process app_ngnixp;
            try
            {
                app_ngnixp = System.Diagnostics.Process.Start(App_Ngnix);
            }
            catch
            {
                MessageBox.Show("没有该文件...");
            }
        }

        private void 配置PHPToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.ProcessStartInfo App_Ngnix = new System.Diagnostics.ProcessStartInfo();
            App_Ngnix.FileName = Application.StartupPath + "\\php\\php.ini";
            App_Ngnix.Arguments = "";
            System.Diagnostics.Process app_ngnixp;
            try
            {
                app_ngnixp = System.Diagnostics.Process.Start(App_Ngnix);
            }
            catch
            {
                MessageBox.Show("没有该文件...");
            }
        }
    }
}