﻿#region author
// author: FengYi
//     QQ: 85807571
//  Email: fengyihot@qq.com
#endregion

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;

namespace WebSite.FengYi
{
    public partial class MainClose : Form
    {
        Main main;
        RegistryKey regKeyAppRoot = Registry.CurrentUser.CreateSubKey("Software\\WebSite.FengYi");

        public MainClose(Main m)
        {
            InitializeComponent();
            main = m;
        }

        private void MainClose_Load(object sender, EventArgs e)
        {
            #region 关闭面板时
            switch ((string)regKeyAppRoot.GetValue("WebSite_Close_Remember"))
            {
                case "Hide":
                    Close_Hide.Checked = true;
                    break;
                case "Exit":
                    Close_Exit.Checked = true;
                    break;
                case "ExitAll":
                    Close_All_App_Exit.Checked = true;
                    break;
            }

            switch ((string)regKeyAppRoot.GetValue("WebSite_Close_Prompt"))
            {
                case "On":
                    Close_Prompt.Checked = false;
                    break;
                case "Off":
                    Close_Prompt.Checked = true;
                    break;
            }
            #endregion
        }

        private void OK_Click(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                main.Close_Hide.Checked = true;
                main.Opacity = 0;
            }

            if (Close_Exit.Checked)
            {
                Application.Exit();
            }

            if (Close_All_App_Exit.Checked)
            {
                killprocess("Website_php");
                killprocess("Website_mysqld");
                killprocess("Website_nginx");
                
                Application.Exit();
            }

            this.Close();
        }

        private void Close_Canel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        public void killprocess(string aa)
        {
            System.Diagnostics.Process[] pcs = System.Diagnostics.Process.GetProcesses();
            foreach (System.Diagnostics.Process p in pcs)
            {
                if (p.ProcessName == aa)
                {
                    p.Kill();
                }
            }
        }

        private void Close_Hide_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "Hide");
                main.Close_Hide.Checked = true;
            }
            else
            {
                main.Close_Hide.Checked = false;
            }
        }

        private void Close_All_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_All_App_Exit.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "ExitAll");
                main.Close_All_App_Exit.Checked = true;
            }
            else
            {
                main.Close_All_App_Exit.Checked = false;
            }
        }

        private void Close_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Exit.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Remember", "Exit");
                main.Close_Exit.Checked = true;
            }
            else
            {
                main.Close_Exit.Checked = false;
            }
        }
        private void Close_Prompt_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Prompt.Checked)
            {
                regKeyAppRoot.SetValue("WebSite_Close_Prompt", "Off");
                main.Close_Prompt.Checked = true;
            }
            else
            {
                regKeyAppRoot.SetValue("WebSite_Close_Prompt", "On");
                main.Close_Prompt.Checked = false;
            }
        }
    }
}
