﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.IO;
using System.Text.RegularExpressions;

namespace Web
{
    public partial class qqinterface : System.Web.UI.Page
    {
        public static Queue que = Queue.Synchronized(new Queue());
        public static Hashtable hashFriends = Hashtable.Synchronized(new Hashtable());
        public static Hashtable hashWenda = Hashtable.Synchronized(new Hashtable());
        public static Hashtable hashQunWenda = Hashtable.Synchronized(new Hashtable());
        protected void Page_Load(object sender, EventArgs e)
        {
            
            if (Request.RequestType.Equals("post", StringComparison.InvariantCultureIgnoreCase))
            {
                string ExternalId = Request.Form["ExternalId"].Trim();
                string Sender = Request.Form["Sender"].Trim();
                string Message = Request.Form["Message"].Trim();

                if (ExternalId == "0")
                {//qq消息
                    if (Message.Length > 500)
                    {
                        Response.Write("演示项目，请勿攻击，谢谢！");
                        return;
                    }

                    Cache["receive"] = string.Format("收到QQ：{0}的消息：{1}", Sender, Message);

                    Match m = Regex.Match(Message, @"^问[\:：]{1}(.*?)答[\:：]{1}(.*?)$", RegexOptions.Compiled | RegexOptions.IgnoreCase);
                    if(m.Success)
                    {
                        qqinterface.hashWenda[m.Groups[1].Value.Trim()] = m.Groups[2].Value.Trim();
                        Response.Write("我已经学会了，您可以问我：" + m.Groups[1].Value.Trim());
                    }
                    else if (hashWenda.ContainsKey(Message))
                    {
                        Response.Write(hashWenda[Message].ToString());
                    }
                    else
                    {
                        Response.Write(string.Format("这是一个接口程序，想回复什么可以自由实现，支持asp,php,asp.net等等基于http协议的程序，有什么疑问欢迎联系QQ:4111852\n\n收到QQ：{0}的消息：{1}\n\n您也可以到网站上去教我怎么回答。\n\n或者发送类似：“问：吃饭了吗答：吃过了。”这样包括问答的话，我就可以学会。", Sender, Message));
                    }
                    if(Sender != "4111852")
                        que.Enqueue(string.Format("0\n4111852\n{0}对机器人说：{1}", Sender, Message));
                }
                else if (ExternalId == "-1")
                {//加好友消息
                    Cache["receive"] = string.Format("这是一个接口程序，想回复什么可以自由实现，支持asp,php,asp.net等等基于http协议的程序，有什么疑问欢迎联系QQ:4111852\n\n收到加好友的请求：{0}的消息：{1}", Sender, Message);
                    que.Enqueue("0\n4111852\n" + Sender + "加机器人为好友");
                    Response.Write(string.Format("这是一个接口程序，想回复什么可以自由实现，支持asp,php,asp.net等等基于http协议的程序，有什么疑问欢迎联系QQ:4111852\n\n收到加好友的请求：{0}的消息：{1}", Sender, Message));
                }
                else if (ExternalId == "-2")
                {//好友列表
                    StringReader reader = new StringReader(Message);
                    string line = reader.ReadLine();
                    while (line != null)
                    {
                        Match m = Regex.Match(line, @"^(\d+) (ONLINE|OFFLINE|AWAY|HIDDEN) (.*?)$", RegexOptions.Compiled | RegexOptions.IgnoreCase);
                        string qq = m.Groups[1].ToString();
                        string status = m.Groups[2].ToString();
                        string nick = m.Groups[3].ToString();
                        hashFriends[qq] = new string[] { nick, status };
                        line = reader.ReadLine();
                    }
                }
                else if (ExternalId == "-4")
                {//好友状态改变
                    StringReader reader = new StringReader(Message);
                    string line = reader.ReadLine();
                    while (line != null)
                    {
                        Match m = Regex.Match(line, @"^(\d+) (ONLINE|OFFLINE|AWAY|HIDDEN) (.*?)$", RegexOptions.Compiled | RegexOptions.IgnoreCase);
                        string qq = m.Groups[1].ToString();
                        string status = m.Groups[2].ToString();
                        string nick = m.Groups[3].ToString();
                        hashFriends[qq] = new string[] { nick, status };
                        if (status.Equals("ONLINE", StringComparison.InvariantCultureIgnoreCase))
                            Response.Write(ChangeState());

                        line = reader.ReadLine();
                    }
                }

                else if (ExternalId == "-3")
                {
                    //qq签名改变
                    Cache["receive"] = string.Format("收到QQ：{0}的签名：{1}", Sender, Message);
                    Response.Write(string.Format("{0}，您的新签名很有意思：{1}", Sender, Message));
                }
                else
                {//群消息处理
                    if (Message.Length > 500)
                    {
                        Response.Write("演示项目，请勿攻击，谢谢！");
                        return;
                    }

                    Cache["receive"] = string.Format("这是一个接口程序，想回复什么可以自由实现，支持asp,php,asp.net等等基于http协议的程序，有什么疑问欢迎联系QQ:4111852\n\n收到群：{0}的消息：{1}", ExternalId, Message);

                    Match m = Regex.Match(Message, @"^问[\:：]{1}(.*?)答[\:：]{1}(.*?)$", RegexOptions.Compiled | RegexOptions.IgnoreCase);
                    if (m.Success)
                    {
                        qqinterface.hashQunWenda[m.Groups[1].Value.Trim()] = m.Groups[2].Value.Trim();
                        Response.Write("我已经学会了，您可以问我：" + m.Groups[1].Value.Trim());
                    }
                    else if (hashQunWenda.ContainsKey(Message))
                    {
                        Response.Write(hashQunWenda[Message].ToString());
                    }
                    else
                    {
                        Response.Write(string.Format("这是一个接口程序，想回复什么可以自由实现，支持asp,php,asp.net等等基于http协议的程序，有什么疑问欢迎联系QQ:4111852\n\n收到群：{0}的消息：{1}\n\n您也可以到网站上去教我怎么回答。\n\n或者发送类似：“问：吃饭了吗答：吃过了。”这样包括问答的话，我就可以学会。", Sender, Message));
                    }
                }

            }
            else
            {
                if (que.Count>0)
                {
                    Response.Write(que.Dequeue() as string);
                }
                //Response.Write("49076875\n0\n现在时间是：" + DateTime.Now.ToString());//主动给群49076875发送消息
                //Response.Write("0\n4111852\n现在时间是：" + DateTime.Now.ToString());//主动发送QQ消息给4111852
            }
        }

        private string ChangeState()
        {
            string msg = "您好，现在的时间是：" + DateTime.Now.ToString() + "，\n";
            switch (DateTime.Now.Hour)
            {
                case 1:
                    msg += "一点多啦！别忘了休息哦！";
                    break;
                case 2:
                    msg += "你真是工作狂啊，该休息了，身体是革命的本钱！";
                    break;
                case 3:
                    msg += "午夜三点！你还不准备睡觉吗？";
                    break;
                case 4:
                    msg += "凌晨四点多了，一定要把您这种忘我的工作精神上报中央！";
                    break;
                case 5:
                    msg += "您是刚起床还是还没睡啊？";
                    break;
                case 6:
                    msg += "早上好！新一天又开始啦！有什么打算呢？";
                    break;
                case 7:
                    msg += "吃过早饭了吗？";
                    break;
                case 8:
                case 9:
                case 10:
                    msg += "早！又是忙碌的一天！";
                    break;
                case 11:
                    msg += "快中午啦，准备做饭了呀！";
                    break;
                case 12:
                    msg += "中午好！你吃饭了吗？";
                    break;
                case 13:
                case 14:
                    msg += "下午好，准备准备要上班了！";
                    break;
                case 15:
                case 16:
                case 17:
                    msg += "下午好！";
                    break;
                case 18:
                case 19:
                    msg += "新闻联播你看了吗？吃晚饭了没？";
                    break;
                case 20:
                case 21:
                case 22:
                    msg += "别工作了，找个电影看看睡觉吧？";
                    break;
                case 23:
                    msg += "不早了，快休息吧？";
                    break;
                case 0:
                    msg += "午夜时分，你可要注意身体呢！";
                    break;
            }

            return msg;
        }
    }
}
