﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
public sealed class DBHelper
{
    private static OleDbConnection con;
    public static OleDbConnection Con
    {
        get
        {
            if (con == null)
            {
                con = new OleDbConnection(ConfigurationManager.ConnectionStrings["ConnectionString"].ConnectionString);
                con.Open();
            }

            if (con.State == ConnectionState.Closed)
            {
                con.Open();
            }

            if (con.State == ConnectionState.Broken)
            {
                con.Close();
                con.Open();
            }

            return con;
        }
    }

    /// <summary>
    /// 执行查询语句，返回OleDbDataReader
    /// </summary>
    /// <param name="strOleDb">查询语句</param>
    /// <returns>OleDbDataReader</returns>
    public static OleDbDataReader ExecuteReader(string OleDbString, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();
        try
        {
            PrepareCommand(cmd, Con, null, OleDbString, cmdParms);
            OleDbDataReader myReader = cmd.ExecuteReader();
            cmd.Parameters.Clear();
            return myReader;
        }
        catch (System.Data.OleDb.OleDbException e)
        {
            throw new Exception(e.Message);
        }

    }

    /// <summary>
    /// 执行查询语句，返回OleDbDataReader
    /// </summary>
    /// <param name="strOleDb">查询语句</param>
    /// <returns>OleDbDataReader</returns>
    public static OleDbDataReader ExecuteReader(string strOleDb)
    {
        OleDbCommand cmd = new OleDbCommand(strOleDb, Con);
        try
        {
            Con.Open();
            OleDbDataReader myReader = cmd.ExecuteReader();
            return myReader;
        }
        catch (System.Data.OleDb.OleDbException e)
        {
            throw new Exception(e.Message);
        }

    }

    /// <summary>
    /// 执行一条计算查询结果语句，返回查询结果（object）。
    /// </summary>
    /// <param name="OleDbString">计算查询结果语句</param>
    /// <returns>查询结果（object）</returns>
    public static object GetSingle(string OleDbString)
    {
        using (OleDbCommand cmd = new OleDbCommand(OleDbString, Con))
        {
            try
            {
                object obj = cmd.ExecuteScalar();
                if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                {
                    return null;
                }
                else
                {
                    return obj;
                }
            }
            catch (System.Data.OleDb.OleDbException e)
            {
                Con.Close();
                throw new Exception(e.Message);
            }
        }
    }

    /// <summary>
    /// 执行查询语句，返回DataSet
    /// </summary>
    /// <param name="OleDbString">查询语句</param>
    /// <returns>DataSet</returns>
    public static DataTable Query(string OleDbString)
    {
        DataSet ds = new DataSet();
        try
        {
            OleDbDataAdapter command = new OleDbDataAdapter(OleDbString, Con);
            command.Fill(ds, "ds");
        }
        catch (System.Data.OleDb.OleDbException ex)
        {
            throw new Exception(ex.Message);
        }
        return ds.Tables[0];

    }

    public static DataSet UpdateQuery(DataSet ds)
    {
        try
        {
            OleDbDataAdapter command = new OleDbDataAdapter();
            OleDbCommandBuilder ob = new OleDbCommandBuilder(command);
            command.Update(ds);

        }
        catch (System.Data.OleDb.OleDbException ex)
        {
            throw new Exception(ex.Message);
        }
        return ds;

    }

    /// <summary>
    /// 执行查询语句，返回DataSet
    /// </summary>
    /// <param name="OleDbString">查询语句</param>
    /// <returns>DataSet</returns>
    public static DataTable Query(string OleDbString, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();
        PrepareCommand(cmd, Con, null, OleDbString, cmdParms);
        using (OleDbDataAdapter da = new OleDbDataAdapter(cmd))
        {
            DataSet ds = new DataSet();
            try
            {
                da.Fill(ds, "ds");
                cmd.Parameters.Clear();
            }
            catch (System.Data.OleDb.OleDbException ex)
            {
                throw new Exception(ex.Message);
            }
            return ds.Tables[0];
        }
    }

    private static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, OleDbTransaction trans, string cmdText, OleDbParameter[] cmdParms)
    {
        if (conn.State != ConnectionState.Open)
            conn.Open();
        cmd.Connection = conn;
        cmd.CommandText = cmdText;
        if (trans != null)
            cmd.Transaction = trans;
        cmd.CommandType = CommandType.Text;//cmdType;
        if (cmdParms != null)
        {
            foreach (OleDbParameter parm in cmdParms)
                cmd.Parameters.Add(parm);
        }
    }

    /// <summary>
    /// 执行OleDb语句，返回影响的记录数
    /// </summary>
    /// <param name="OleDbString">OleDb语句</param>
    /// <returns>影响的记录数</returns>
    public static int ExecuteSql(string OleDbString)
    {
        using (OleDbCommand cmd = new OleDbCommand(OleDbString, Con))
        {
            try
            {
                int rows = cmd.ExecuteNonQuery();
                return rows;
            }
            catch (System.Data.OleDb.OleDbException e)
            {
                throw e;
            }
        }

    }

    public static int ExecuteSql(string OleDbString, params OleDbParameter[] cmdParms)
    {
        using (OleDbCommand cmd = new OleDbCommand())
        {
            try
            {
                PrepareCommand(cmd, Con, null, OleDbString, cmdParms);
                int rows = cmd.ExecuteNonQuery();
                cmd.Parameters.Clear();
                return rows;
            }
            catch (System.Data.OleDb.OleDbException e)
            {
                throw e;
            }
        }
        
    }

    //public static DataTable GetList(string tableName, string filed, int PageSize, int PageIndex, string strWhere)
    //{
    //    OleDbParameter[] parameters = {new OleDbParameter("@tblName", DbType.VarChar, 255),
    //                                    new OleDbParameter("@fldName", OleDbDbType.VarChar, 255),
    //                                    new OleDbParameter("@PageSize", OleDbDbType.Int),
    //                                    new OleDbParameter("@PageIndex", OleDbDbType.Int),
    //                                    new OleDbParameter("@IsReCount", OleDbDbType.Bit),
    //                                    new OleDbParameter("@OrderType", OleDbDbType.Bit),
    //                                    new OleDbParameter("@strWhere", OleDbDbType.VarChar,1000),
    //                                    };
    //    parameters[0].Value = tableName;
    //    parameters[1].Value = filed;
    //    parameters[2].Value = PageSize;
    //    parameters[3].Value = PageIndex;
    //    parameters[4].Value = 0;
    //    parameters[5].Value = 1;
    //    parameters[6].Value = strWhere;
    //    return DBHelper.RunProcedure("UP_GetRecordByPage", parameters, "ds").Tables[0];
    //}

    /// <summary>
    /// 执行存储过程
    /// </summary>
    /// <param name="storedProcName">存储过程名</param>
    /// <param name="parameters">存储过程参数</param>
    /// <param name="tableName">DataSet结果中的表名</param>
    /// <returns>DataSet</returns>
    public static DataSet RunProcedure(string storedProcName, IDataParameter[] parameters, string tableName)
    {
        DataSet dataSet = new DataSet();
        OleDbDataAdapter OleDbDA = new OleDbDataAdapter();
        OleDbDA.SelectCommand = BuildQueryCommand(Con, storedProcName, parameters);
        OleDbDA.Fill(dataSet, tableName);
        return dataSet;
    }

    /// <summary>
    /// 构建 OleDbCommand 对象(用来返回一个结果集，而不是一个整数值)
    /// </summary>
    /// <param name="connection">数据库连接</param>
    /// <param name="storedProcName">存储过程名</param>
    /// <param name="parameters">存储过程参数</param>
    /// <returns>OleDbCommand</returns>
    private static OleDbCommand BuildQueryCommand(OleDbConnection connection, string storedProcName, IDataParameter[] parameters)
    {
        OleDbCommand command = new OleDbCommand(storedProcName, connection);
        command.CommandType = CommandType.StoredProcedure;
        foreach (OleDbParameter parameter in parameters)
        {
            if (parameter != null)
            {
                // 检查未分配值的输出参数,将其分配以DBNull.Value.
                if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&
                    (parameter.Value == null))
                {
                    parameter.Value = DBNull.Value;
                }
                command.Parameters.Add(parameter);
            }
        }
        return command;
    }
}
