﻿using System;
using System.Collections.Generic;
using System.Web;

/// <summary>
///SonPagesStyle 的摘要说明
/// </summary>
public class MyPagesStyle : AQ.PagesStyle
{
    /// <summary>
    /// 自定分页样式
    /// </summary>
    /// <param name="currentPage">当前页</param>
    /// <param name="pageCount">共几页</param>
    /// <param name="groupCount">共几组</param>
    /// <param name="currentGroup">当前第几组</param>
    /// <param name="groupNum">每组几页</param>
    /// <param name="startPage">当前组的开始页</param>
    /// <param name="endPage">当前组的结束页</param>
    /// <param name="suffix">文件名后缀</param>
    /// <param name="name">文件名</param>
    /// <param name="recordCount">记录总数</param>
    /// <param name="defaultPagesStyle">默认自定义分页（此参数为兼容v2.7版本之前控件所设）</param>
    /// <returns></returns>
    public override string CustomPagesStyle(int currentPage, int pageCount, int groupCount, int currentGroup, int groupNum, int startPage, int endPage, string suffix, string name, int recordCount, string defaultPagesStyle)
    {
        string html = "当前第" + currentPage + "页<br /> ";
        html += "共" + pageCount + "页<br /> ";
        html += "共" + groupCount + "组<br /> ";
        html += "当前第" + currentGroup + "组<br /> ";
        html += "每组" + groupNum + "页<br /> ";
        html += "本组第一页为第" + startPage + "页<br /> ";
        html += "本组最后一页为第" + endPage + "页<br /> ";
        html += "文件后缀名为：" + suffix + "<br /> ";
        html += "文件名为：" + name + "<br /> ";
        html += "共" + recordCount + "条记录<br />";

        return html;
    }
}