﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

public partial class GetHtml : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        //这里使用了最常用的两个参数的构造函数，第一个是模板路径，第二个是生成路径，如果想放在根目录中，可以为空
        AQ.AQControl aq = new AQ.AQControl();
        DataTable dtclass = DBHelper.Query("select top 6 * from t_proclass");
        aq.AQDataAdd("class", dtclass);
        for (int i = 0; i < dtclass.Rows.Count; i++)
        {
            DataTable dtpro = DBHelper.Query("select top 6 * from t_pro where p_classid=" + dtclass.Rows[i]["pc_id"].ToString());
            aq.AQDataAdd("pro" + dtclass.Rows[i]["pc_id"].ToString(), dtpro);
        }
        DataTable dtnews = DBHelper.Query("select top 12 * from t_news order by n_id desc");
        aq.AQDataAdd("news", dtnews);
        //页面头部，页脚，左侧为了方便做成公共方法
        PageInit(aq);
        aq.Main("template/index.html", "");
        Response.Write("首页生成成功,<a href='index.html' target='blank'>链接</a>");
    }
	protected void Button2_Click(object sender, EventArgs e)
    {
        //这里使用了最常用的两个参数的构造函数，第一个是模板路径，第二个是生成路径，如果想放在根目录中，可以为空
        AQ.AQControl aq = new AQ.AQControl();
        aq.AQDataAdd("info", DBHelper.Query("select * from t_info where i_id=1"));
        PageInit(aq);
        aq.Main("template/about.html", "");
        Response.Write("公司简介生成成功,<a href='about.html' target='blank'>链接</a>");
    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        ////这里使用了最常用的两个参数的构造函数，第一个是模板路径，第二个是生成路径，由于生成的页面中含有分页，生成的页面命名规则为 原文件名_页码.html
        AQ.AQControl aq = new AQ.AQControl();
        aq.AQDataAdd("newslist", DBHelper.Query("select * from t_news order by n_id desc"));
        PageInit(aq);
        aq.Main("template/newslist.html", "");
        Response.Write("新闻列表生成成功,<a href='newslist_1.html' target='blank'>链接</a>");
        //这里使用了三个参数的构造函数，第一个是模板路径，第二个是生成路径，第三个参数用来替换模板中的{$public},生成页面的命名规则为  原文件名_传进来的参数.html
        DataTable dt = DBHelper.Query("select * from t_news");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            aq = new AQ.AQControl();
            PageInit(aq);
            aq.AQDataAdd("newsdetail" + dt.Rows[i]["n_id"].ToString(), dt.Rows[i]);
            aq.Main("template/news.html", "news/", dt.Rows[i]["n_id"].ToString());
            Response.Flush();
        }
    }
    protected void Button4_Click(object sender, EventArgs e)
    {
        ////这里使用了最常用的两个参数的构造函数，第一个是模板路径，第二个是生成路径，由于生成的页面中含有分页，生成的页面命名规则为 原文件名_页码.html
        AQ.AQControl aq = new AQ.AQControl();
        PageInit(aq);
        aq.AQDataAdd("prolist", DBHelper.Query("select top 12 * from t_pro order by p_id desc"));
        aq.AQDataAdd("class", DBHelper.Query("select * from t_proclass order by pc_id desc"));
        aq.Main("template/productlist.html", "");
        Response.Write("产品页生成成功,<a href='productlist.html' target='blank'>链接</a>");
        ///下面生成分类页
        DataTable dt = DBHelper.Query("select * from t_proclass");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            aq = new AQ.AQControl();
            PageInit(aq);
            aq.AQDataAdd("pro" + dt.Rows[i]["pc_id"].ToString(), DBHelper.Query("select * from t_pro where p_classid=" + dt.Rows[i]["pc_id"].ToString() + " order by p_id desc"));
            aq.AQDataAdd("class", DBHelper.Query("select * from t_proclass order by pc_id desc"));
            aq.Main("template/product.html", "", dt.Rows[i]["pc_id"].ToString());
            Response.Flush();
        }
    }
    protected void Button5_Click(object sender, EventArgs e)
    {
        //在模板内写好自定义函数标记后，在CS文件内操作如下
        //首先new一个实例
        AQ.AQControl aq = new AQ.AQControl();
        //创建一个返回值为string类型,拥有一个string类型参数的方法，我这里创建了方法MyTagFirst，使用属性Assemble的Add方法接收返回值
        //Add共有两个参数，第一个参数是模板内自定义标记的name属性值，第二个参数是我创建的方法MyTagFirst，注意后面没有括号
        aq.Assemble.Add("MyTagFirst", MyTagFirst);
        //第二个标记准备返回一个结果集，例如我们从外站采集过来的数据或者从另外一个数据库中得到的数据，首先创建MyTagSecond
        aq.Assemble.Add("MyTagSecond", MyTagSecond);
        //第三个标记
        aq.Assemble.Add("MyTagThord", MyTagThord);
        //标记都添加完毕，开始执行模板
        PageInit(aq);
        aq.AQDataAdd("url", DBHelper.Query("select * from t_url order by u_id desc"));
        aq.Main("template/zidingyi.html", "");
        Response.Write("自定义函数生成成功，<a href='zidingyi.html' target='blank'>链接</a><br />");
        Response.Flush();
    }
    private string MyTagFirst(string sender) 
    {
        //这里简单的返回一句话
        return "<p>这里是自定方法MyTagFirst</p>";
    }
    private string MyTagSecond(string sender) 
    {
        //这里本想演示一个采集数据的例子，但是没有对象站，就自己构建一个数据集模拟采集过来的数据吧^_^
        DataTable dt = new DataTable();
        dt.Columns.Add("标题");
        dt.Columns.Add("日期");
        dt.Rows.Add("AQ控件2.5版正式发布", "2011-11-28");
        dt.Rows.Add("AQ控件SQL收费版正式发布", "2011-11-30");
        //这样数据集构建完成了，开始构建返回字符串
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            sb.Append("<li>" + dt.Rows[i]["标题"] + "&nbsp;&nbsp;&nbsp;&nbsp;" + dt.Rows[i]["日期"] + "</li>");
        }
        //返回数据
        return sb.ToString();
    }
    private string MyTagThord(string sender) 
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("标题");
        dt.Columns.Add("日期");
        //这里我也没有做采集的具体操作，只是把传进来的网址放在标题后面来演示
        dt.Rows.Add("AQ控件2.5版正式发布" + sender, "2011-11-28");
        dt.Rows.Add("AQ控件SQL收费版正式发布" + sender, "2011-11-30");
        //这样数据集构建完成了，开始构建返回字符串
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            sb.Append("<li>" + dt.Rows[i]["标题"] + "&nbsp;&nbsp;&nbsp;&nbsp;" + dt.Rows[i]["日期"] + "</li>");
        }
        //返回数据
        return sb.ToString();
    }
    protected void Button6_Click(object sender, EventArgs e)
    {
        //首先new一个实例
        DataTable dt = DBHelper.Query("select * from t_cachesnews");
        //t_cachesnews表里我填写了一万条数据做测试，来测试一下用了缓存片段后的生成速度,估计耗时1分钟。
        DateTime timeBegin = DateTime.Now;
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            AQ.AQControl aq = new AQ.AQControl();
            PageInit(aq);
            aq.AQDataAdd("newsdetail" + dt.Rows[i]["n_id"].ToString(), dt.Rows[i]);
            aq.Main("template/cachesnews.html", "cachesnews/", dt.Rows[i]["n_id"].ToString());
            //注意这里循环调用的Main函数，不要new新的实例，那样就无法共享缓存的片段
        }
        DateTime timeEnd = DateTime.Now;
        Response.Write("开始时间：" + timeBegin + "<br />" + "结束时间：" + timeEnd + "<br />耗时：" + (timeEnd - timeBegin));
    }
    protected void Button7_Click(object sender, EventArgs e)
    {
        AQ.AQControl aq = new AQ.AQControl();
        //首先开启自定义分页模式
        aq.AutoPageModel = true;
        //要显示的自定义分页样子，AQPage是分页的枚举，具体的功能可以参见帮助手册
        aq.PagesStyle = new MyPagesStyle();
        PageInit(aq);
        aq.AQDataAdd("newslist", DBHelper.Query("select * from t_news order by n_id desc"));
        aq.Main("template/CustomPage.html", "");
        Response.Write("新闻列表生成成功,<a href='CustomPage.html' target='blank'>链接</a>");

    }
    private AQ.AQControl PageInit(AQ.AQControl aq)
    {
        aq.AQDataAdd("infofirst", DBHelper.Query("select * from t_info where i_id=4"));
        aq.AQDataAdd("infosecond", DBHelper.Query("select * from t_info where i_id=5"));
        aq.AQDataAdd("infothird", DBHelper.Query("select * from t_info where i_id=3"));
        return aq;
    }
}